/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.support.PemKeyReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PasswordException;
import org.junit.Assert;
import org.junit.Test;

public class PemKeyReaderTests {
    String pkcs8RsaUnencrypted = "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQCjoN8erWPxjtSr\n7fyINsGEDmix7dmDud21SHIxIPLWAh28f1+67zYlySAW0RAQcH6mm6AgHUOTMJ1K\nGeEKdUhMfJ9r0RTrFEYfCov75MvmkaXBt8Jr1LTqDZJFz96TZPNRa30j8L5LVS1E\ntNT60dAjCsHJlkl8vGnj3cPZpPT5xhliNmfi11Gz/9QPajl5BtT88yyvu7A4a7J3\nhn32hx6VNKU8VN96yqUx6BScN+0Q2WeT/+2IXvTLqSgfofx5ocdGxLusIWD6tIMC\n4R9CrYT795qo7ZYHGR3YmnWiLrD5upPsMaa8geXEmNmekh1sTj2/otPwuOLvqtR/\n4WoNd6wJAgMBAAECggEAToPH7Dl5BpTpuaIVleroSox7cj1WLR4Ho5Aisy5DN6uG\nR0e7UMCt882hZzFkCu9f5mQwnphML5mZL9BhKpqCWalG+f42kmKFDyoJZ5IuwPFM\nXzrkwMctFE30zSjkfUdodb4lKxS+yvkRIrG+rKf2vonP2QITOxZRnTRxYMMFhb/j\nKXUhfHqhNagUJLlaLR2dqdMGcxDxzoO9J0JZ1ZuymKx8v60Gb+oa+aQ7B6rkDCRt\n1zVH/2JefznI26NETpo3u+2mGnegk6NeS/+e+AiXoPi4MMWP9RgMXePBxrIjhdZv\n1sek/ioQuZiqC0iEl9jPvVxVJzRBen1IEoAO5C+iTQKBgQDUkbPCu9SEYFOyIRtP\n+D1kUDEEDQcnvHfwpTQSD5bOuJlrYrAnNVRXEDj+vVNNg7wUBLdwgRYpbUtmmpuD\nF8dVmuRRe/+XvTAAxuv78PMeX8yHcXs6Xfz0griKpW1yNjMb4hRgy08Vp0vdfd37\numbaO5CILAigW7ewwOIdYa1LLwKBgQDFD1qgQT9WtOb/2wkEXQ8iYd/1pD+suQb6\n3xlF7RjNUqltkyF1Y1NsXCghw9mxUF1rClYyFHYMpuv9Po78VZS9o5gslBG1OF+G\nsTueyJwtXknBh2w69lcxpcpYYMvgB+cwje612orhNm+cMLQh89T6Vj86dPSSNDm2\n+u+gIJjORwKBgQCPhYTCsYFOk59PAO1o9Cm3RjGiE43GNYkh0Nk0bJQdJSRpDevz\nvR0h35Er5faNuqlNNtYIPxAQjnu/Xhory+1Jjlgj8D3lXNZBYA3LQKdV1cbJmERk\nZzs4d95TtlgMKi4d4Gpz5DGUZC1j8ezkXrm9FUSDvH9ijiqbS9AfmGih/wKBgDXH\nC+diBwQFmGjIgLx1HPU4GqNxsILVd8cs7Tu9CaC250/k8COV+KVAvR8B0L3n/aaB\niqZeGR04zHwu/1xzioT6SUQZIIABI2iho3CgtKZY7e3npCyvH3qIESFvQRQhdAE3\nKqbsPixZ67mHPRFq9nte4CB23Gut3vZFovFjE/BvAoGBALi19Kp3Ua3wOKJ+yInc\nVMpxpZ++MrDtCilxItnicU8CiyQWI87wSH3tzuAyIAaT36BqhxKgtrvzP8fbtDWY\nKIeOxMrUFHhB0SbrepXtGk9ciwQvPh1LeFK6+/WAuYxMxpLVyyM0BR8zwMbj7WvX\nev9LcAOIHj5p4Ba8qU2H79Pv\n-----END PRIVATE KEY-----";
    String pkcs1EcUnencrypted = "-----BEGIN PRIVATE KEY-----\nMIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgzIhO4afsWKZD3PYK\nevG4vTKzwn00CXCebT2GlT2S2oOhRANCAATkXfix9bTFELlMMpIAuqElxoNv+196\nK/Fz/5emiuM1D11jr0+xUHooX0FeK7bgc3Cyr9gHeu3V/oNKvGoCaRzj\n-----END PRIVATE KEY-----";
    String ecx25519 = "-----BEGIN PRIVATE KEY-----\nMC4CAQAwBQYDK2VuBCIEIIgx/WX8DixMbUqpfjTIHghpHI+SqcbLKq07kTIEJ2Rb\n-----END PRIVATE KEY-----";
    String pksc1Unencrypted = "-----BEGIN RSA PRIVATE KEY-----\nMIIEpAIBAAKCAQEAxdIerNOqVWsOZ/pK7jevdsdYt6zMe+DJsP3vtjIqnG5NKbkZ\nWSfLz9T9mn7idr34QdJGqQhqfheMPr+L7p/angBvIXIk6FzesKWyBO9BaTh2fIoP\nKL+sa4cSTumFssWhAFEzycrh3uBXrY729TIq+rQnLtIwwTzJDwvhMei9Mcs2aBqo\nc24BL8dqVleIU5aWTIqeSfanfUIv/C1OFtouho7OsDQhsVe5oxwtVH0un/y9aA4A\nEUcDKRmdjfAvgP/Dcx/7DGmROnSp4woBnA7UPeuu7KSjfL50EHKDP6a2iaI2Sr5A\nHX8wrLER3ffnf3DG3bu+bBbGV+v3XaAe89sPCwIDAQABAoIBAEW2GTdAVBtL4cTE\nkFlIaF4MO/hmPZ0+BvWHV002eour1ydn4kXn30v7O++Q3U+I/I59gocYvyZ2N+b4\n62AJFyps7ryzk8wKxjMsAQL6KWviCOc0Y8kxWpp9+/axFnt8Z5NMClsHUveOyXcR\nFXgs2LaGe/Rk/+do+1WBEzfaU6nS2zDQ/yk1Ax7yYdzrPKgbk5G15ZxRSraepogp\nvbFcQOLGiXDzbWhFSMNY+azs/WkBZ96I4p0yt+iFMi7DHY33OlKCQ7yOJzo486yl\nuRj2ktG2BrEYCkVlXdoCdM7ev8SSJoDx9Ea1ZUnPxat+W1u4geZrHY1vWQK+15wb\nkDZz/YECgYEA64SsShqEb5NDxKAlXta5RPdqAWP+VwLymSUOl7pG1ynturLeqpgc\nT8inhXZ/qjOBiPf65csvwJpjJRGrjvSZ/wuU9V4FN/bMyiDSQAQC5Mzcnppkak/e\nf1S6PWsLDlW+NnGheg/MymXu+al6PJaUKRyVWM96fLkKLYCvsLz4qksCgYEA1wYw\nxXoFMv5GeSXn6/mnJo2+HHJvjTYojvjnKF26nIecXV1UEIkfvBgtjCVB2bWH+coh\nCM2viiw5eOsOTDoB+uCaZNV3cy/movEOn7kEGdOA2rQZGgAbogx31CGyEv/wEdwO\nS22BURSLRo7f9PRHzEQ5znSS56/MfbCcGE7kNkECgYEAvaJhG3XIhxJbcZnFHVzl\nZnuUtjPuWd88uUTWQCMz4RGYokhd85xwx2j4QgVM/B1mwoNxWM/Gzl1BUVqt+XhH\n+s03jm264/nroSDWSccxEUtGpMoJ6nQO4hW1s7hZ+ZvegXXzIBZSvfFff1UP4HMa\nLxQdyJmetYhEgqjoTfWKf4sCgYBVTg9rSM1nPZmX1oH8DD9T/Ee/4WaAD0xn7DdI\nvGacUvCl2bDQHpaIeM8ZGm7VgD9Byf7xDyjlGEZ0wkwZ0amXbiPSfR22hPprCldS\n5oPJ+y7TlT+gIQrVbzza28NZ5k/HxhWltvvmvs/CXkxbUc5qK2cDkRv27reh5b8H\npcTEAQKBgQCRzpGGJV+2FbdumvW0hEfn/0+2huQFNr+w8ZezU92FNkzF6X2kLXJm\nnEHFuCV9LcMDIn84jCQ23C3GhRzNP5BiEOst9Qd2Mpa1Iw+tkFmwpnExcDXOJ4Vs\nVdb4KAyEoMUmu4qxPDoiPWXXJ/9ymhca01aBr5CME5n3T7+E2f2hUg==\n-----END RSA PRIVATE KEY-----";
    String pkcs1DesEncrypted = "-----BEGIN RSA PRIVATE KEY-----\nProc-Type: 4,ENCRYPTED\nDEK-Info: DES-CBC,E024957E1F58275A\n\nsPCVHvaSDzF0rXqVR1T6jkcwh/8MZ3hdNIO1vGnQM0r3wiMux/AhVjrMTJ8nKo9B\nX/PLMn+Y+5JXjzkpLGuuWjugy7yHwA0YDGdnDAWcysubvgSpRfIggP8YRetB78Dy\nFM5TVdxhLQ6r38tEizO+kUiel3GZh6cXrroGnmdj1J63e+hhH7qMs2r6sWtM25iP\ndWk8wJoo5UW8G/zhH7umKp2NAuzvhjsFd7G/2Lxpi3/3XwcmsuGOVL71c8ZkxCp/\nyJzXp3FIJrxPMxHwk23IIG0LBm4YfjEwxaVHRZ+IZ9fiuKUsjrsn3yZMv1p6+gkt\nryfoV0UOVw98hzZvuc+38u5eRHh3UBjqOftFJrRZmbjdYC+ZiEj2PDZevv5SdC6Q\n8eIMskKW6BT3kvSbxVJq/0crufT3Z969Vrz6xZ0gdRBP2YmUKNm/cO5CT9syw6ab\nya6t/Nk1nFcG7NzNn6jAFZN4TqOrBpnIm5eb0/jwoEr+7Hpaql3WgzOlkzi2oZNF\nsdHqag13IU36PI183KckhNwg/6cCuQnmkz1cM8Jk7kX34akAOIL0nadeEhar030E\n/xUp8sPVH7GKuvrPEZd97AqwVHTc4hS5rPqz1II/uoiwSSSZc6zL3hDfEkjj8NmY\nhes2UiCNUqXfceV/osLYFMa7kz2JihJRyjFzT5MOP2JCxIl84NaVmm7cFJwmJ9IJ\nLGOBJU98VyfzlA8xBJn0jaeaCpB2GWZxqB8yqV7BwYpxom2sLNd8VndaEjtDbjGL\nzij0Z0Vyy8b0YCVEqkX1H0iANA/HJtx94dGpjOdiyJJyd1grL/PMycfaL4wETqst\nSfmm0vkF8pFK621T9FvSH6kEXVxYD8mawVci1tle4Bv9ZpgBkWxVKg+juUkAS1cE\nSw744tW9aOlaj+Q8StPQppSj/xuIc2eJ/XKQp6JVTQRHEibm76mFB7TQ2Qpelpj0\n3EuvGin9rbCDLqz77eJUhauVjPe/1vq85zuQABdCa8VN/cENsPbpuWKVps3GQ8rP\ncDar15pt82ODFqvyu2FhKJwgsEjIASWhDBbnZEU/0cksJ40HLZmCORTpSDEa02b7\n58s6nZfRYjeNH0IULawGz2jXDhklwyfckqSMPLv5KL4v4T+o8m6N9GSK0/MmRLCI\nEehJl7SJJk0/WCMvzGEq+iW6XCYziNoC8GW9evKCduMBcJUh0YtdSj1Gtgz8iyLP\n6NZBOYk/6OfOA1n/C4VDYmACgZM1jU9VhnVb2/ujB4wh/k1+e+4Th5nFtdWUbGwJ\nZ5RMfjQ0nn2QhHJxtU/uT02Gs3RIgtq2jEDbE73TTRcj1AcAkVHixKXV+sFu97O5\n1amySehlaq2XQgQ14KyAsUThhufYt9eEBuLAE6yOOI9bjVs1aIEUsqPuIjmHh4G+\nqgDULkQZaxIHQ6VggVhlJ/5w/12XGi87+c5RmNGn0w5TkdWBwYhwJO3WynW2SrtM\ndrxDYoD3BptR93ug4FMTHeylpkJ4500U57pMl3YfefEZSKDvWYpdX6GAi4uXOKps\nin5wjoqBKbZJUckJVZrNEti2DHuPu42jzyCwSw6HILeveX5nMyrpkw==\n-----END RSA PRIVATE KEY-----";
    String pkcs1AesEncrypted = "-----BEGIN RSA PRIVATE KEY-----\nProc-Type: 4,ENCRYPTED\nDEK-Info: AES-128-CBC,8D52BD039EE337E079C8BCC9B91D4AF4\n\nSbbn6beIA2cDZi/5Q0uIhQnxSN3p/lQ6ofiyvW5vV8um6C1c8AtRFPmo61sCuJir\nRlZ5BnCUkf39A9T8pC+YJXAMZhOrWLRluj4BjoGB2XmOLooP4xkOj8k3clrvbFp9\nBbXdTl7dSRxqdH+4hbpy00ofgcqqTP4K1/UMYRcp/Caw9BfvLNXzHH2rPtgBBrho\niDO5eEzhigRx38hMJ06rzRypNPEzPvphCvVD55QcD8jV7XbqzJ+yHTuEog6tNDjC\nu/rVvoVwZENTufABv1apg2VaQnVsMzKbVOkjp5TcYfOZ89UqUANgiB45mGqza2xB\nffa9AzAQXKR0efbwqMJss6aKsVfGfCrmKS9/ANACcnbFEjxqKykSK2VBzoGY1rOv\njAIzeo4BY9I42v0a61uaGgBz1FaEgm9VP2i8hRDaiYmJyGSe0zoMXDbOhL7yO2JE\nWGFsGkrhDVD4Zan88c4clOvMumUoQhqYDSyk33rWZHArZun3NjQuaK7rrF3hSfZK\nP0hUkPuDMgrTacD1ACPiXnmn7TN2J4lJZ55vdK2jnCru99xKVCly6brTIIfsoK7v\nOH617yiVyMFVoI3+/U5cBLPOk3oZ8229MYMVlaq6kVaNAt7TUM0kyvnk7ZUwPL1L\ntXeL4ny9KU6kbbTekdMJb9HjSgcECMN6yRkjTGwb4hToF4hdg3lJpiGJuJ4Z+CZk\npl/cy5MFGddsJVf8BFn088xHpMxOGyx156skzEjsRJMWCjuDUpE4sLvCiv4UDAE1\npb9H8pqhR5MmqXM5er32z1LBF5r6/1eOdULh9j0EW6RCkGk7JZWNSNJZlzvIAp8U\n3YbMgaifEhcbe3H+Q8bjlgWHnCTW1fccvAL+v8hjx5XgTb6/nh9YY4vkV3yT0AQ0\nc3lztjYnZKxueMKi8feE2jn69VYBwLcO2cUV+uTZ61oJXLRRa+XKPuPap5AZoCVh\nfPU8p6FE+wqLEarcKSvQpnuZXWrqoxTVXO0tXopSyg48uWBhk4QB5V/AqRaSPaJd\nimTnxHvL9rNA+2jWtdidw+dqxa9fLqq9bMuLyDs4+qoAaNMhPTlTRRwxdATCm29D\nAoNh4s7NhpsgD1EF03sfkuf5ANBEwy5nw3OvPbHcuBWaOxJGgqo+fLBKLGj1cPVq\nL6BtFacSPUPq9NzZfEcXzkvzO189tmM98IKtb5wdWPosJYdnf2icauwZUaHG13UR\nm6kBJPttBFzS1SO+c7mTFaFADhWcBC9ew24djbQKDAefXzEbnzLPDWFvQH2QjxNc\nfquGRvaMXNHaJtxsj+OvUQjF+1sfEhDEbfB2evgFiPdiQl6mMSKIySwo39e+52hw\nZB7ROOtNt5QhpvlkVEZvhvkoFke2Fp7VsINoYU1j/U+6eEfFE559rAEVUTtV2ES/\ngfNwVRhdPzRbZtFf3mS10sh8wxjoMe7cHleGJe38eN8oWqJ0BUw8nEgOpQENLkMR\nkUJv9wpoptnECBJijKRVkyYheRK+VBbxQoLHwHcA91iAZiaAxG+Khjm6W9Q8030f\nYgeEyDSx999HE0AzfiDe/PgSeZ6+raOv9DBsULH/do7nvA6L/UNdDkVHapCr+5II\n-----END RSA PRIVATE KEY-----";
    String pkcs8AesEncrypted = "-----BEGIN ENCRYPTED PRIVATE KEY-----\nMIIFLTBXBgkqhkiG9w0BBQ0wSjApBgkqhkiG9w0BBQwwHAQI2hef92wcFT4CAggA\nMAwGCCqGSIb3DQIJBQAwHQYJYIZIAWUDBAECBBBDDiFq1Knrrxs2P+CgDdgiBIIE\n0DqtZGpSh+iXjAM5hobm7GZkwlOHGgQV3i1Idd5n4BOXn13163zvLhYKxXaH94YQ\nFQjCeLpxF/vz+n8cly0TiFhGF767565Fct/iK9CbTx5nCZDsIa8zXIXuQwRB7y18\n2lI1g775+T2ydGiEhqKQ413+Qpyf+kVeh5e4kB+Z07F047kY3g49kSsbBYoGoEmK\nBRb7EN+ovgTJ1aVNrDC/6/+6OUHaNhqLjW3m+ZrrIzDUGo0UPHzfdVQf4jLb9KhI\nqGXuDcdRrs/vqTn9QhsmxzMfMxt8MzMcdPcWSMjt9EaYvo2fLDVBOz260bgVzkym\nOsnNEgIehpB5VH19Y1xtVrO0ZoIFBozEs5gTsLN78WaRtG0sohu3np0scC52tk/J\nqM9Otze4i2XC6dTh7ti+abUcpBF6dvdWTvpxnqdIc4v5vTPcDndQRtXzcbNs/K3r\nuSRIWP7ZUoMwhB6aBDWx6eqg2lvuoRcHnjCbL2BB0CX/O5prDpSaiVR+IJt/xWK6\nrpseZYVnryOk/QWrPZ8Cqaea8+Dua2/rZWYGOP2j1XbLmOfe/A7veIBsFPD1whmz\ng46HFwH9UhbfwiGo4Ag5InoTtPVcgTkGo0VcuMQyl+Mbhhwfs92gqto2+zEWcoVp\nnZ6zIjPbbCepRcArJLP2YHTxqr/mWNzVGedA1oiqbuhmlfbva1flZDCCQXqShJdl\nu7tcPEoJobrhcGaC8NdxCAKSscwOmZ/QmYV+uFhCqMkMPzCi1w3kiIfn5SYF7rUS\n6M6mZ8xbR8vi5ylLyJa340JFw9C8tpg6YWKlD7UiAzmIh6o/dl/40kYSN1RafPPS\n6MbBZAQdB9hQ/oc8dY/acxVQgYUD/z7G1v3Ib5tX/38A3uqnqBv6lNbQq/lP2cS6\no3iZwq5QUx+WeVKF3hVxbFfSVUxmZ7Z9Ib7u6kQx1iRfCKTnEHFDoCtP5LA0SxPQ\nU3ygWUem+LGkdWx/4c3zgyPQZsahHrKutJx+O+KdVk3oAo11DRZkR71Wdtyisd5U\n8gl2ENEQ2ydiDyELRU38pPEQU2jlUNRNFnBem1NQmFwqMVsDHfSb5YbvHSWAnJzs\nya2N8YfM93s7PoiQv39niHTiG8tP6hEB+vqEvlWN68CSGNGaSv1YXWPNzhHpPJDu\ngGfbEGBiCorFFFx9r5P7XfJL0bvApBbUXQYyyvMENMyN3Mz7ktV235BT7w/Wm+1V\nu8xbZahicLIBe/EPyi0OUBzMv3JBNjuHgnw0+HkCYz/y1cNATdpdOFc1edljuwZA\nfo8/xUWR8LfL0aIciMgC1oJa1MXBT2JaZ9/WJowWlIYx/yiOP/DRkiJFgyDXtWRZ\nelobS9irlCxxWFtz0PllNK/2mHDB8a0F5iDJF5VnWXZZd07hjaBbmrX4sFdEDqac\nC3TfjjcTocGzVw1KsOL6DD2vKbnddstu2sGMYWF6pA/oEmGl2Gxsh6qpcz5Gsf08\nb3aeYuDRKD4bxN0CjhLUyJrg2oQlp/ldjTahE1qcv0WTFqoe6g+97djtAvtzTPIt\nKFqEgPIdjPb3Aq7nwf+PDV93jDYOAJ3uMh9Pvw9/oyiG8WBIlfJWuyobkfiT81TZ\nvrRRlhYXuQ5UqwvmUSbv5M0ty+deDAYtYS0mEGSfKMM2\n-----END ENCRYPTED PRIVATE KEY-----";
    String pkcs8Des3Enrypted = "-----BEGIN ENCRYPTED PRIVATE KEY-----\nMIIFHDBOBgkqhkiG9w0BBQ0wQTApBgkqhkiG9w0BBQwwHAQIYlEy1doijroCAggA\nMAwGCCqGSIb3DQIJBQAwFAYIKoZIhvcNAwcECHSg+QpIE1bRBIIEyE/u7YuXxksq\n6YZPo3flXYtJM8tYhe5ZxMdROhzquMdtz+VYa7S4slCl4U3d3xVWS/DocGsfO5am\nQ1v2v3btZq/Px7wciOXZ7IcpMayVzdqUN0HhxGqBf1My0f6YPWjBOo/Y3tZqMxar\n5gDsl7iwOwJwhSExfPril03f2ZC4v0jqLx4Jptj2ZyUw2HZzYzcTI7mYzIWCsFky\nS6nbF+/MKjI2ZwEBMyiswV0AL/H3PEDgUnT0ERgxmUqpap8kj6jCvK8gFYnUaIti\nFi5RyfqNfPWEuVfBRjGNY8p5hl37hPnDWhuIrRjjDAnn7IDz073uaQRXPdfI8dZj\nhdMRxmx3+lXlHWYRtpaFrJkF/YixAz+heH9OQtB/2dpCCAxlDdpfh2MGkVZm/4an\nZOkG1InSA5gckbIFVQRaq25xX+cUgsnoy9qPWI5djR305hvJj7mHLW3FB1Cs+dP+\nAspa/YfaccX5zM+y5xbREUEn3Pszm1fcUYd7p4Cw+uJuz4FAatAHfI2eiKdaPpwj\nkbbF43+mH+6FRwg82OpTWjb2SA4Xl6ULfZMQntZzaIFG8n1p+bp6rO91hYlVzofq\neGPRwoR0aabyujNqxvj2gNQWp396NsaIZFyXo7+B5grWMSik9CYHNKParsbz8JZ1\n1lCPMD4WKlVdyAgTVFkkBGzTeCRgfxGBGwM674zGW0rW+Z/92y8sAEj6kvfnop4t\niC7gcPKe2lktkge/NiAOz+V2+HH9coqzW2Im9sWAyu+A4X//MfrHlfKyf80bLcRD\nR099zDMJTYXCHBA952S07VPUnQCFXlCWEaGv8cMMqmAIE5ubHAfa38pSIccf3qUe\nPoOUnIykCLXByOm15CJoLxmrAXunalEQfjuhIenwMccUmjwigDFJ2IS2VyrfKBi3\nq+J9Hj+K8Dw6fI3g33TnbAFoWrYjnUizphyH/AEVQiKifbhQhDcWEEgYpZDSKRqk\nCYQq9DPUir815oA7VUyAt/njiTfu0Tltmf0dEScPPH31E96rM5OIfwdeFKyj2QhM\n7VLFsrUVm2WKCRD7PIFHC6NihmNQc8nGyHATs8TE3B3DzHzahDOFlpwvzqkGDEMF\nl+jZJi1YwWLQcEK7Ty32Js8xsNhSKNRMQEgpl+V/1MQ0N3wNMurvtBfHX0T20/IK\nVH77EZLdcq5ClOQtRomBxvyyX7WwwxTk1MdM8rmzW2UL4Apu5LAAaJS+gI8ZfC19\nIcZaspUIZYqdC80Q1LvTiAHn1IweuGPRVYFBXonfCUSXExZOP3ReBPelrKE12Dqt\n7w3XQYH68GDKCLze38g4zFZC/qGxhUReDHB+R5rtPaUEeu9K/9b9cfx/q2Kpf9oy\n3UKI+3r2mUjHXFSnYMIVbH8C+bpqKK/YvXykbX73I342b/jRvBEmXW1g7qpLVcoL\nZ46YbCsa8zpVymrA1OfvGGYqD1isbr3M2vMzjlCHZz0baxJmSRmHyFhDcD12ijX8\nNtbdMDSn+38aFBhgv/sCGTA/DaBBcTj1EZatbJ6BN3qYjl2RygAp+Q7FlpGWOBH6\nZdLOF6RMC/FtuXZHQ/pxvXcmIq5zDJ+zzpvGlvJKh3z4MG21pGOcluFmKGcyDGTE\nc02nnVqDtm89hnum91EMaA==\n-----END ENCRYPTED PRIVATE KEY-----";
    String pkcs1EcAesEncrypted = "-----BEGIN ENCRYPTED PRIVATE KEY-----\nMIHsMFcGCSqGSIb3DQEFDTBKMCkGCSqGSIb3DQEFDDAcBAh8rIfuvCTQLwICCAAw\nDAYIKoZIhvcNAgkFADAdBglghkgBZQMEAQIEEJdOgBxCF+Megy0atscnDzkEgZBM\nimiYV6lJfskLzbPwEk3S34deKplDptfsn7Q/lpBfHL3zrCHi6cIHR25ch0kbMS4R\n6EAF+kkBX28UiBQwFBMIdMuuV4Li8nYJFlARiXTWdh69iS+wjHrKOyluu0AN4Lif\nyXV/3zCBQk19QIFh+gM9Ot5toINLmJ+GfcKC7p6+HttEL5GQduR9lywou94lTGo=\n-----END ENCRYPTED PRIVATE KEY-----";
    String dsaUnencrypted = "-----BEGIN DSA PRIVATE KEY-----\nMIIDVwIBAAKCAQEA3RxQD245KfUv4C4Qjw7OBl3KbA1NveyMLGvUoXnJ0dYOLLib\nA76Zflxv9hPbwVntqSBos47h2nXRk/aomYdzN+3I2rrUMKKI7HAiws3/o43/SgJm\nNfJu/2dfqqQyh5+iEMFGQyV4Mvq0seGTbjGps0zYBKDKQUwZRHykIpX10cFc9dFR\nb/aq/tO+onkD4hC0n5v1IfsctmpT5aq5OugbbNlDRT+0ef4Pjfa44WJfXyGQL1jL\nUFBu7ObkhnA2C7LmuToafxdOKzc2PCpPO2ZeBxVHyLX1VUn4gOgQKhFiUlNyvbnB\nfYWC31UP/8PwgfOMY6vxjTRaROI30mquT4JNpQIhAKDMJN7X5kcOgdGgJQCpg4zN\njb1pg+2+UQYx33aBUK85AoIBAQCZ+tPGH4EOxE8vjX4ghaAw7WWr+HWJbzzEIocD\n89qM2uHYAvNJ7sHNe3oe34fNYESY/JqkUymx6Yh1YOD7dMc+ohlMsE8xT40YRGif\nADW6G8Jv4hZ3i7n36B0Llq/fMuhWDhi7ewwWWhrnaSqkWn+Idk/4Mzn9AYyipRoE\nHc1hHHqPkcWgv33mgEtq2KLivd3sL6Y2N5NvcwNguvoZK402kt2Ho00cuMsfNaQg\n3iXK24rXS/ibnyuBsdH4UA4oBjg/1ZSlAh2BMhC9BkTg46r01pWNmu5dMaGu9mNh\nJFCz8DMa20cP4D2qP/nplU8jET20r29f2sxuqk8xlAgvFMwBAoIBAQCYVzyuBbin\nrNcmnBkUQh252W4K/1MgLNSH0rGXSa8eicIyxvCPNAWuallXu6ZlcRzHOWK97ehw\n8io6aLh7xtgzknhD50Frgd1YXehHmm3MOc+w5gMv4LpOLRategsqSLvRJu0d37Gy\nZRGEjySXE/Ct+QtSSnP5siL+TnrTVYBDSM7gNcKmWXTYZPQPEtL76YYOGBIekMAO\ncfFBoWBkrOu2ZCwx9vJuSOLddNONXKSa3aSTNNO6a6Y4VW3CrwdQRL/t+4jp9xKL\nJ9Gu3wbKQEVLRzDjp50vFNh21g8YRkoVPw4tXiZbMBXE3IbrtJP0Sh/8wtLhRqLc\nFQ6ByXx0LSjiAiAYyFt8RA11JwKBr1Ac3JEESuMWxqL2fHH9UUrxHidDAQ==\n-----END DSA PRIVATE KEY-----";
    String invalid = "----BEGIN PRIVATE KEY-----\nXX4CAQAwBQYDK2VuBCIEIIgx/WX8DixMbUqpgjTIHghpHI+SqcbLKq07kTIEJ2xx\n-----END PRIVATE KEY-----";

    @Test
    public void testKeys() throws Exception {
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs8RsaUnencrypted.getBytes()), null));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs1EcUnencrypted.getBytes()), null));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pksc1Unencrypted.getBytes()), null));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs1DesEncrypted.getBytes()), (String)"12345"));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs1AesEncrypted.getBytes()), (String)"12345"));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs8AesEncrypted.getBytes()), (String)"12345"));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs8Des3Enrypted.getBytes()), (String)"12345"));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs1EcAesEncrypted.getBytes()), (String)"12345"));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.dsaUnencrypted.getBytes()), null));
        Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.ecx25519.getBytes()), null));
        try {
            Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs1DesEncrypted.getBytes()), null));
        }
        catch (PasswordException passwordException) {
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        try {
            Assert.assertNotNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.pkcs1DesEncrypted.getBytes()), (String)"wrong"));
        }
        catch (EncryptionException e) {
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        try {
            Assert.assertNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream(this.invalid.getBytes()), null));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        try {
            Assert.assertNull((Object)PemKeyReader.toPrivateKey((InputStream)new ByteArrayInputStream("".getBytes()), null));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

