/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl;

import com.floragunn.searchguard.ssl.CertificateValidatorTest;
import com.floragunn.searchguard.ssl.DefaultSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.test.SingleClusterTest;
import com.floragunn.searchguard.ssl.test.helper.file.FileHelper;
import com.floragunn.searchguard.ssl.test.helper.rest.RestHelper;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLConfigConstants;
import com.floragunn.searchguard.ssl.util.config.GenericSSLConfig;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.NoHttpResponseException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.PluginAwareNode;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SSLTest
extends SingleClusterTest {
    public static final TimeValue MASTER_NODE_TIMEOUT = new TimeValue(40L, TimeUnit.SECONDS);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testHttps() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").putList("searchguard.ssl.http.enabled_protocols", new String[]{"TLSv1.2", "TLSv1.3"}).putList("searchguard.ssl.http.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.2", "TLSv1.3"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"}).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        rh.keystore = "ssl/node-untspec5-keystore.p12";
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=true").contains("EMAILADDRESS=unt@tst.com"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=true").contains("local_certificates_list"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_dn=false").contains("local_certificates_list"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("local_certificates_list"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains("\"searchguard\""));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains("keystore_filepath"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty&show_server_certs=true").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testCipherAndProtocols() throws Exception {
        Security.setProperty("jdk.tls.disabledAlgorithms", "");
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.enabled_ciphers", "TLS_RSA_WITH_AES_256_CBC_SHA256").put("searchguard.ssl.http.enabled_protocols", "TLSv1.2").put("path.home", ".").build();
        try {
            String[] enabledCiphers = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createHTTPSSLEngine().getEnabledCipherSuites();
            String[] enabledProtocols = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createHTTPSSLEngine().getEnabledProtocols();
            Assert.assertEquals((long)1L, (long)enabledProtocols.length);
            Assert.assertEquals((Object)"TLSv1.2", (Object)enabledProtocols[0]);
            Assert.assertEquals((long)1L, (long)enabledCiphers.length);
            Assert.assertEquals((Object)"TLS_RSA_WITH_AES_256_CBC_SHA256", (Object)enabledCiphers[0]);
            settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enabled", false).put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enabled_ciphers", "TLS_RSA_WITH_AES_256_CBC_SHA256").put("searchguard.ssl.transport.enabled_protocols", "TLSv1.2").put("path.home", ".").build();
            enabledCiphers = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createServerTransportSSLEngine().getEnabledCipherSuites();
            enabledProtocols = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createServerTransportSSLEngine().getEnabledProtocols();
            Assert.assertEquals((long)1L, (long)enabledProtocols.length);
            Assert.assertEquals((Object)"TLSv1.2", (Object)enabledProtocols[0]);
            Assert.assertEquals((long)1L, (long)enabledCiphers.length);
            Assert.assertEquals((Object)"TLS_RSA_WITH_AES_256_CBC_SHA256", (Object)enabledCiphers[0]);
            enabledCiphers = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createClientTransportSSLEngine(null, -1).getEnabledCipherSuites();
            enabledProtocols = new DefaultSearchGuardKeyStore(settings, Paths.get(".", new String[0])).createClientTransportSSLEngine(null, -1).getEnabledProtocols();
            Assert.assertEquals((long)1L, (long)enabledProtocols.length);
            Assert.assertEquals((Object)"TLSv1.2", (Object)enabledProtocols[0]);
            Assert.assertEquals((long)1L, (long)enabledCiphers.length);
            Assert.assertEquals((Object)"TLS_RSA_WITH_AES_256_CBC_SHA256", (Object)enabledCiphers[0]);
        }
        catch (ElasticsearchSecurityException e) {
            Assert.assertTrue((String)("Check if error contains 'no valid cipher suites' -> " + e.toString()), (e.toString().contains("no valid cipher suites") || e.toString().contains("failed to set cipher suite") || e.toString().contains("Unable to configure permitted SSL ciphers") || e.toString().contains("OPENSSL_internal:NO_CIPHER_MATCH") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHttpsOptionalAuth() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains("\"searchguard\""));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsAndNodeSSL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test
    public void testHttpsAndNodeSSLPem() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsAndNodeSSLFailedCipher() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enabled_ciphers", "INVALID_CIPHER").build();
        try {
            this.setupSslOnlyMode(settings);
            Assert.fail();
        }
        catch (Exception e1) {
            Throwable e = ExceptionUtils.getRootCause((Throwable)e1);
            Assert.assertTrue((String)e.toString(), (boolean)e.toString().contains("no valid cipher"));
        }
    }

    @Test
    public void testHttpPlainFail() throws Exception {
        this.thrown.expect(NoHttpResponseException.class);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "OPTIONAL").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = false;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsNoEnforce() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "NONE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
    }

    @Test
    public void testHttpsEnforceFail() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        try {
            rh.executeSimpleRequest("");
            Assert.fail();
        }
        catch (SocketException | SSLException iOException) {
        }
        catch (Exception e) {
            Assert.fail((String)("Unexpected exception " + e.toString()));
        }
    }

    @Test
    public void testHttpsV3Fail() throws Exception {
        this.thrown.expect(SSLHandshakeException.class);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "NONE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = false;
        rh.enableHTTPClientSSLv3Only = true;
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
    }

    @Test
    public void testNodeClientSSL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enabled", false).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.nonSslRestHelper();
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", this.tmpHome()).put("node.name", "client_node_" + new Random().nextInt()).put("node.roles", "").put("discovery.initial_state_timeout", "8s").putList("cluster.initial_master_nodes", this.clusterInfo.tcpMasterPortsOnly).putList("discovery.seed_hosts", this.clusterInfo.tcpMasterPortsOnly).put(settings).build();
        try (Node node = new PluginAwareNode(false, tcSettings).start();){
            ClusterHealthResponse res = (ClusterHealthResponse)node.client().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForNodes("4").timeout(TimeValue.timeValueSeconds((long)15L))).actionGet();
            Assert.assertFalse((boolean)res.isTimedOut());
            Assert.assertEquals((long)4L, (long)res.getNumberOfNodes());
            Assert.assertEquals((long)4L, (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        }
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    private String tmpHome() {
        try {
            File tmp = Files.createTempDirectory("sslclientnode", new FileAttribute[0]).toFile();
            tmp.deleteOnExit();
            return tmp.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testAvailCiphers() throws Exception {
        SSLContext serverContext = SSLContext.getInstance("TLS");
        serverContext.init(null, null, null);
        SSLEngine engine = serverContext.createSSLEngine();
        ArrayList<String> jdkSupportedCiphers = new ArrayList<String>(Arrays.asList(engine.getSupportedCipherSuites()));
        jdkSupportedCiphers.retainAll(SSLConfigConstants.getSecureSSLCiphers((Settings)Settings.EMPTY, (boolean)false));
        engine.setEnabledCipherSuites(jdkSupportedCiphers.toArray(new String[0]));
        List<String> jdkEnabledCiphers = Arrays.asList(engine.getEnabledCipherSuites());
        Assert.assertTrue((jdkEnabledCiphers.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnmodifieableCipherProtocolConfig() throws Exception {
        SSLConfigConstants.getSecureSSLProtocols((Settings)Settings.EMPTY, (boolean)false)[0] = "bogus";
        Assert.assertEquals((Object)"TLSv1.3", (Object)SSLConfigConstants.getSecureSSLProtocols((Settings)Settings.EMPTY, (boolean)false)[0]);
        try {
            SSLConfigConstants.getSecureSSLCiphers((Settings)Settings.EMPTY, (boolean)false).set(0, "bogus");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testCRLPem() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0.key.pem")).put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/chain-ca.pem")).put("searchguard.ssl.http.crl.validate", true).put("searchguard.ssl.http.crl.validation_date", CertificateValidatorTest.CRL_DATE.getTime()).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
    }

    @Test
    public void testCRL() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", false).put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.crl.validate", true).put("searchguard.ssl.http.crl.file_path", FileHelper.getAbsoluteFilePathFromClassPath("ssl/crl/revoked.crl")).put("searchguard.ssl.http.crl.validation_date", CertificateValidatorTest.CRL_DATE.getTime()).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
    }

    @Test
    public void testNodeClientSSLwithJavaTLSv13() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 11 ? 1 : 0) != 0);
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.http.enabled", false).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).putList("searchguard.ssl.transport.enabled_protocols", new String[]{"TLSv1.3"}).putList("searchguard.ssl.transport.enabled_ciphers", new String[]{"TLS_AES_128_GCM_SHA256"}).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.nonSslRestHelper();
        Settings tcSettings = Settings.builder().put("cluster.name", this.clusterInfo.clustername).put("path.home", this.tmpHome()).put("node.name", "client_node_" + new Random().nextInt()).put("node.roles", "").put("discovery.initial_state_timeout", "18s").putList("cluster.initial_master_nodes", this.clusterInfo.tcpMasterPortsOnly).putList("discovery.seed_hosts", this.clusterInfo.tcpMasterPortsOnly).put(settings).build();
        try (Node node = new PluginAwareNode(false, tcSettings).start();){
            ClusterHealthResponse res = (ClusterHealthResponse)node.client().admin().cluster().health(new ClusterHealthRequest(MASTER_NODE_TIMEOUT).waitForNodes("4").timeout(TimeValue.timeValueSeconds((long)25L))).actionGet();
            Assert.assertFalse((boolean)res.isTimedOut());
            Assert.assertEquals((long)4L, (long)res.getNumberOfNodes());
            Assert.assertEquals((long)4L, (long)((NodesInfoResponse)node.client().admin().cluster().nodesInfo(new NodesInfoRequest(new String[0])).actionGet()).getNodes().size());
        }
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test
    public void testHttpsAndNodeSSLKeyPass() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.keystore_keypassword", "changeit").put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.keystore_keypassword", "changeit").build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
        Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("CN=node-0.example.com,OU=SSL,O=Test,L=Test,C=DE"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_count\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"rx_size_in_bytes\" : 0"));
        Assert.assertFalse((boolean)rh.executeSimpleRequest("_nodes/stats?pretty").contains("\"tx_count\" : 0"));
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testHttpsAndNodeSSLKeyPassFail() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.http.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.transport.keystore_keypassword", "wrongpass").put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.clientauth_mode", "REQUIRE").put("searchguard.ssl.http.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/node-0-keystore.jks")).put("searchguard.ssl.http.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/truststore.jks")).put("searchguard.ssl.http.keystore_keypassword", "wrongpass").build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        rh.enableHTTPClientSSL = true;
        rh.trustHTTPServerCertificate = true;
        rh.sendHTTPClientCertificate = true;
        Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
    }

    @Test
    public void testHttpsAndNodeSSLPCKS1() throws Exception {
        Settings settings = Settings.builder().put("searchguard.ssl.transport.enabled", true).put("searchguard.ssl.transport.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0.crt.pem")).put("searchguard.ssl.transport.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0-pkcs1.key.pem")).put("searchguard.ssl.transport.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).put("searchguard.ssl.transport.enforce_hostname_verification", false).put("searchguard.ssl.transport.resolve_hostname", false).put("searchguard.ssl.http.enabled", true).put("searchguard.ssl.http.pemcert_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0.crt.pem")).put("searchguard.ssl.http.pemkey_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/pkcs1/node-0-pkcs1.key.pem")).put("searchguard.ssl.http.pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath("ssl/root-ca.pem")).build();
        this.setupSslOnlyMode(settings);
        RestHelper rh = this.restHelper();
        try {
            rh.enableHTTPClientSSL = true;
            rh.setSslConfig(new GenericSSLConfig.Builder().trustAll(true).build());
            Assert.assertTrue((boolean)rh.executeSimpleRequest("_searchguard/sslinfo?pretty").contains("TLS"));
            Assert.assertTrue((rh.executeSimpleRequest("_searchguard/sslinfo?pretty").length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)rh.executeSimpleRequest("_nodes/settings?pretty").contains(this.clusterInfo.clustername));
        }
        finally {
            rh.setSslConfig(null);
        }
    }
}

