/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.test;

import com.floragunn.searchguard.ssl.test.NodeSettingsSupplier;
import com.floragunn.searchguard.ssl.test.helper.file.FileHelper;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.Plugin;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;

public abstract class AbstractSGUnitTest {
    protected static final AtomicLong num = new AtomicLong();
    protected final Logger log = LogManager.getLogger(this.getClass());
    @Rule
    public TestName name = new TestName();
    @Rule
    public final TemporaryFolder repositoryPath = new TemporaryFolder();

    public static Header encodeBasicHeader(String username, String password) {
        return new BasicHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + Objects.requireNonNull(password)).getBytes(StandardCharsets.UTF_8)));
    }

    @SafeVarargs
    protected static Collection<Class<? extends Plugin>> asCollection(Class<? extends Plugin> ... plugins) {
        return Arrays.asList(plugins);
    }

    protected Settings.Builder minimumSearchGuardSettingsBuilder(int node, boolean sslOnly, boolean hasCustomTransportSettings) {
        try {
            String prefix = this.getResourceFolder() == null ? "" : this.getResourceFolder() + "/";
            Settings.Builder builder = Settings.builder();
            if (!hasCustomTransportSettings) {
                builder.put("searchguard.ssl.transport.keystore_alias", "node-0").put("searchguard.ssl.transport.keystore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "node-0-keystore.jks")).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath(prefix + "truststore.jks")).put("searchguard.ssl.transport.enforce_hostname_verification", false);
            }
            return builder;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected NodeSettingsSupplier minimumSearchGuardSettings(final Settings other) {
        return new NodeSettingsSupplier(){

            @Override
            public Settings get(int i) {
                return AbstractSGUnitTest.this.minimumSearchGuardSettingsBuilder(i, false, AbstractSGUnitTest.this.hasCustomTransportSettings(other)).put(other).build();
            }
        };
    }

    protected boolean hasCustomTransportSettings(Settings customSettings) {
        return customSettings.get("searchguard.ssl.transport.pemcert_filepath") != null;
    }

    protected NodeSettingsSupplier minimumSearchGuardSettingsSslOnly(final Settings other) {
        return new NodeSettingsSupplier(){

            @Override
            public Settings get(int i) {
                return AbstractSGUnitTest.this.minimumSearchGuardSettingsBuilder(i, true, AbstractSGUnitTest.this.hasCustomTransportSettings(other)).put(other).build();
            }
        };
    }

    protected String getResourceFolder() {
        return null;
    }

    static {
        System.out.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        System.out.println("Java Version: " + System.getProperty("java.version") + " " + System.getProperty("java.vendor"));
        System.out.println("JVM Impl.: " + System.getProperty("java.vm.version") + " " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name"));
    }
}

