/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.util.config;

import com.floragunn.searchguard.ssl.util.config.GenericSSLConfigException;
import com.floragunn.searchguard.support.PemKeyReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCSException;

public class ClientAuthCredentials {
    private KeyStore keyStore;
    private char[] keyPassword;
    private String keyAlias;

    public static Builder from() {
        return new Builder();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public static class Builder {
        private X509Certificate[] authenticationCertificate;
        private PrivateKey authenticationKey;
        private KeyStore keyStore;
        private String keyAlias;
        private String keyPassword;

        public Builder certPem(File file) throws GenericSSLConfigException {
            Builder builder;
            FileInputStream in = new FileInputStream(file);
            try {
                builder = this.certPem(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new GenericSSLConfigException("Could not find certificate file " + String.valueOf(file), e);
                }
                catch (IOException | CertificateException e) {
                    throw new GenericSSLConfigException("Error while reading certificate file " + String.valueOf(file), e);
                }
            }
            in.close();
            return builder;
        }

        public Builder certPem(Path path) throws GenericSSLConfigException {
            return this.certPem(path.toFile());
        }

        public Builder certPem(InputStream inputStream) throws CertificateException {
            this.authenticationCertificate = PemKeyReader.loadCertificatesFromStream(inputStream);
            return this;
        }

        public Builder certKeyPem(File file, String password) throws GenericSSLConfigException {
            Builder builder;
            FileInputStream in = new FileInputStream(file);
            try {
                builder = this.certKeyPem(in, password);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new GenericSSLConfigException("Could not find certificate key file " + String.valueOf(file), e);
                }
                catch (IOException e) {
                    throw new GenericSSLConfigException("Error while reading certificate key file " + String.valueOf(file), e);
                }
            }
            in.close();
            return builder;
        }

        public Builder certKeyPem(Path path, String password) throws GenericSSLConfigException {
            return this.certKeyPem(path.toFile(), password);
        }

        public Builder certKeyPem(InputStream inputStream, String password) throws GenericSSLConfigException {
            try {
                this.authenticationKey = PemKeyReader.toPrivateKey(inputStream, password);
            }
            catch (IOException | OperatorCreationException | PKCSException e) {
                throw new GenericSSLConfigException("Could not load private key", e);
            }
            return this;
        }

        public Builder jks(File file, String alias, String password) throws GenericSSLConfigException {
            return this.keyStore(file, alias, password, "JKS");
        }

        public Builder pkcs12(File file, String alias, String password) throws GenericSSLConfigException {
            return this.keyStore(file, alias, password, "PKCS12");
        }

        public Builder keyStore(File file, String alias, String password) throws GenericSSLConfigException {
            return this.keyStore(file, alias, password, null);
        }

        public Builder keyStore(File file, String alias, String password, String type) throws GenericSSLConfigException {
            try {
                if (type == null) {
                    String fileName = file.getName();
                    if (fileName.endsWith(".jks")) {
                        type = "JKS";
                    } else if (fileName.endsWith(".pfx") || fileName.endsWith(".p12")) {
                        type = "PKCS12";
                    } else {
                        throw new IllegalArgumentException("Unknwon file type: " + fileName);
                    }
                }
                this.keyStore = KeyStore.getInstance(type.toUpperCase());
                this.keyStore.load(new FileInputStream(file), password == null ? null : password.toCharArray());
                this.keyAlias = alias;
                this.keyPassword = password;
                return this;
            }
            catch (Exception e) {
                throw new GenericSSLConfigException("Error loading client auth key store from " + String.valueOf(file), e);
            }
        }

        public ClientAuthCredentials build() throws GenericSSLConfigException {
            try {
                ClientAuthCredentials result = new ClientAuthCredentials();
                if (this.keyStore != null) {
                    result.keyStore = this.keyStore;
                    result.keyAlias = this.keyAlias;
                    result.keyPassword = this.keyPassword != null ? this.keyPassword.toCharArray() : null;
                } else if (this.authenticationCertificate != null && this.authenticationKey != null) {
                    result.keyPassword = PemKeyReader.randomChars(12);
                    result.keyAlias = "al";
                    result.keyStore = PemKeyReader.toKeystore(result.keyAlias, result.keyPassword, this.authenticationCertificate, this.authenticationKey);
                } else {
                    throw new IllegalStateException("Builder not completely initialized: " + String.valueOf(this));
                }
                return result;
            }
            catch (Exception e) {
                throw new GenericSSLConfigException("Error initializing client auth credentials", e);
            }
        }
    }
}

