/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import com.floragunn.searchguard.ssl.SearchGuardSSLPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.Build;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginsLoader;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.transport.netty4.Netty4Plugin;

public class SgAwarePluginsService
extends PluginsService {
    private final List<PluginsService.LoadedPlugin> loadedPlugins = new ArrayList<PluginsService.LoadedPlugin>();
    private static final List<Class<? extends Plugin>> STANDARD_PLUGINS = List.of(Netty4Plugin.class);

    public SgAwarePluginsService(Settings settings, List<Class<? extends Plugin>> additionalPlugins, PluginsLoader pluginsLoader) {
        super(settings, null, pluginsLoader);
        this.loadSearchGuardPlugin(settings);
        this.loadMainRestPlugin();
        this.loadPainlessPluginIfAvailable();
        for (Class plugin : Stream.concat(STANDARD_PLUGINS.stream(), additionalPlugins.stream()).toList()) {
            try {
                this.loadedPlugins.add(SgAwarePluginsService.createLoadedPlugin(plugin));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void loadSearchGuardPlugin(Settings settings) {
        this.loadedPlugins.add(SgAwarePluginsService.createLoadedPlugin((Plugin)new SearchGuardSSLPlugin(settings, null)));
    }

    private void loadMainRestPlugin() {
        try {
            Class<?> mainRestPlugin = Class.forName("org.elasticsearch.rest.root.MainRestPlugin");
            this.loadedPlugins.add(SgAwarePluginsService.createLoadedPlugin(mainRestPlugin));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadPainlessPluginIfAvailable() {
        try {
            Class<?> painlessPlugin = Class.forName("org.elasticsearch.painless.PainlessPlugin");
            Class<?> painlessExtensionClass = Class.forName("org.elasticsearch.painless.spi.PainlessExtension");
            PluginsService.LoadedPlugin loadedPainlessPlugin = SgAwarePluginsService.createLoadedPlugin(painlessPlugin);
            this.painlessWhitelistKludge(loadedPainlessPlugin.instance(), painlessExtensionClass);
            this.loadedPlugins.add(loadedPainlessPlugin);
        }
        catch (ClassNotFoundException painlessPlugin) {
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected List<PluginsService.LoadedPlugin> plugins() {
        return this.loadedPlugins;
    }

    private static PluginsService.LoadedPlugin createLoadedPlugin(Plugin plugin) {
        return new PluginsService.LoadedPlugin(SgAwarePluginsService.createPluginDescriptor(plugin.getClass()), plugin, SgAwarePluginsService.class.getClassLoader());
    }

    private static PluginsService.LoadedPlugin createLoadedPlugin(Class<? extends Plugin> pluginClass) throws Exception {
        return new PluginsService.LoadedPlugin(SgAwarePluginsService.createPluginDescriptor(pluginClass), pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), SgAwarePluginsService.class.getClassLoader());
    }

    private static PluginDescriptor createPluginDescriptor(Class<? extends Plugin> pluginClass) {
        return new PluginDescriptor(pluginClass.getSimpleName(), pluginClass.getSimpleName(), "0.0.0", Build.current().version(), "17", pluginClass.getSimpleName(), "", Collections.emptyList(), false, false, true, false);
    }

    private void painlessWhitelistKludge(Plugin plugin, final Class<?> painlessExtensionClass) {
        ExtensiblePlugin painlessPlugin = (ExtensiblePlugin)plugin;
        painlessPlugin.loadExtensions(new ExtensiblePlugin.ExtensionLoader(){

            public <T> List<T> loadExtensions(Class<T> extensionPointType) {
                if (extensionPointType.equals(painlessExtensionClass)) {
                    List result = StreamSupport.stream(ServiceLoader.load(painlessExtensionClass, this.getClass().getClassLoader()).spliterator(), false).collect(Collectors.toList());
                    return result;
                }
                return Collections.emptyList();
            }
        });
    }
}

