/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.action;

import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardResponse;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class Responses {
    private static final Logger log = LogManager.getLogger(Responses.class);

    public static void sendError(RestChannel channel, RestStatus status, String error) {
        Responses.sendError(channel, status, error, (String)null);
    }

    public static void sendError(RestChannel channel, RestStatus status, String error, String detailJsonDocument) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.prettyPrint();
            builder.humanReadable(true);
            builder.startObject();
            builder.field("status", status.getStatus());
            if (error != null) {
                builder.field("error", error);
            }
            if (detailJsonDocument != null) {
                builder.rawField("detail", (InputStream)new ByteArrayInputStream(detailJsonDocument.getBytes(Charsets.UTF_8)), XContentType.JSON);
            }
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public static void sendError(RestChannel channel, RestStatus status, String error, ToXContent detailDocument) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.prettyPrint();
            builder.humanReadable(true);
            builder.startObject();
            builder.field("status", status.getStatus());
            if (error != null) {
                builder.field("error", error);
            }
            if (detailDocument != null) {
                builder.field("detail", detailDocument);
            }
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public static void sendError(RestChannel channel, Exception e) {
        if (e instanceof ConfigValidationException) {
            channel.sendResponse(RestApi.toRestResponse(new StandardResponse(400, new StandardResponse.Error(e.getMessage()).details(((ConfigValidationException)((Object)e)).getValidationErrors()))));
        } else {
            Responses.sendError(channel, ExceptionsHelper.status((Throwable)e), e.getMessage());
        }
    }

    public static void send(RestChannel channel, RestStatus status) {
        try {
            XContentBuilder builder = channel.newBuilder();
            builder.prettyPrint();
            builder.humanReadable(true);
            builder.startObject();
            builder.field("status", status.getStatus());
            builder.endObject();
            channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public static void send(RestChannel channel, RestStatus status, Object json) {
        try {
            if (json instanceof ToXContent) {
                ToXContent toxContent = (ToXContent)json;
                XContentBuilder builder = channel.newBuilder();
                if (toxContent.isFragment()) {
                    builder.startObject();
                }
                toxContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
                if (toxContent.isFragment()) {
                    builder.endObject();
                }
                channel.sendResponse((RestResponse)new BytesRestResponse(status, builder));
            } else {
                channel.sendResponse((RestResponse)new BytesRestResponse(status, "application/json", DocWriter.json().writeAsString(json)));
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }
}

