/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.client;

import com.floragunn.searchsupport.client.Actions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHit;

public class SearchScroller {
    private static final Logger log = LogManager.getLogger(SearchScroller.class);
    private final Client client;

    public SearchScroller(Client client) {
        this.client = Objects.requireNonNull(client, "Client is required");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> scroll(SearchRequest request, TimeValue scrollTimeout, Function<SearchHit, T> resultMapper) {
        ArrayList<T> arrayList;
        Objects.requireNonNull(request, "Search request is required to scroll");
        Objects.requireNonNull(resultMapper, "Scroll result mapper is required");
        Objects.requireNonNull(scrollTimeout, "Scroll timeout is required");
        request.scroll(scrollTimeout);
        SearchResponse searchResponse = (SearchResponse)this.client.search(request).actionGet();
        try {
            ArrayList<T> results = new ArrayList<T>();
            do {
                SearchHit[] hits = searchResponse.getHits().getHits();
                String scrollId = searchResponse.getScrollId();
                if (searchResponse.getFailedShards() > 0) {
                    throw new IllegalStateException("Unexpected error during scrolling via search results.");
                }
                log.debug("'{}' elements were gained due to scrolling with id '{}'.", (Object)hits.length, (Object)scrollId);
                for (SearchHit searchHit : hits) {
                    results.add(resultMapper.apply(searchHit));
                }
            } while ((searchResponse = (SearchResponse)this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(scrollTimeout).execute().actionGet()).getHits().getHits().length != 0);
            arrayList = results;
        }
        catch (Throwable throwable) {
            try {
                log.debug("Async clear scroll '{}'.", (Object)searchResponse.getScrollId());
                Actions.clearScrollAsync(this.client, searchResponse);
                throw throwable;
            }
            catch (ElasticsearchException e) {
                log.error("Error during scrolling to load all search results", (Throwable)e);
                throw e;
            }
        }
        log.debug("Async clear scroll '{}'.", (Object)searchResponse.getScrollId());
        Actions.clearScrollAsync(this.client, searchResponse);
        return arrayList;
    }
}

