/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.xcontent;

import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentGenerator;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.filtering.FilterPath;

public class ObjectTreeXContent
implements XContent {
    private static final Logger log = LogManager.getLogger(ObjectTreeXContent.class);
    private final Supplier<Map<?, ?>> mapFactory;

    public static Object toObjectTree(ToXContent toXContent) {
        return ObjectTreeXContent.toObjectTree(toXContent, (ToXContent.Params)new ToXContent.MapParams(Collections.emptyMap()));
    }

    public static Object toObjectTree(ToXContent toXContent, ToXContent.Params params) {
        return ObjectTreeXContent.toObjectTree(toXContent, params, () -> new HashMap());
    }

    public static Object toObjectTree(ToXContent toXContent, ToXContent.Params params, Supplier<Map<?, ?>> mapFactory) {
        Object object;
        block10: {
            XContentBuilder builder = XContentBuilder.builder((XContent)new ObjectTreeXContent(mapFactory));
            try {
                if (toXContent.isFragment()) {
                    builder.startObject();
                }
                toXContent.toXContent(builder, params);
                if (toXContent.isFragment()) {
                    builder.endObject();
                }
                Generator generator = (Generator)builder.generator();
                object = generator.getTopLevelObject();
                if (builder == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.close();
        }
        return object;
    }

    public static Map<String, Object> toMap(ToXContent toXContent) {
        Object object = ObjectTreeXContent.toObjectTree(toXContent);
        if (object instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.put(String.valueOf(entry.getKey()), entry.getValue());
            }
            return result;
        }
        return Collections.singletonMap("_value", object);
    }

    public ObjectTreeXContent(Supplier<Map<?, ?>> mapFactory) {
        this.mapFactory = mapFactory;
    }

    public XContentType type() {
        return null;
    }

    public byte streamSeparator() {
        return 0;
    }

    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new Generator(includes, excludes, this.mapFactory);
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        throw new UnsupportedOperationException();
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        throw new UnsupportedOperationException();
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        throw new UnsupportedOperationException();
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is, FilterPath[] includes, FilterPath[] excludes) throws IOException {
        throw new UnsupportedOperationException();
    }

    static class Generator
    implements XContentGenerator {
        private List<Object> objectStack = new ArrayList<Object>();
        private List<Object> topLevelObjects = new ArrayList<Object>();
        private String currentKey = null;
        private final Supplier<Map<?, ?>> mapFactory;

        Generator(Set<String> includes, Set<String> excludes, Supplier<Map<?, ?>> mapFactory) {
            this.mapFactory = mapFactory;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public XContentType contentType() {
            return null;
        }

        public void usePrettyPrint() {
        }

        public boolean isPrettyPrint() {
            return false;
        }

        public void usePrintLineFeedAtEnd() {
        }

        public void writeStartObject() throws IOException {
            Map<?, ?> map = this.mapFactory.get();
            this.objectStack.add(this.addObject(map));
        }

        public void writeEndObject() throws IOException {
            this.pop();
        }

        public void writeStartArray() throws IOException {
            ArrayList list = new ArrayList();
            this.objectStack.add(this.addObject(list));
        }

        public void writeEndArray() throws IOException {
            this.pop();
        }

        public void writeFieldName(String name) throws IOException {
            this.currentKey = name;
        }

        public void writeNull() throws IOException {
            this.addObject(null);
        }

        public void writeNullField(String name) throws IOException {
            this.addObject(name, null);
        }

        public void writeBooleanField(String name, boolean value) throws IOException {
            this.addObject(name, value);
        }

        public void writeBoolean(boolean value) throws IOException {
            this.addObject(value);
        }

        public void writeNumberField(String name, double value) throws IOException {
            this.addObject(name, value);
        }

        public void writeNumber(double value) throws IOException {
            this.addObject(value);
        }

        public void writeNumberField(String name, float value) throws IOException {
            this.addObject(name, Float.valueOf(value));
        }

        public void writeNumber(float value) throws IOException {
            this.addObject(Float.valueOf(value));
        }

        public void writeNumberField(String name, int value) throws IOException {
            this.addObject(name, value);
        }

        public void writeNumber(int value) throws IOException {
            this.addObject(value);
        }

        public void writeNumberField(String name, long value) throws IOException {
            this.addObject(name, value);
        }

        public void writeNumber(long value) throws IOException {
            this.addObject(value);
        }

        public void writeNumber(short value) throws IOException {
            this.addObject(value);
        }

        public void writeNumber(BigInteger value) throws IOException {
            this.addObject(value);
        }

        public void writeNumberField(String name, BigInteger value) throws IOException {
            this.addObject(name, value);
        }

        public void writeNumber(BigDecimal value) throws IOException {
            this.addObject(value);
        }

        public void writeNumberField(String name, BigDecimal value) throws IOException {
            this.addObject(name, value);
        }

        public void writeStringField(String name, String value) throws IOException {
            this.addObject(name, value);
        }

        public void writeString(String value) throws IOException {
            this.addObject(value);
        }

        public void writeString(char[] text, int offset, int len) throws IOException {
            this.addObject(new String(text, offset, len));
        }

        public void writeUTF8String(byte[] value, int offset, int length) throws IOException {
            this.addObject(new String(value, offset, length, "UTF-8"));
        }

        public void writeBinaryField(String name, byte[] value) throws IOException {
            this.addObject(name, value);
        }

        public void writeBinary(byte[] value) throws IOException {
            this.addObject(value);
        }

        public void writeBinary(byte[] value, int offset, int length) throws IOException {
            byte[] valueSection = new byte[length];
            System.arraycopy(value, offset, valueSection, 0, length);
            this.addObject(value);
        }

        public void writeRawField(String name, InputStream value) throws IOException {
            if (!value.markSupported()) {
                value = new BufferedInputStream(value);
            }
            XContentType xContentType = XContentFactory.xContentType((InputStream)value);
            this.writeRawField(name, value, xContentType);
        }

        public void writeRawField(String name, InputStream value, XContentType xContentType) throws IOException {
            this.writeFieldName(name);
            this.writeRawValue(value, xContentType);
        }

        public void writeRawValue(InputStream value, XContentType xContentType) throws IOException {
            try (XContentParser parser = XContentFactory.xContent((XContentType)xContentType).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, value);){
                parser.nextToken();
                this.copyCurrentStructure(parser);
            }
        }

        public void copyCurrentStructure(XContentParser parser) throws IOException {
            int nestingDepth = 0;
            XContentParser.Token token = parser.currentToken();
            while (token != null) {
                switch (token) {
                    case FIELD_NAME: {
                        this.writeFieldName(parser.currentName());
                        break;
                    }
                    case START_ARRAY: {
                        this.writeStartArray();
                        ++nestingDepth;
                        break;
                    }
                    case START_OBJECT: {
                        this.writeStartObject();
                        ++nestingDepth;
                        break;
                    }
                    case END_ARRAY: {
                        this.writeEndArray();
                        --nestingDepth;
                        break;
                    }
                    case END_OBJECT: {
                        this.writeEndObject();
                        --nestingDepth;
                        break;
                    }
                    default: {
                        this.copyCurrentEvent(parser);
                    }
                }
                if (nestingDepth == 0 && token != XContentParser.Token.FIELD_NAME) {
                    return;
                }
                token = parser.nextToken();
            }
        }

        public void writeDirectField(String name, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            writer.accept((Object)outputStream);
            try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, new String(outputStream.toByteArray(), Charsets.UTF_8));){
                parser.nextToken();
                this.copyCurrentStructure(parser);
            }
        }

        public boolean isClosed() {
            return false;
        }

        Object getTopLevelObject() {
            if (this.topLevelObjects.size() == 0) {
                return null;
            }
            if (this.topLevelObjects.size() > 1) {
                log.warn("More than one top level object was produced. Using first one: " + this.topLevelObjects);
            }
            return this.topLevelObjects.get(0);
        }

        private Object addObject(Object key, Object object) throws IOException {
            Object top = this.top();
            if (top == null) {
                this.topLevelObjects.add(object);
            } else if (top instanceof Collection) {
                ((Collection)top).add(object);
            } else if (top instanceof Map) {
                String keyString = String.valueOf(key);
                ((Map)top).put(keyString, object);
                object = ((Map)top).get(keyString);
            } else {
                throw new IOException("Invalid object structure: " + top + " is not a container.");
            }
            return object;
        }

        private Object addObject(Object object) throws IOException {
            object = this.addObject(this.currentKey, object);
            this.currentKey = null;
            return object;
        }

        private Object top() {
            if (this.objectStack.size() == 0) {
                return null;
            }
            return this.objectStack.get(this.objectStack.size() - 1);
        }

        private Object pop() {
            if (this.objectStack.size() == 0) {
                return null;
            }
            return this.objectStack.remove(this.objectStack.size() - 1);
        }
    }
}

