/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.meta;

import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableCollection;
import com.floragunn.searchsupport.meta.MetaImpl;
import java.util.Collection;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.internal.LoggerFactoryImpl;
import org.elasticsearch.logging.internal.spi.LoggerFactory;

public interface Meta
extends Document<Meta> {
    public ImmutableMap<String, IndexLikeObject> indexLikeObjects();

    public ImmutableSet<Index> indices();

    public ImmutableSet<Alias> aliases();

    public ImmutableSet<DataStream> dataStreams();

    public ImmutableSet<IndexCollection> indexCollections();

    public ImmutableSet<Index> indicesWithoutParents();

    public ImmutableSet<Index> nonHiddenIndices();

    public ImmutableSet<Index> nonHiddenIndicesWithoutParents();

    public ImmutableSet<Alias> nonHiddenAliases();

    public ImmutableSet<DataStream> nonHiddenDataStreams();

    public ImmutableSet<Index> nonSystemIndices();

    public ImmutableSet<Index> nonSystemIndicesWithoutParents();

    public Iterable<String> namesOfIndices();

    public Iterable<String> namesOfIndexCollections();

    public IndexLikeObject getIndexOrLike(String var1);

    public boolean equals(Object var1);

    public int hashCode();

    public Mock.AliasBuilder alias(String var1);

    public Mock.DataStreamBuilder dataStream(String var1);

    public Metadata esMetadata();

    public long version();

    public static Meta from(Metadata esMetadata) {
        return new MetaImpl.DefaultMetaImpl(esMetadata);
    }

    public static Meta from(ClusterService clusterService) {
        return MetaImpl.DefaultMetaImpl.from(clusterService);
    }

    public static interface Mock {
        public static Meta indices(String ... indexNames) {
            Mock.initLogging();
            return MetaImpl.DefaultMetaImpl.indices(indexNames);
        }

        public static AliasBuilder alias(String aliasName) {
            Mock.initLogging();
            return new MetaImpl.AliasBuilderImpl(aliasName);
        }

        public static DataStreamBuilder dataStream(String dataStreamName) {
            Mock.initLogging();
            return new MetaImpl.DataStreamBuilderImpl(dataStreamName);
        }

        private static void initLogging() {
            LoggerFactoryImpl factory = new LoggerFactoryImpl();
            LoggerFactory.setInstance((LoggerFactory)factory);
        }

        public static interface DataStreamBuilder {
            public Meta of(String ... var1);
        }

        public static interface AliasBuilder {
            public Meta of(String ... var1);
        }
    }

    public static interface IndexOrNonExistent
    extends IndexLikeObject {
    }

    public static interface NonExistent
    extends IndexOrNonExistent {
        public static final NonExistent BLANK = NonExistent.of("_");
        public static final NonExistent STAR = NonExistent.of("*");

        public static NonExistent of(String name) {
            return new MetaImpl.NonExistentImpl(name);
        }
    }

    public static interface DataStream
    extends IndexCollection {
        public static DataStream nonExistent(String name) {
            return new MetaImpl.NonExistentDataStreamImpl(name);
        }
    }

    public static interface Alias
    extends IndexCollection {
        public IndexLikeObject writeTarget();

        public UnmodifiableCollection<IndexLikeObject> resolve(ResolutionMode var1);

        public static Alias nonExistent(String name) {
            return new MetaImpl.NonExistentAliasImpl(name);
        }

        public static enum ResolutionMode {
            NORMAL,
            TO_WRITE_TARGET;

        }
    }

    public static interface IndexCollection
    extends IndexLikeObject {
        public UnmodifiableCollection<IndexLikeObject> members();

        public ImmutableSet<Index> resolveDeepAsIndex(Alias.ResolutionMode var1);

        public static ImmutableSet<Index> resolveDeep(ImmutableSet<? extends IndexCollection> aliasesAndDataStreams, Alias.ResolutionMode resolutionMode) {
            if (aliasesAndDataStreams.size() == 0) {
                return ImmutableSet.empty();
            }
            if (aliasesAndDataStreams.size() == 1) {
                return ((IndexCollection)aliasesAndDataStreams.only()).resolveDeepAsIndex(resolutionMode);
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder(aliasesAndDataStreams.size() * 20);
            for (IndexCollection object : aliasesAndDataStreams) {
                result.addAll(object.resolveDeepAsIndex(resolutionMode));
            }
            return result.build();
        }
    }

    public static interface Index
    extends IndexOrNonExistent {
        public boolean isOpen();

        public boolean isSystem();

        public boolean isDataStreamBackingIndex();

        public static Index nonExistent(String name) {
            return new MetaImpl.NonExistentIndexImpl(name);
        }
    }

    public static interface IndexLikeObject
    extends Document<IndexLikeObject> {
        public String name();

        public ImmutableSet<IndexOrNonExistent> resolveDeep(Alias.ResolutionMode var1);

        public ImmutableSet<String> resolveDeepToNames(Alias.ResolutionMode var1);

        public ImmutableSet<Alias> parentAliases();

        public DataStream parentDataStream();

        public String parentDataStreamName();

        public Collection<String> parentAliasNames();

        public Collection<String> ancestorAliasNames();

        public boolean equals(Object var1);

        public int hashCode();

        public boolean isHidden();

        public boolean exists();

        public static ImmutableSet<Index> resolveDeep(ImmutableSet<? extends IndexLikeObject> objects) {
            return IndexLikeObject.resolveDeep(objects, Alias.ResolutionMode.NORMAL);
        }

        public static ImmutableSet<Index> resolveDeep(ImmutableSet<? extends IndexLikeObject> objects, Alias.ResolutionMode resolutionMode) {
            if (objects.size() == 0) {
                return ImmutableSet.empty();
            }
            if (objects.size() == 1) {
                IndexLikeObject object = (IndexLikeObject)objects.only();
                if (object instanceof Index) {
                    return ImmutableSet.of((Object)((Index)object));
                }
                if (object instanceof IndexCollection) {
                    return ((IndexCollection)object).resolveDeepAsIndex(resolutionMode);
                }
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder(objects.size() * 20);
            for (IndexLikeObject object : objects) {
                if (object instanceof Index) {
                    result.add((Object)((Index)object));
                    continue;
                }
                if (!(object instanceof IndexCollection)) continue;
                result.addAll(((IndexCollection)object).resolveDeepAsIndex(resolutionMode));
            }
            return result.build();
        }

        public static ImmutableSet<String> resolveDeepToNames(ImmutableSet<? extends IndexLikeObject> objects, Alias.ResolutionMode resolutionMode) {
            if (objects.size() == 0) {
                return ImmutableSet.empty();
            }
            if (objects.size() == 1) {
                IndexLikeObject object = (IndexLikeObject)objects.only();
                if (object instanceof Index) {
                    return ImmutableSet.of((Object)object.name());
                }
                if (object instanceof IndexCollection) {
                    return ((IndexCollection)object).resolveDeepToNames(resolutionMode);
                }
            }
            ImmutableSet.Builder result = new ImmutableSet.Builder(objects.size() * 20);
            for (IndexLikeObject object : objects) {
                if (object instanceof Index) {
                    result.add((Object)object.name());
                    continue;
                }
                if (!(object instanceof IndexCollection)) continue;
                result.addAll(((IndexCollection)object).resolveDeepToNames(resolutionMode));
            }
            return result.build();
        }
    }
}

