/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit;

import java.time.Duration;
import org.junit.Assert;

public class AsyncAssert {
    public static void awaitAssert(String message, AssertSupplier condition, Duration maxWaitingTime) throws Exception {
        Exception lastException;
        long timeout = System.currentTimeMillis() + maxWaitingTime.toMillis();
        do {
            try {
                if (condition.get()) {
                    return;
                }
                lastException = null;
            }
            catch (Exception e) {
                lastException = e;
            }
            AsyncAssert.sleep(50L);
        } while (timeout >= System.currentTimeMillis());
        if (lastException != null) {
            throw lastException;
        }
        Assert.fail((String)message);
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface AssertSupplier {
        public boolean get() throws Exception;
    }
}

