/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class FieldIsNullMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private static final Logger log = LogManager.getLogger(FieldIsNullMatcher.class);
    private final String jsonPath;

    public FieldIsNullMatcher(String jsonPath) {
        this.jsonPath = Objects.requireNonNull(jsonPath, "Json path is required.");
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        try {
            Object fieldValue = docNode.findSingleValueByJsonPath(this.jsonPath, Object.class);
            if (fieldValue != null) {
                mismatchDescription.appendText(" field is not null and has assigned value ").appendValue(fieldValue);
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            log.debug("Patch {} not found in DocNode {}.", (Object)this.jsonPath, (Object)docNode, (Object)e);
            mismatchDescription.appendText(" path ").appendValue((Object)this.jsonPath).appendText(" does not exists in doc node ").appendValue((Object)docNode.toJsonString());
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("Field pointed by json path ").appendValue((Object)this.jsonPath).appendText(" is null");
    }
}

