/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class Count
extends Measurement<Count> {
    static final String TYPE = "count";
    private final AtomicLong count = new AtomicLong();

    public Count() {
    }

    public Count(long count) {
        this.count.set(count);
    }

    Count(DocNode docNode) {
        if (docNode.toBasicObject() instanceof Number) {
            this.count.set(((Number)docNode.toBasicObject()).longValue());
        }
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public Object toBasicObject() {
        return this.count.get();
    }

    @Override
    public Measurement<Count> clone() {
        return new Count(this.count.get());
    }

    @Override
    public void addToThis(Count other) {
        this.count.addAndGet(other.count.get());
    }

    @Override
    public void addToThis(Measurement<?> other) {
        if (other instanceof Count) {
            this.addToThis((Count)other);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void reset() {
        this.count.set(0L);
    }

    public void set(long count) {
        this.count.set(count);
    }

    public static class Live
    extends Measurement<Count> {
        private final Supplier<Long> countSupplier;

        public Live(Supplier<Long> countSupplier) {
            this.countSupplier = countSupplier;
        }

        public Object toBasicObject() {
            return this.countSupplier.get();
        }

        @Override
        public Measurement<Count> clone() {
            return new Count(this.countSupplier.get());
        }

        @Override
        public void addToThis(Count other) {
        }

        @Override
        public void addToThis(Measurement<?> other) {
        }

        @Override
        public String getType() {
            return Count.TYPE;
        }

        @Override
        public void reset() {
        }
    }
}

