/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.HashSet;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ContainsOnlyFieldsMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private static final Logger log = LogManager.getLogger(ContainsOnlyFieldsMatcher.class);
    private final String jsonPath;
    private final String[] fieldNames;

    public ContainsOnlyFieldsMatcher(String jsonPath, String ... expectedFieldsNames) {
        this.jsonPath = Objects.requireNonNull(jsonPath);
        this.fieldNames = Objects.requireNonNull(expectedFieldsNames);
    }

    public void describeTo(Description description) {
        description.appendText("DocNode ").appendValue((Object)this.jsonPath).appendText(" should contain only the following fields ").appendValue((Object)String.join((CharSequence)", ", this.fieldNames));
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        if (log.isDebugEnabled()) {
            log.debug("Checking id DocNode {} contain fields {} at path {}", (Object)docNode.toPrettyJsonString(), (Object)this.fieldNames, (Object)this.jsonPath);
        }
        try {
            ImmutableList nodes = docNode.findNodesByJsonPath(this.jsonPath);
            int numberOfNodes = nodes.size();
            if (numberOfNodes != 1) {
                mismatchDescription.appendText("Found ").appendValue((Object)numberOfNodes).appendText(" nodes pointed by json path ").appendValue((Object)this.jsonPath).appendText(" whereas expected number of nodes is 1.");
                return false;
            }
            DocNode selectedDocNode = (DocNode)nodes.get(0);
            HashSet allNodeKeys = new HashSet(selectedDocNode.keySet());
            for (String currentFieldName : this.fieldNames) {
                if (!selectedDocNode.containsKey((Object)currentFieldName)) {
                    mismatchDescription.appendText("Node pointed by json path ").appendValue((Object)this.jsonPath).appendText(" does not contain field ").appendValue((Object)currentFieldName);
                    return false;
                }
                allNodeKeys.remove(currentFieldName);
            }
            if (!allNodeKeys.isEmpty()) {
                mismatchDescription.appendText("The DocNode ").appendValue((Object)this.jsonPath).appendText(" contains undesired fields ").appendValue((Object)String.join((CharSequence)", ", allNodeKeys));
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            log.debug("Patch {} not found in DocNode {}.", (Object)this.jsonPath, (Object)docNode, (Object)e);
            mismatchDescription.appendText("path ").appendValue((Object)this.jsonPath).appendText(" does not exists in doc node ").appendValue((Object)docNode.toJsonString());
            return false;
        }
    }
}

