/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;

public class StaticSettings {
    public static final StaticSettings EMPTY = new StaticSettings(Settings.EMPTY, null);
    private static final Logger log = LogManager.getLogger(StaticSettings.class);
    private final Settings settings;
    private final Environment environment;
    private final Path configPath;

    public StaticSettings(Settings settings, Path configPath) {
        this.settings = settings;
        this.environment = configPath != null ? new Environment(settings, configPath) : null;
        this.configPath = configPath;
    }

    public Path getPlatformPluginsDirectory() {
        return this.environment.pluginsDir();
    }

    public Path getPatformConfigDirectory() {
        return this.environment.configDir();
    }

    public <V> V get(Attribute<V> option) {
        return option.getFrom(this.settings);
    }

    public Settings getPlatformSettings() {
        return this.settings;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public static StaticSettings ofBoolean(Attribute<Boolean> attribute, boolean value) {
        Settings.Builder platformSettings = Settings.builder();
        platformSettings.put(attribute.toPlatformInstance().getKey(), value);
        return new StaticSettings(platformSettings.build(), null);
    }

    public static abstract class Attribute<V> {
        protected final String name;
        protected final V defaultValue;
        protected final boolean filtered;
        protected final Setting<?> platformInstance;

        public static Builder<Object> define(String name) {
            return new Builder<Object>(name);
        }

        Attribute(String name, V defaultValue, boolean filtered) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.filtered = filtered;
            this.platformInstance = this.toPlatformInstance();
        }

        V getFrom(Settings settings) {
            return (V)this.platformInstance.get(settings);
        }

        public String name() {
            return this.name;
        }

        protected abstract Setting<?> toPlatformInstance();

        protected Setting.Property[] toPlatformProperties() {
            ArrayList<Setting.Property> result = new ArrayList<Setting.Property>(3);
            result.add(Setting.Property.NodeScope);
            if (this.filtered) {
                result.add(Setting.Property.Filtered);
            }
            return result.toArray(new Setting.Property[result.size()]);
        }

        public static class Builder<V> {
            private final String name;
            private V defaultValue = null;
            private boolean filtered = false;

            Builder(String name) {
                this.name = name;
            }

            public Builder<V> filterValueFromUI() {
                this.filtered = true;
                return this;
            }

            public StringBuilder withDefault(String defaultValue) {
                Builder castedBuilder = this;
                castedBuilder.defaultValue = defaultValue;
                return new StringBuilder(castedBuilder);
            }

            public IntegerBuilder withDefault(int defaultValue) {
                Builder castedBuilder = this;
                castedBuilder.defaultValue = defaultValue;
                return new IntegerBuilder(castedBuilder);
            }

            public BooleanBuilder withDefault(boolean defaultValue) {
                Builder castedBuilder = this;
                castedBuilder.defaultValue = defaultValue;
                return new BooleanBuilder(castedBuilder);
            }

            public TimeValueBuilder withDefault(TimeValue defaultValue) {
                Builder castedBuilder = this;
                castedBuilder.defaultValue = defaultValue;
                return new TimeValueBuilder(castedBuilder);
            }

            public PatternBuilder withDefault(Pattern defaultValue) {
                Builder castedBuilder = this;
                castedBuilder.defaultValue = defaultValue;
                return new PatternBuilder(castedBuilder);
            }

            public ByteSizeValueBuilder withDefault(ByteSizeValue defaultValue) {
                Builder castedBuilder = this;
                castedBuilder.defaultValue = defaultValue;
                return new ByteSizeValueBuilder(castedBuilder);
            }

            public StringListAttribute asListOfStrings() {
                return new StringListAttribute(this.name, (List<String>)ImmutableList.empty(), this.filtered);
            }
        }

        public static class ByteSizeValueBuilder {
            private final Builder<ByteSizeValue> parent;

            ByteSizeValueBuilder(Builder<ByteSizeValue> parent) {
                this.parent = parent;
            }

            public Attribute<ByteSizeValue> asByteSizeValue() {
                return new ByteSizeValueAttribute(this.parent.name, (ByteSizeValue)this.parent.defaultValue, this.parent.filtered);
            }
        }

        public static class PatternBuilder {
            private final Builder<Pattern> parent;

            PatternBuilder(Builder<Pattern> parent) {
                this.parent = parent;
            }

            public Attribute<Pattern> asPattern() {
                return new PatternAttribute(this.parent.name, (Pattern)this.parent.defaultValue, this.parent.filtered);
            }
        }

        public static class TimeValueBuilder {
            private final Builder<TimeValue> parent;

            TimeValueBuilder(Builder<TimeValue> parent) {
                this.parent = parent;
            }

            public Attribute<TimeValue> asTimeValue() {
                return new TimeValueAttribute(this.parent.name, (TimeValue)this.parent.defaultValue, this.parent.filtered);
            }
        }

        public static class IntegerBuilder {
            private final Builder<Integer> parent;

            IntegerBuilder(Builder<Integer> parent) {
                this.parent = parent;
            }

            public Attribute<Integer> asInteger() {
                return new IntegerAttribute(this.parent.name, (Integer)this.parent.defaultValue, this.parent.filtered);
            }
        }

        public static class BooleanBuilder {
            private final Builder<Boolean> parent;

            BooleanBuilder(Builder<Boolean> parent) {
                this.parent = parent;
            }

            public Attribute<Boolean> asBoolean() {
                return new BooleanAttribute(this.parent.name, (Boolean)this.parent.defaultValue, this.parent.filtered);
            }
        }

        public static class StringBuilder {
            private final Builder<String> parent;

            StringBuilder(Builder<String> parent) {
                this.parent = parent;
            }

            public Attribute<String> asString() {
                return new StringAttribute(this.parent.name, (String)this.parent.defaultValue, this.parent.filtered);
            }
        }
    }

    public static class AttributeSet {
        private static final AttributeSet EMPTY = new AttributeSet(ImmutableList.empty());
        private final ImmutableList<Attribute<?>> options;

        public static AttributeSet of(Attribute<?> ... options) {
            return new AttributeSet(ImmutableList.ofArray((Object[])options));
        }

        public static AttributeSet empty() {
            return EMPTY;
        }

        AttributeSet(ImmutableList<Attribute<?>> options) {
            this.options = options;
        }

        public ImmutableList<Setting<?>> toPlatform() {
            return this.options.map(Attribute::toPlatformInstance);
        }
    }

    static class ByteSizeValueAttribute
    extends Attribute<ByteSizeValue> {
        ByteSizeValueAttribute(String name, ByteSizeValue defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<ByteSizeValue> toPlatformInstance() {
            return Setting.memorySizeSetting((String)this.name, (ByteSizeValue)((ByteSizeValue)this.defaultValue), (Setting.Property[])this.toPlatformProperties());
        }
    }

    static class StringListAttribute
    extends Attribute<List<String>> {
        StringListAttribute(String name, List<String> defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<?> toPlatformInstance() {
            return Setting.listSetting((String)this.name, (List)((List)this.defaultValue), Function.identity(), (Setting.Property[])this.toPlatformProperties());
        }
    }

    static class PatternAttribute
    extends Attribute<Pattern> {
        private static final List<String> EMPTY_DEFAULT = ImmutableList.of((Object)"___empty");

        PatternAttribute(String name, Pattern defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<?> toPlatformInstance() {
            return Setting.listSetting((String)this.name, EMPTY_DEFAULT, Function.identity(), (Setting.Property[])this.toPlatformProperties());
        }

        @Override
        Pattern getFrom(Settings settings) {
            List value = (List)this.platformInstance.get(settings);
            if (value.equals(EMPTY_DEFAULT)) {
                return (Pattern)this.defaultValue;
            }
            try {
                return Pattern.create((List)value);
            }
            catch (ConfigValidationException e) {
                log.error("Invalid pattern value for setting " + this.name(), (Throwable)e);
                return (Pattern)this.defaultValue;
            }
        }
    }

    static class TimeValueAttribute
    extends Attribute<TimeValue> {
        TimeValueAttribute(String name, TimeValue defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<TimeValue> toPlatformInstance() {
            return Setting.timeSetting((String)this.name, (TimeValue)((TimeValue)this.defaultValue), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])this.toPlatformProperties());
        }
    }

    static class BooleanAttribute
    extends Attribute<Boolean> {
        BooleanAttribute(String name, Boolean defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<Boolean> toPlatformInstance() {
            return Setting.boolSetting((String)this.name, (boolean)(this.defaultValue != null ? (Boolean)this.defaultValue : false), (Setting.Property[])this.toPlatformProperties());
        }
    }

    static class IntegerAttribute
    extends Attribute<Integer> {
        IntegerAttribute(String name, Integer defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<Integer> toPlatformInstance() {
            return Setting.intSetting((String)this.name, (int)(this.defaultValue != null ? (Integer)this.defaultValue : 0), (Setting.Property[])this.toPlatformProperties());
        }
    }

    static class StringAttribute
    extends Attribute<String> {
        StringAttribute(String name, String defaultValue, boolean filtered) {
            super(name, defaultValue, filtered);
        }

        @Override
        protected Setting<String> toPlatformInstance() {
            if (this.defaultValue == null) {
                return Setting.simpleString((String)this.name, (Setting.Property[])this.toPlatformProperties());
            }
            return Setting.simpleString((String)this.name, (String)((String)this.defaultValue), (Setting.Property[])this.toPlatformProperties());
        }
    }
}

