/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.action;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchsupport.action.Action;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;

public class StandardResponse
extends Action.Response {
    private Error error;
    private String message;
    private Object data;

    public static StandardResponse internalServerError() {
        return new StandardResponse(500, new Error("Internal Server Error"));
    }

    public StandardResponse() {
    }

    public StandardResponse(int status) {
        this.status(status);
    }

    public StandardResponse(int status, String message) {
        this.status(status);
        this.message = message;
    }

    public StandardResponse(int status, Error error) {
        this.status(status);
        this.error = error;
    }

    public StandardResponse(ConfigValidationException e) {
        this.status(400);
        this.error = new Error(e.getMessage()).details(e.getValidationErrors().toBasicObject());
    }

    public StandardResponse(Exception e) {
        if (e instanceof ConfigValidationException) {
            this.status(400);
            this.error = new Error(e.getMessage()).details(((ConfigValidationException)((Object)e)).getValidationErrors().toBasicObject());
        } else {
            this.status(ExceptionsHelper.status((Throwable)e).getStatus());
            this.error = new Error(e.getMessage());
        }
    }

    public StandardResponse(Action.UnparsedMessage message) throws ConfigValidationException {
        super(message);
        DocNode docNode = message.requiredDocNode();
        this.message = docNode.getAsString("message");
        this.error = docNode.hasNonNull("error") ? new Error(docNode.getAsNode("error")) : null;
        this.data = docNode.hasNonNull("data") ? docNode.get("data") : null;
    }

    public StandardResponse data(Object data) {
        this.data = data;
        return this;
    }

    public StandardResponse data(Map<?, ? extends Document<?>> map) {
        if (map == null) {
            this.data = null;
        } else {
            LinkedHashMap<String, Object> plainMap = new LinkedHashMap<String, Object>(map.size());
            for (Map.Entry<?, Document<?>> entry : map.entrySet()) {
                plainMap.put(String.valueOf(entry.getKey()), entry.getValue() != null ? entry.getValue().toBasicObject() : null);
            }
            this.data = plainMap;
        }
        return this;
    }

    public StandardResponse message(String message) {
        this.message = message;
        return this;
    }

    public StandardResponse error(Error error) {
        this.error = error;
        return this;
    }

    public StandardResponse error(String message) {
        this.error = new Error(message);
        return this;
    }

    public StandardResponse error(String code, String message, Object details) {
        this.error = new Error(code, message, details);
        return this;
    }

    public StandardResponse error(ConfigValidationException e) {
        this.error = new Error(null, e.getMessage(), e.getValidationErrors().toMap());
        return this;
    }

    public StandardResponse error(ValidationErrors validationErrors) {
        return this.error(new ConfigValidationException(validationErrors));
    }

    @Override
    public StandardResponse eTag(String concurrencyControlEntityTag) {
        super.eTag(concurrencyControlEntityTag);
        return this;
    }

    public Object toBasicObject() {
        return OrderedImmutableMap.ofNonNull((Object)"status", (Object)this.getStatus(), (Object)"error", (Object)(this.error != null ? this.error.toBasicObject() : null), (Object)"message", (Object)this.message, (Object)"data", (Object)this.data);
    }

    public static class Error
    implements Document<Error> {
        private final String message;
        private final String code;
        private final Object details;

        public Error(String message) {
            this.message = message;
            this.code = null;
            this.details = null;
        }

        public Error(DocNode docNode) {
            this.message = docNode.getAsString("message");
            this.code = docNode.getAsString("code");
            this.details = docNode.get("details");
        }

        private Error(String code, String message, Object details) {
            this.message = message;
            this.code = code;
            this.details = details;
        }

        public Error details(Object details) {
            return new Error(this.code, this.message, details);
        }

        public Error code(String code) {
            return new Error(code, this.message, this.details);
        }

        public Object toBasicObject() {
            return OrderedImmutableMap.ofNonNull((Object)"code", (Object)this.code, (Object)"message", (Object)this.message, (Object)"details", (Object)this.details);
        }
    }
}

