/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import com.floragunn.searchsupport.cstate.metrics.TimeAggregation;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface Meter
extends AutoCloseable {
    public static final Logger log = LogManager.getLogger(Meter.class);
    public static final Meter NO_OP = new Meter(){

        @Override
        public void close() {
        }

        @Override
        public Meter basic(String name) {
            return NO_OP;
        }

        @Override
        public Meter detail(String name) {
            return NO_OP;
        }

        @Override
        public void count(String name) {
        }

        @Override
        public void count(String name, long count) {
        }
    };

    public static Meter basic(MetricsLevel level, TimeAggregation sink) {
        if (level == null) {
            log.error("null level supplied to Meter. Ignoring.", (Throwable)new Exception());
            return NO_OP;
        }
        if (level.basicEnabled()) {
            return new SystemCurrentTimeMillisMeter(level, sink);
        }
        return NO_OP;
    }

    public static Meter basic(MetricsLevel level, Measurement<?> sink) {
        if (level == null) {
            log.error("null level supplied to Meter. Ignoring.", (Throwable)new Exception());
            return NO_OP;
        }
        if (level.basicEnabled()) {
            if (sink instanceof TimeAggregation) {
                return new SystemCurrentTimeMillisMeter(level, (TimeAggregation)sink);
            }
            if (sink instanceof CountAggregation) {
                return new CountingMeter(level, (CountAggregation)sink);
            }
            return NO_OP;
        }
        return NO_OP;
    }

    public static Meter detail(MetricsLevel level, Measurement<?> sink) {
        if (level == null) {
            log.error("null level supplied to Meter. Ignoring.", (Throwable)new Exception());
            return NO_OP;
        }
        if (level.detailedEnabled()) {
            if (sink instanceof TimeAggregation.Nanoseconds) {
                return new SystemNanoTimeMeter(level, (TimeAggregation.Nanoseconds)sink);
            }
            if (sink instanceof TimeAggregation) {
                return new SystemCurrentTimeMillisMeter(level, (TimeAggregation)sink);
            }
            if (sink instanceof CountAggregation) {
                return new CountingMeter(level, (CountAggregation)sink);
            }
            return NO_OP;
        }
        return NO_OP;
    }

    @Override
    public void close();

    public Meter basic(String var1);

    public Meter detail(String var1);

    public void count(String var1);

    public void count(String var1, long var2);

    default public <O> Consumer<O> accept(Class<O> o) {
        return new Consumer<O>(){

            @Override
            public void accept(O t) {
                Meter.this.close();
            }
        };
    }

    default public <O> Consumer<O> consumer(final Consumer<O> delegate) {
        return new Consumer<O>(){

            @Override
            public void accept(O t) {
                Meter.this.close();
                delegate.accept(t);
            }
        };
    }

    default public Consumer<Exception> acceptException() {
        return new Consumer<Exception>(){

            @Override
            public void accept(Exception t) {
                Meter.this.close();
            }
        };
    }

    public static class SystemCurrentTimeMillisMeter
    implements Meter {
        private static final Logger log = LogManager.getLogger(SystemCurrentTimeMillisMeter.class);
        private final MetricsLevel level;
        private final TimeAggregation sink;
        private final long start;
        private boolean active = true;

        public SystemCurrentTimeMillisMeter(MetricsLevel level, TimeAggregation sink) {
            this.level = level;
            this.sink = sink;
            this.start = System.currentTimeMillis();
        }

        @Override
        public void close() {
            long end = System.currentTimeMillis();
            this.active = false;
            this.sink.recordMs(end - this.start);
        }

        @Override
        public Meter basic(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            return new SystemCurrentTimeMillisMeter(this.level, this.sink.getSubAggregation(name));
        }

        @Override
        public Meter detail(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            if (this.level.detailedEnabled()) {
                return new SystemCurrentTimeMillisMeter(this.level, this.sink.getSubAggregation(name));
            }
            return NO_OP;
        }

        @Override
        public void count(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            this.sink.getCountAggregation(name).increment();
        }

        @Override
        public void count(String name, long count) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            this.sink.getCountAggregation(name).add(count);
        }
    }

    public static class CountingMeter
    implements Meter {
        private static final Logger log = LogManager.getLogger(CountingMeter.class);
        private final MetricsLevel level;
        private final CountAggregation sink;
        private boolean active = true;

        public CountingMeter(MetricsLevel level, CountAggregation sink) {
            this.level = level;
            this.sink = sink;
        }

        @Override
        public void close() {
            this.active = false;
            this.sink.increment();
        }

        @Override
        public Meter basic(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            return new CountingMeter(this.level, this.sink.getSubCount(name));
        }

        @Override
        public Meter detail(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            if (this.level.detailedEnabled()) {
                return new CountingMeter(this.level, this.sink.getSubCount(name));
            }
            return NO_OP;
        }

        @Override
        public void count(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            this.sink.getSubCount(name).increment();
        }

        @Override
        public void count(String name, long count) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            this.sink.getSubCount(name).add(count);
        }
    }

    public static class SystemNanoTimeMeter
    implements Meter {
        private static final Logger log = LogManager.getLogger(SystemNanoTimeMeter.class);
        private final MetricsLevel level;
        private final TimeAggregation sink;
        private final long start;
        private boolean active = true;

        public SystemNanoTimeMeter(MetricsLevel level, TimeAggregation sink) {
            this.level = level;
            this.sink = sink;
            this.start = System.nanoTime();
        }

        @Override
        public void close() {
            long end = System.nanoTime();
            this.active = false;
            this.sink.recordNs(end - this.start);
        }

        @Override
        public Meter basic(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            return new SystemNanoTimeMeter(this.level, this.sink.getSubAggregation(name));
        }

        @Override
        public Meter detail(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            if (this.level.detailedEnabled()) {
                return new SystemNanoTimeMeter(this.level, this.sink.getSubAggregation(name));
            }
            return NO_OP;
        }

        @Override
        public void count(String name) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            this.sink.getCountAggregation(name).increment();
        }

        @Override
        public void count(String name, long count) {
            if (!this.active) {
                log.error("Trying to start sub-meter for inactive meter", new Throwable());
            }
            this.sink.getCountAggregation(name).add(count);
        }
    }
}

