/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.client;

import com.floragunn.searchsupport.client.RefCountedGuard;
import org.elasticsearch.core.RefCounted;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RefCountedGuardTest {
    @Mock
    private RefCounted refCountedOne;
    @Mock
    private RefCounted refCountedTwo;
    @Mock
    private RefCounted refCountedThree;
    @Mock
    private RefCounted refCountedFour;
    @Mock
    private RefCounted refCountedFive;
    private RefCountedGuard<RefCounted> guard;

    @Before
    public void setUp() {
        this.guard = new RefCountedGuard();
    }

    @Test
    public void shouldNotInvokeAnyMethodOnTrackedObject() {
        this.guard.add(this.refCountedOne);
        this.guard.add(this.refCountedTwo);
        this.guard.add(this.refCountedThree);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree});
    }

    @Test
    public void shouldReleaseResources() {
        this.guard.add(this.refCountedOne);
        this.guard.release();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne)).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne});
    }

    @Test
    public void shouldReleaseResourcesOnlyOnce() {
        this.guard.add(this.refCountedOne);
        this.guard.release();
        this.guard.release();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne, (VerificationMode)Mockito.times((int)1))).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne});
    }

    @Test
    public void shouldReleaseMultipleResources() {
        this.guard.add(this.refCountedOne);
        this.guard.add(this.refCountedTwo);
        this.guard.add(this.refCountedThree);
        this.guard.release();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne)).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo)).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree)).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree});
    }

    @Test
    public void shouldReleaseResourceOnClose() {
        this.guard.add(this.refCountedOne);
        this.guard.add(this.refCountedTwo);
        this.guard.add(this.refCountedThree);
        this.guard.close();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne)).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo)).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree)).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree});
    }

    @Test
    public void shouldNotReleaseResourcesOnCloseWhenResourcesWasPreviouslyReleased() {
        this.guard.add(this.refCountedOne);
        this.guard.add(this.refCountedTwo);
        this.guard.add(this.refCountedThree);
        this.guard.release();
        this.guard.close();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree, (VerificationMode)Mockito.times((int)1))).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree});
    }

    @Test
    public void shouldReleaseResourceMultipleTimes() {
        this.guard.add(this.refCountedOne);
        this.guard.add(this.refCountedTwo);
        this.guard.add(this.refCountedThree);
        this.guard.release();
        this.guard.add(this.refCountedFour);
        this.guard.add(this.refCountedFive);
        this.guard.release();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFour, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFive, (VerificationMode)Mockito.times((int)1))).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree, this.refCountedFour, this.refCountedFive});
    }

    @Test
    public void shouldReleaseResourceSecondTimeOnClode() {
        this.guard.add(this.refCountedOne);
        this.guard.add(this.refCountedTwo);
        this.guard.add(this.refCountedThree);
        this.guard.release();
        this.guard.add(this.refCountedFour);
        this.guard.add(this.refCountedFive);
        this.guard.close();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFour, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFive, (VerificationMode)Mockito.times((int)1))).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree, this.refCountedFour, this.refCountedFive});
    }

    @Test
    public void shouldReleaseResourceFiveTimes() {
        this.guard.add(this.refCountedOne);
        this.guard.release();
        this.guard.add(this.refCountedTwo);
        this.guard.release();
        this.guard.add(this.refCountedThree);
        this.guard.release();
        this.guard.add(this.refCountedFour);
        this.guard.release();
        this.guard.add(this.refCountedFive);
        this.guard.close();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFour, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFive, (VerificationMode)Mockito.times((int)1))).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree, this.refCountedFour, this.refCountedFive});
    }

    @Test
    public void shouldIgnoreExceptionDuringReleasingResources() {
        ((RefCounted)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException("For test purposes")}).when((Object)this.refCountedThree)).decRef();
        this.guard.add(this.refCountedOne);
        this.guard.release();
        this.guard.add(this.refCountedTwo);
        this.guard.release();
        this.guard.add(this.refCountedThree);
        this.guard.release();
        this.guard.add(this.refCountedFour);
        this.guard.release();
        this.guard.add(this.refCountedFive);
        this.guard.close();
        ((RefCounted)Mockito.verify((Object)this.refCountedOne, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedTwo, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedThree, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFour, (VerificationMode)Mockito.times((int)1))).decRef();
        ((RefCounted)Mockito.verify((Object)this.refCountedFive, (VerificationMode)Mockito.times((int)1))).decRef();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.refCountedOne, this.refCountedTwo, this.refCountedThree, this.refCountedFour, this.refCountedFive});
    }
}

