/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ContainsFieldPointedByJsonPathMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private static final Logger log = LogManager.getLogger(ContainsFieldPointedByJsonPathMatcher.class);
    private final String jsonPath;
    private final String fieldName;

    public ContainsFieldPointedByJsonPathMatcher(String jsonPath, String fieldName) {
        this.jsonPath = Objects.requireNonNull(jsonPath);
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    public void describeTo(Description description) {
        description.appendText("DocNode should contain field ").appendValue((Object)this.fieldName).appendText(" pointed out by json path ").appendValue((Object)this.jsonPath);
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        if (log.isDebugEnabled()) {
            log.debug("Checking id DocNode {} contain field {} at path {}", (Object)docNode.toPrettyJsonString(), (Object)this.fieldName, (Object)this.jsonPath);
        }
        try {
            ImmutableList nodes = docNode.findNodesByJsonPath(this.jsonPath);
            int numberOfNodes = nodes.size();
            if (numberOfNodes != 1) {
                mismatchDescription.appendText("Found ").appendValue((Object)numberOfNodes).appendText(" nodes pointed by json path ").appendValue((Object)this.jsonPath).appendText(" whereas expected number of nodes is 1.");
                return false;
            }
            DocNode selectedDocNode = (DocNode)nodes.get(0);
            if (!selectedDocNode.containsKey((Object)this.fieldName)) {
                mismatchDescription.appendText("Node pointed by json path ").appendValue((Object)this.jsonPath).appendText(" does not contain field ").appendValue((Object)this.fieldName);
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            log.debug("Patch {} not found in DocNode {}.", (Object)this.jsonPath, (Object)docNode, (Object)e);
            mismatchDescription.appendText("path ").appendValue((Object)this.jsonPath).appendText(" does not exists in doc node ").appendValue((Object)docNode.toJsonString());
            return false;
        }
    }
}

