/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ContainsNullValuePointedByJsonPathMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private static final Logger log = LogManager.getLogger(ContainsNullValuePointedByJsonPathMatcher.class);
    private final String jsonPath;

    public ContainsNullValuePointedByJsonPathMatcher(String jsonPath) {
        this.jsonPath = Objects.requireNonNull(jsonPath);
    }

    public void describeTo(Description description) {
        description.appendText("DocNode should contain field ").appendValue((Object)this.jsonPath).appendText(" with null value ");
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        if (log.isDebugEnabled()) {
            log.debug("Checking if DocNode {} contain field {} with null value {}", (Object)docNode.toPrettyJsonString(), (Object)this.jsonPath);
        }
        try {
            Object nodeValue = docNode.findSingleValueByJsonPath(this.jsonPath, Object.class);
            if (!Objects.isNull(nodeValue)) {
                mismatchDescription.appendText("Node pointed by json path ").appendValue((Object)this.jsonPath).appendText(" is not null, actual value: ").appendValue(nodeValue);
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            log.debug("Patch {} not found in DocNode {}.", (Object)this.jsonPath, (Object)docNode, (Object)e);
            mismatchDescription.appendText(" path ").appendValue((Object)this.jsonPath).appendText(" does not exists in doc node ").appendValue((Object)docNode.toJsonString());
            return false;
        }
    }
}

