/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchsupport.junit.matcher.ContainsFieldPointedByJsonPathMatcher;
import com.floragunn.searchsupport.junit.matcher.ContainsFieldValuePointedByJsonPathMatcher;
import com.floragunn.searchsupport.junit.matcher.ContainsNullValuePointedByJsonPathMatcher;
import com.floragunn.searchsupport.junit.matcher.ContainsOnlyFieldsMatcher;
import com.floragunn.searchsupport.junit.matcher.DocNodeSizeEqualToMatcher;
import com.floragunn.searchsupport.junit.matcher.FieldContainSubstringMatcher;
import com.floragunn.searchsupport.junit.matcher.FieldIsNullMatcher;
import com.floragunn.searchsupport.junit.matcher.JsonPathValueSatisfiesMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DocNodeMatchers {
    private DocNodeMatchers() {
    }

    public static Matcher<DocNode> containsFieldPointedByJsonPath(String jsonPath, String fieldName) {
        return new ContainsFieldPointedByJsonPathMatcher(jsonPath, fieldName);
    }

    public static Matcher<DocNode> docNodeSizeEqualTo(String jsonPath, int expectedSize) {
        return new DocNodeSizeEqualToMatcher(jsonPath, expectedSize);
    }

    public static Matcher<DocNode> containsValue(String jsonPath, Object value) {
        return new ContainsFieldValuePointedByJsonPathMatcher(jsonPath, value);
    }

    public static Matcher<DocNode> containsNullValue(String jsonPath) {
        return new ContainsNullValuePointedByJsonPathMatcher(jsonPath);
    }

    public static <T> Matcher<DocNode> containsAnyValues(String jsonPatch, T ... values) {
        Objects.requireNonNull(values, "Expected values array is null");
        Class<?> elementClass = values.getClass().getComponentType();
        Matcher[] matchers = (Matcher[])Arrays.stream(values).map(CoreMatchers::equalTo).toArray(Matcher[]::new);
        return DocNodeMatchers.valueSatisfiesMatcher(jsonPatch, elementClass, CoreMatchers.anyOf((Matcher[])matchers));
    }

    public static Matcher<DocNode> containSubstring(String jsonPath, String desiredSubstring) {
        return new FieldContainSubstringMatcher(jsonPath, desiredSubstring);
    }

    public static <T> Matcher<DocNode> valueSatisfiesMatcher(String jsonPath, Class<T> valueClazz, Matcher<T> matcher) {
        return new JsonPathValueSatisfiesMatcher<T>(jsonPath, matcher, valueClazz);
    }

    public static Matcher<DocNode> fieldIsNull(String jsonPath) {
        return new FieldIsNullMatcher(jsonPath);
    }

    public static Matcher<DocNode> containsOnlyFields(String jsonPath, String ... fieldNames) {
        return new ContainsOnlyFieldsMatcher(jsonPath, fieldNames);
    }

    public static Matcher<DocNode> containsOnlyFields(String jsonPath, Collection<String> fieldNames) {
        return new ContainsOnlyFieldsMatcher(jsonPath, (String[])fieldNames.toArray(String[]::new));
    }
}

