/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class FieldContainSubstringMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private final String jsonPath;
    private final String substring;

    public FieldContainSubstringMatcher(String jsonPath, String substring) {
        this.jsonPath = Objects.requireNonNull(jsonPath, "Json path is required");
        this.substring = Objects.requireNonNull(substring, "Substring is required");
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        try {
            String textFieldValue = (String)docNode.findSingleValueByJsonPath(this.jsonPath, String.class);
            if (textFieldValue == null) {
                mismatchDescription.appendText(" the field is null");
                return false;
            }
            if (Strings.isEmpty((CharSequence)textFieldValue)) {
                mismatchDescription.appendText(" the field is empty");
                return false;
            }
            if (!textFieldValue.contains(this.substring)) {
                mismatchDescription.appendText(" the field with value ").appendValue((Object)textFieldValue).appendText(" does not contain desired substring");
                return false;
            }
        }
        catch (PathNotFoundException e) {
            mismatchDescription.appendText("DocNode ").appendText(docNode.toJsonString()).appendText(" does not contain property pointed out by path ").appendValue((Object)this.jsonPath);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("DocNode should contain substring ").appendValue((Object)this.substring).appendText(" in field pointed out by path ").appendValue((Object)this.jsonPath);
    }
}

