/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class JsonPathValueSatisfiesMatcher<T>
extends TypeSafeDiagnosingMatcher<DocNode> {
    private final String jsonPath;
    private final Matcher<T> matcher;
    private final Class<T> clazz;

    public JsonPathValueSatisfiesMatcher(String jsonPath, Matcher<T> matcher, Class<T> clazz) {
        this.jsonPath = Objects.requireNonNull(jsonPath);
        this.matcher = Objects.requireNonNull(matcher);
        this.clazz = Objects.requireNonNull(clazz);
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        try {
            Object value = docNode.findSingleValueByJsonPath(this.jsonPath, this.clazz);
            if (!this.matcher.matches(value)) {
                this.matcher.describeMismatch(value, mismatchDescription);
                return false;
            }
        }
        catch (PathNotFoundException e) {
            mismatchDescription.appendText(" DocNode ").appendText(docNode.toJsonString()).appendText(" does not contain property pointed out by path ").appendValue((Object)this.jsonPath);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(" value pointed by json path ").appendValue((Object)this.jsonPath).appendText(" must be ");
        this.matcher.describeTo(description);
    }
}

