/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.util;

import com.floragunn.searchsupport.util.LocalClusterAliasExtractor;
import org.elasticsearch.action.search.LocalClusterAliasAwareSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.junit.Assert;
import org.junit.Test;

public class LocalClusterAliasExtractorTest {
    @Test
    public void testExtractionNoLocalClusterAlias() {
        Assert.assertNull((Object)LocalClusterAliasExtractor.getLocalClusterAliasFromSearchRequest((SearchRequest)new SearchRequest()));
        Assert.assertNull((Object)LocalClusterAliasExtractor.getLocalClusterAliasFromSearchRequest((SearchRequest)new SearchRequest(new String[]{"xxx"})));
    }

    @Test
    public void testExtractionLocalClusterAlias() {
        SearchRequest searchRequest = LocalClusterAliasAwareSearchRequest.createSearchRequestWithClusterAlias(new SearchRequest(), "myalias", "a", "b");
        Assert.assertEquals((Object)"myalias", (Object)LocalClusterAliasExtractor.getLocalClusterAliasFromSearchRequest((SearchRequest)searchRequest));
    }

    @Test
    public void testExtractionLocalClusterAlias2() {
        SearchRequest searchRequest = LocalClusterAliasAwareSearchRequest.createSearchRequestWithClusterAlias(new SearchRequest(new String[]{"xxx"}), "myalias1", "a", "b");
        Assert.assertEquals((Object)"myalias1", (Object)LocalClusterAliasExtractor.getLocalClusterAliasFromSearchRequest((SearchRequest)searchRequest));
    }

    @Test
    public void testExtractionLocalClusterAlias3() {
        SearchRequest searchRequest = LocalClusterAliasAwareSearchRequest.createSearchRequestWithClusterAlias(new SearchRequest(new String[]{"xxx"}), "", "a", "b");
        Assert.assertEquals((Object)"", (Object)LocalClusterAliasExtractor.getLocalClusterAliasFromSearchRequest((SearchRequest)searchRequest));
    }
}

