/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class CauseIsInstanceOfMatcher
extends TypeSafeDiagnosingMatcher<Throwable> {
    private final Class<? extends Throwable> causeType;

    public CauseIsInstanceOfMatcher(Class<? extends Throwable> causeType) {
        this.causeType = Objects.requireNonNull(causeType, "Cause type is required");
    }

    protected boolean matchesSafely(Throwable item, Description mismatchDescription) {
        Throwable cause = item.getCause();
        if (cause == null) {
            mismatchDescription.appendText(" cause is null ");
            return false;
        }
        if (!this.causeType.isInstance(cause)) {
            mismatchDescription.appendText(" has not expected cause type ").appendValue((Object)cause);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("Exception contain a cause of type ").appendValue(this.causeType);
    }
}

