/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.meta;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableCollection;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.searchsupport.meta.Meta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;

public abstract class MetaImpl
implements Meta {
    private static final Logger log = LogManager.getLogger(MetaImpl.class);

    public static class NonExistentDataStreamImpl
    extends AbstractNonExistentImpl
    implements Meta.DataStream {
        public NonExistentDataStreamImpl(String name) {
            super(name);
        }

        @Override
        public ImmutableSet<Meta.IndexOrNonExistent> resolveDeep(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> resolveDeepToNames(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public UnmodifiableCollection<Meta.IndexLikeObject> members() {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableSet<Meta.Index> resolveDeepAsIndex(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }
    }

    public static class NonExistentAliasImpl
    extends AbstractNonExistentImpl
    implements Meta.Alias {
        public NonExistentAliasImpl(String name) {
            super(name);
        }

        @Override
        public ImmutableSet<Meta.IndexOrNonExistent> resolveDeep(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> resolveDeepToNames(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public UnmodifiableCollection<Meta.IndexLikeObject> members() {
            return ImmutableList.empty();
        }

        @Override
        public ImmutableSet<Meta.Index> resolveDeepAsIndex(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public Meta.IndexLikeObject writeTarget() {
            return null;
        }

        @Override
        public UnmodifiableCollection<Meta.IndexLikeObject> resolve(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableList.empty();
        }
    }

    public static class NonExistentIndexImpl
    extends AbstractNonExistentImpl
    implements Meta.Index {
        public NonExistentIndexImpl(String name) {
            super(name);
        }

        @Override
        public ImmutableSet<Meta.IndexOrNonExistent> resolveDeep(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<String> resolveDeepToNames(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.empty();
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean isSystem() {
            return false;
        }

        @Override
        public boolean isDataStreamBackingIndex() {
            return false;
        }
    }

    public static class NonExistentImpl
    extends AbstractNonExistentImpl
    implements Meta.NonExistent {
        public NonExistentImpl(String name) {
            super(name);
        }

        @Override
        public ImmutableSet<Meta.IndexOrNonExistent> resolveDeep(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.of((Object)this);
        }

        @Override
        public ImmutableSet<String> resolveDeepToNames(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.of((Object)this.name());
        }
    }

    static abstract class AbstractNonExistentImpl
    implements Meta.IndexLikeObject {
        private final String name;

        public AbstractNonExistentImpl(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Collection<String> parentAliasNames() {
            return ImmutableSet.empty();
        }

        @Override
        public Collection<String> ancestorAliasNames() {
            return ImmutableSet.empty();
        }

        @Override
        public String parentDataStreamName() {
            return null;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public ImmutableSet<Meta.Alias> parentAliases() {
            return ImmutableSet.empty();
        }

        @Override
        public Meta.DataStream parentDataStream() {
            return null;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Meta.IndexLikeObject) {
                return ((Meta.IndexLikeObject)other).name().equals(this.name()) && !((Meta.IndexLikeObject)other).exists();
            }
            return false;
        }

        public String toString() {
            return this.name;
        }

        public Object toBasicObject() {
            return DocNode.of((String)"name", (Object)this.name(), (String)"exists", (Object)false);
        }
    }

    static class DataStreamBuilderImpl
    implements Meta.Mock.DataStreamBuilder {
        private final String name;

        DataStreamBuilderImpl(String name) {
            this.name = name;
        }

        @Override
        public Meta of(String ... indexNames) {
            ImmutableSet indices = ImmutableSet.map(Arrays.asList(indexNames), k -> new IndexImpl(null, (String)k, null, this.name));
            ImmutableSet dataStreams = ImmutableSet.of((Object)new DataStreamImpl(null, this.name, (Collection<String>)ImmutableSet.empty(), (UnmodifiableCollection<Meta.IndexLikeObject>)ImmutableSet.of((Collection)indices), false));
            return new DefaultMetaImpl((ImmutableSet<Meta.Index>)indices, (ImmutableSet<Meta.Alias>)ImmutableSet.empty(), (ImmutableSet<Meta.DataStream>)dataStreams, (ImmutableSet<Meta.Index>)ImmutableSet.empty());
        }
    }

    static class AliasBuilderImpl
    implements Meta.Mock.AliasBuilder {
        private final String name;

        AliasBuilderImpl(String name) {
            this.name = name;
        }

        @Override
        public Meta of(String ... indexNames) {
            ImmutableSet aliasSet = ImmutableSet.of((Object)this.name);
            ImmutableSet indices = ImmutableSet.map(Arrays.asList(indexNames), k -> new IndexImpl(null, (String)k, (Collection<String>)aliasSet, null));
            ImmutableSet aliases = ImmutableSet.of((Object)new AliasImpl(null, this.name, (UnmodifiableCollection<Meta.IndexLikeObject>)ImmutableSet.of((Collection)indices), false, indices.size() == 1 ? (Meta.IndexLikeObject)indices.only() : null));
            return new DefaultMetaImpl((ImmutableSet<Meta.Index>)indices, (ImmutableSet<Meta.Alias>)aliases, (ImmutableSet<Meta.DataStream>)ImmutableSet.empty(), (ImmutableSet<Meta.Index>)ImmutableSet.empty());
        }
    }

    static class DefaultMetaImpl
    extends MetaImpl {
        private final ImmutableSet<Meta.Index> indices;
        private final ImmutableSet<Meta.Alias> aliases;
        private final ImmutableSet<Meta.DataStream> dataStreams;
        private final ImmutableSet<Meta.Index> indicesWithoutParents;
        private final ImmutableSet<Meta.Index> nonHiddenIndicesWithoutParents;
        private final ImmutableSet<Meta.Index> nonHiddenIndices;
        private final ImmutableSet<Meta.Index> nonSystemIndices;
        private final ImmutableSet<Meta.Index> nonSystemIndicesWithoutParents;
        private final ImmutableSet<Meta.IndexCollection> indexCollections;
        private final ImmutableSet<Meta.Alias> nonHiddenAliases;
        private final ImmutableSet<Meta.DataStream> nonHiddenDataStreams;
        private final ImmutableMap<String, Meta.IndexLikeObject> nameMap;
        private final Metadata esMetadata;
        private static final AtomicReference<DefaultMetaImpl> currentInstance = new AtomicReference();

        public DefaultMetaImpl(ImmutableSet<Meta.Index> indices, ImmutableSet<Meta.Alias> aliases, ImmutableSet<Meta.DataStream> datastreams, ImmutableSet<Meta.Index> indicesWithoutParents) {
            indices.forEach(i -> ((AbstractIndexLike)((Object)i)).root(this));
            aliases.forEach(i -> ((AbstractIndexLike)((Object)i)).root(this));
            datastreams.forEach(i -> ((AbstractIndexLike)((Object)i)).root(this));
            this.indices = indices;
            this.aliases = aliases;
            this.dataStreams = datastreams;
            this.indicesWithoutParents = indicesWithoutParents;
            this.indexCollections = ImmutableSet.of(aliases).with(datastreams);
            this.nonHiddenIndicesWithoutParents = this.indicesWithoutParents.matching(e -> !e.isHidden());
            this.nonHiddenIndices = this.indices.matching(e -> !e.isHidden());
            this.nonSystemIndices = this.indices.matching(e -> !e.isSystem());
            this.nonSystemIndicesWithoutParents = this.indicesWithoutParents.matching(e -> !e.isSystem());
            this.nonHiddenAliases = this.aliases.matching(e -> !e.isHidden());
            this.nonHiddenDataStreams = this.dataStreams.matching(e -> !e.isHidden());
            this.nameMap = ImmutableMap.of((Map)ImmutableMap.map(indices, e -> ImmutableMap.entry((Object)e.name(), (Object)e))).with(ImmutableMap.map(this.indexCollections, e -> ImmutableMap.entry((Object)e.name(), (Object)e)));
            Metadata.Builder esMetadataBuilder = Metadata.builder();
            HashMap<String, AliasMetadata> esAliasMetadata = new HashMap<String, AliasMetadata>();
            for (Meta.Alias alias : aliases) {
                esAliasMetadata.put(alias.name(), AliasMetadata.builder((String)alias.name()).build());
            }
            for (Meta.Index index : indices) {
                IndexMetadata.Builder esIndex = IndexMetadata.builder((String)index.name()).settings(Settings.builder().put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), (VersionId)Version.CURRENT)).numberOfShards(1).numberOfReplicas(1);
                for (String alias : index.parentAliasNames()) {
                    esIndex.putAlias((AliasMetadata)esAliasMetadata.get(alias));
                }
                esMetadataBuilder.put(esIndex);
            }
            for (Meta.DataStream dataStream : datastreams) {
                esMetadataBuilder.put(new DataStream(dataStream.name(), (List)ImmutableList.of(dataStream.members()).map(i -> new Index(i.name(), i.name())), 1L, (Map)ImmutableMap.empty(), false, false, false, false, IndexMode.STANDARD, DataStreamLifecycle.DEFAULT_DATA_LIFECYCLE, DataStreamOptions.FAILURE_STORE_DISABLED, (List)ImmutableList.empty(), false, null));
            }
            this.esMetadata = esMetadataBuilder.build();
        }

        public DefaultMetaImpl(Metadata esMetadata) {
            ProjectMetadata project = esMetadata.getProject();
            ImmutableSet.Builder indices = new ImmutableSet.Builder(project.indices().size());
            ImmutableMap.Builder nameMap = new ImmutableMap.Builder(project.indices().size());
            ImmutableSet.Builder indicesWithoutParents = new ImmutableSet.Builder(project.indices().size());
            ImmutableMap.Builder aliasToIndicesMap = new ImmutableMap.Builder().defaultValue(k -> new ImmutableList.Builder());
            ImmutableMap.Builder aliasToWriteIndexMap = new ImmutableMap.Builder();
            ImmutableMap.Builder dataStreamAliasToIndicesMap = new ImmutableMap.Builder().defaultValue(k -> new ArrayList());
            ImmutableSet.Builder aliases = new ImmutableSet.Builder(64);
            ImmutableSet.Builder datastreams = new ImmutableSet.Builder(project.dataStreams().size());
            this.esMetadata = esMetadata;
            Map dataStreamsAliases = project.dataStreamAliases();
            HashMap<String, ImmutableList.Builder> dataStreamAliasReverseLookup = new HashMap<String, ImmutableList.Builder>();
            for (DataStreamAlias dataStreamAlias : dataStreamsAliases.values()) {
                for (Object dataStream : dataStreamAlias.getDataStreams()) {
                    dataStreamAliasReverseLookup.computeIfAbsent((String)dataStream, k -> new ImmutableList.Builder()).add((Object)dataStreamAlias.getName());
                }
            }
            for (DataStream esDataStream : project.dataStreams().values()) {
                ImmutableList.Builder memberIndices = new ImmutableList.Builder(esDataStream.getIndices().size());
                for (Index esIndex : esDataStream.getIndices()) {
                    IndexMetadata esIndexMetadata = project.index(esIndex.getName());
                    IndexImpl index = new IndexImpl(this, esIndex.getName(), (Collection<String>)ImmutableSet.empty(), esDataStream.getName(), esIndexMetadata.isHidden(), esIndexMetadata.isSystem(), esIndexMetadata.getState());
                    indices.add((Object)index);
                    nameMap.put((Object)index.name(), (Object)index);
                    memberIndices.add((Object)index);
                }
                ImmutableList.Builder parentAliasNames = (ImmutableList.Builder)dataStreamAliasReverseLookup.get(esDataStream.getName());
                DataStreamImpl dataStream = new DataStreamImpl(this, esDataStream.getName(), (Collection<String>)(parentAliasNames != null ? parentAliasNames.build() : ImmutableList.empty()), (UnmodifiableCollection<Meta.IndexLikeObject>)memberIndices.build(), esDataStream.isHidden());
                datastreams.add((Object)dataStream);
                nameMap.put((Object)dataStream.name(), (Object)dataStream);
                for (String parentAlias : dataStream.parentAliasNames()) {
                    ((List)dataStreamAliasToIndicesMap.get((Object)((DataStreamAlias)dataStreamsAliases.get(parentAlias)))).add(dataStream);
                }
            }
            for (IndexMetadata esIndexMetadata : project.indices().values()) {
                String name = esIndexMetadata.getIndex().getName();
                if (nameMap.contains((Object)name)) continue;
                IndexImpl index = new IndexImpl(this, name, esIndexMetadata.getAliases().keySet(), null, esIndexMetadata.isHidden(), esIndexMetadata.isSystem(), esIndexMetadata.getState());
                indices.add((Object)index);
                nameMap.put((Object)name, (Object)index);
                if (esIndexMetadata.getAliases().isEmpty()) {
                    indicesWithoutParents.add((Object)index);
                }
                for (AliasMetadata esAliasMetadata : esIndexMetadata.getAliases().values()) {
                    ((ImmutableList.Builder)aliasToIndicesMap.get((Object)esAliasMetadata)).add((Object)index);
                    if (esAliasMetadata.writeIndex() == null || !esAliasMetadata.writeIndex().booleanValue()) continue;
                    aliasToWriteIndexMap.put((Object)esAliasMetadata, (Object)index);
                }
            }
            for (Map.Entry entry : aliasToIndicesMap.build().entrySet()) {
                DataStreamAlias dataStreamAlias = (DataStreamAlias)dataStreamsAliases.get(((AliasMetadata)entry.getKey()).alias());
                ImmutableList dataStreams = dataStreamAlias != null && dataStreamAliasToIndicesMap.contains((Object)dataStreamAlias) ? (List)dataStreamAliasToIndicesMap.get((Object)dataStreamAlias) : ImmutableList.empty();
                ImmutableList members = ((ImmutableList.Builder)entry.getValue()).build().with((Collection)dataStreams);
                Meta.IndexLikeObject writeTarget = (Meta.IndexLikeObject)aliasToWriteIndexMap.get((Object)((AliasMetadata)entry.getKey()));
                if (writeTarget == null && members.size() == 1) {
                    writeTarget = (Meta.IndexLikeObject)members.only();
                }
                AliasImpl alias = new AliasImpl(this, ((AliasMetadata)entry.getKey()).alias(), (UnmodifiableCollection<Meta.IndexLikeObject>)members, ((AliasMetadata)entry.getKey()).isHidden() != null ? ((AliasMetadata)entry.getKey()).isHidden() : false, writeTarget);
                aliases.add((Object)alias);
                nameMap.put((Object)alias.name(), (Object)alias);
            }
            for (Map.Entry entry : dataStreamAliasToIndicesMap.build().entrySet()) {
                if (nameMap.contains((Object)((DataStreamAlias)entry.getKey()).getName())) continue;
                Meta.IndexLikeObject writeTarget = ((DataStreamAlias)entry.getKey()).getWriteDataStream() != null ? (Meta.IndexLikeObject)nameMap.get((Object)((DataStreamAlias)entry.getKey()).getWriteDataStream()) : null;
                AliasImpl alias = new AliasImpl(this, ((DataStreamAlias)entry.getKey()).getName(), (UnmodifiableCollection<Meta.IndexLikeObject>)ImmutableList.of((Collection)((Collection)entry.getValue())), false, writeTarget);
                aliases.add((Object)alias);
                nameMap.put((Object)alias.name(), (Object)alias);
            }
            this.indices = indices.build();
            this.indicesWithoutParents = indicesWithoutParents.build();
            this.aliases = aliases.build();
            this.dataStreams = datastreams.build();
            this.indexCollections = ImmutableSet.of(this.aliases).with(this.dataStreams);
            this.nonHiddenIndicesWithoutParents = this.indicesWithoutParents.matching(e -> !e.isHidden());
            this.nonHiddenIndices = this.indices.matching(e -> !e.isHidden());
            this.nonSystemIndices = this.indices.matching(e -> !e.isSystem());
            this.nonSystemIndicesWithoutParents = this.indicesWithoutParents.matching(e -> !e.isSystem());
            this.nonHiddenAliases = this.aliases.matching(e -> !e.isHidden());
            this.nonHiddenDataStreams = this.dataStreams.matching(e -> !e.isHidden());
            this.nameMap = nameMap.build();
        }

        @Override
        public Meta.IndexLikeObject getIndexOrLike(String name) {
            return (Meta.IndexLikeObject)this.nameMap.get((Object)name);
        }

        @Override
        public ImmutableMap<String, Meta.IndexLikeObject> indexLikeObjects() {
            return this.nameMap;
        }

        @Override
        public ImmutableSet<Meta.Index> indices() {
            return this.indices;
        }

        @Override
        public ImmutableSet<Meta.Index> indicesWithoutParents() {
            return this.indicesWithoutParents;
        }

        @Override
        public ImmutableSet<Meta.Alias> aliases() {
            return this.aliases;
        }

        @Override
        public ImmutableSet<Meta.DataStream> dataStreams() {
            return this.dataStreams;
        }

        @Override
        public ImmutableSet<Meta.IndexCollection> indexCollections() {
            return this.indexCollections;
        }

        @Override
        public ImmutableSet<Meta.Index> nonHiddenIndices() {
            return this.nonHiddenIndices;
        }

        @Override
        public ImmutableSet<Meta.Index> nonHiddenIndicesWithoutParents() {
            return this.nonHiddenIndicesWithoutParents;
        }

        @Override
        public ImmutableSet<Meta.Index> nonSystemIndices() {
            return this.nonSystemIndices;
        }

        @Override
        public ImmutableSet<Meta.Index> nonSystemIndicesWithoutParents() {
            return this.nonSystemIndicesWithoutParents;
        }

        @Override
        public ImmutableSet<Meta.Alias> nonHiddenAliases() {
            return this.nonHiddenAliases;
        }

        @Override
        public ImmutableSet<Meta.DataStream> nonHiddenDataStreams() {
            return this.nonHiddenDataStreams;
        }

        @Override
        public Iterable<String> namesOfIndices() {
            return this.indices.map(e -> e.name());
        }

        @Override
        public Iterable<String> namesOfIndexCollections() {
            return this.indexCollections.map(e -> e.name());
        }

        @Override
        public Meta.Mock.AliasBuilder alias(final String aliasName) {
            return new Meta.Mock.AliasBuilder(){

                @Override
                public Meta of(String ... indexNames) {
                    ImmutableSet singleAliasSet = ImmutableSet.of((Object)aliasName);
                    ImmutableMap.Builder aliasMembersBuilder = new ImmutableMap.Builder(((UnmodifiableIterator)indexNames).length);
                    ImmutableSet.Builder newIndices = new ImmutableSet.Builder(((UnmodifiableIterator)indexNames).length);
                    ImmutableSet.Builder newDataStreams = new ImmutableSet.Builder(((UnmodifiableIterator)indexNames).length);
                    Meta.IndexLikeObject writeTarget = null;
                    for (Object indexName : indexNames) {
                        IndexImpl indexLikeObject;
                        boolean setWriteTarget = false;
                        if (indexName.startsWith(">")) {
                            setWriteTarget = true;
                            indexName = indexName.substring(1);
                        }
                        indexLikeObject = (indexLikeObject = (IndexImpl)this.getIndexOrLike((String)indexName)) != null ? ((AbstractIndexLike)indexLikeObject).withAlias(aliasName) : new IndexImpl(null, (String)indexName, (Collection<String>)singleAliasSet, null);
                        if (setWriteTarget) {
                            writeTarget = indexLikeObject;
                        }
                        if (indexLikeObject instanceof Meta.DataStream) {
                            newDataStreams.add((Object)((Meta.DataStream)((Object)indexLikeObject)));
                        } else {
                            newIndices.add((Object)indexLikeObject);
                        }
                        aliasMembersBuilder.put(indexName, (Object)indexLikeObject);
                    }
                    for (Meta.Index existingIndex : indices) {
                        if (newIndices.contains((Object)existingIndex)) continue;
                        newIndices.add((Object)((IndexImpl)existingIndex).copy());
                    }
                    for (Meta.DataStream existingDataStream : dataStreams) {
                        if (newDataStreams.contains((Object)existingDataStream)) continue;
                        newDataStreams.add((Object)((DataStreamImpl)existingDataStream).copy());
                    }
                    UnmodifiableCollection members = aliasMembersBuilder.build().values();
                    if (writeTarget == null && members.size() == 1) {
                        writeTarget = (Meta.IndexLikeObject)members.iterator().next();
                    }
                    ImmutableSet aliases = ImmutableSet.of((Collection)aliases.map(i -> ((AliasImpl)i).copy())).with((Object)new AliasImpl(null, aliasName, (UnmodifiableCollection<Meta.IndexLikeObject>)members, false, writeTarget));
                    return new DefaultMetaImpl((ImmutableSet<Meta.Index>)newIndices.build(), (ImmutableSet<Meta.Alias>)aliases, (ImmutableSet<Meta.DataStream>)newDataStreams.build(), indicesWithoutParents);
                }
            };
        }

        @Override
        public Meta.Mock.DataStreamBuilder dataStream(final String dataStreamName) {
            return new Meta.Mock.DataStreamBuilder(){

                @Override
                public Meta of(String ... indexNames) {
                    ImmutableMap.Builder dataStreamMembersBuilder = new ImmutableMap.Builder(((UnmodifiableIterator)indexNames).length);
                    ImmutableSet.Builder newIndices = new ImmutableSet.Builder(((UnmodifiableIterator)indexNames).length);
                    for (UnmodifiableIterator indexName : indexNames) {
                        AbstractIndexLike indexLikeObject = (AbstractIndexLike)this.getIndexOrLike((String)indexName);
                        if (indexLikeObject != null) {
                            throw new RuntimeException("Cannot reuse datastream backing index");
                        }
                        indexLikeObject = new IndexImpl(null, (String)indexName, (Collection<String>)ImmutableSet.empty(), dataStreamName);
                        newIndices.add((Object)((Meta.Index)((Object)indexLikeObject)));
                        dataStreamMembersBuilder.put((Object)indexName, (Object)indexLikeObject);
                    }
                    for (Meta.Index existingIndex : indices) {
                        if (newIndices.contains((Object)existingIndex)) continue;
                        newIndices.add((Object)((IndexImpl)existingIndex).copy());
                    }
                    ImmutableSet indices = newIndices.build();
                    ImmutableSet dataStreams = ImmutableSet.of((Collection)dataStreams.map(i -> ((DataStreamImpl)i).copy())).with((Object)new DataStreamImpl(null, dataStreamName, (Collection<String>)ImmutableSet.empty(), (UnmodifiableCollection<Meta.IndexLikeObject>)dataStreamMembersBuilder.build().values(), false));
                    return new DefaultMetaImpl((ImmutableSet<Meta.Index>)indices, aliases, (ImmutableSet<Meta.DataStream>)dataStreams, indicesWithoutParents);
                }
            };
        }

        public String toString() {
            return "{indices: " + this.indices.size() + "; collections: " + this.indexCollections.size() + "}";
        }

        public Object toBasicObject() {
            return DocNode.of((String)"version", (Object)this.version(), (String)"indices", this.indices, (String)"aliases", this.aliases, (String)"data_streams", this.dataStreams, (String)"name_map", this.nameMap, (Object[])new Object[0]);
        }

        @Override
        public Metadata esMetadata() {
            return this.esMetadata;
        }

        @Override
        public long version() {
            return this.esMetadata != null ? this.esMetadata.version() : -1L;
        }

        static Meta indices(String ... indexNames) {
            ImmutableSet indices = ImmutableSet.map(Arrays.asList(indexNames), k -> new IndexImpl(null, (String)k, (Collection<String>)ImmutableSet.empty(), null));
            return new DefaultMetaImpl((ImmutableSet<Meta.Index>)indices, (ImmutableSet<Meta.Alias>)ImmutableSet.empty(), (ImmutableSet<Meta.DataStream>)ImmutableSet.empty(), (ImmutableSet<Meta.Index>)indices);
        }

        static Meta from(ClusterService clusterService) {
            DefaultMetaImpl currentInstance = DefaultMetaImpl.currentInstance.get();
            Metadata esMetadata = clusterService.state().metadata();
            if (currentInstance == null || currentInstance.esMetadata.version() != esMetadata.version() || !currentInstance.esMetadata.clusterUUID().equals(esMetadata.clusterUUID())) {
                currentInstance = new DefaultMetaImpl(esMetadata);
                DefaultMetaImpl.currentInstance.set(currentInstance);
                if (log.isTraceEnabled()) {
                    log.trace("New Meta:\n{}", (Object)currentInstance.toYamlString());
                }
            }
            return currentInstance;
        }
    }

    static abstract class AbstractIndexCollection<T>
    extends AbstractIndexLike<T>
    implements Meta.IndexCollection {
        private final UnmodifiableCollection<Meta.IndexLikeObject> members;
        private ImmutableSet<Meta.Index> cachedResolveDeepAsIndex;
        private ImmutableSet<Meta.Index> cachedResolveDeepAsIndexWrite;

        public AbstractIndexCollection(DefaultMetaImpl root, String name, Collection<String> parentAliasNames, String parentDataStreamName, UnmodifiableCollection<Meta.IndexLikeObject> members, boolean hidden) {
            super(root, name, parentAliasNames, parentDataStreamName, hidden);
            this.members = members;
        }

        @Override
        public UnmodifiableCollection<Meta.IndexLikeObject> members() {
            return this.members;
        }

        @Override
        protected ImmutableSet<Meta.IndexOrNonExistent> resolveDeepImpl(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.of(this.resolveDeepAsIndex(resolutionMode));
        }

        @Override
        public ImmutableSet<Meta.Index> resolveDeepAsIndex(Meta.Alias.ResolutionMode resolutionMode) {
            ImmutableSet result;
            Object object = result = resolutionMode == Meta.Alias.ResolutionMode.TO_WRITE_TARGET ? this.cachedResolveDeepAsIndexWrite : this.cachedResolveDeepAsIndex;
            if (result == null) {
                ImmutableSet.Builder builder = new ImmutableSet.Builder(this.members.size());
                for (Meta.IndexLikeObject member : this.members) {
                    if (member instanceof Meta.Index) {
                        builder.add((Object)((Meta.Index)member));
                        continue;
                    }
                    if (member instanceof Meta.IndexCollection) {
                        builder.addAll(((Meta.IndexCollection)member).resolveDeepAsIndex(resolutionMode));
                        continue;
                    }
                    throw new RuntimeException("Unexpected member " + String.valueOf(member) + " of " + String.valueOf(this));
                }
                result = builder.build();
                if (resolutionMode == Meta.Alias.ResolutionMode.TO_WRITE_TARGET) {
                    this.cachedResolveDeepAsIndexWrite = result;
                } else {
                    this.cachedResolveDeepAsIndex = result;
                }
            }
            return result;
        }

        @Override
        protected ImmutableSet<String> resolveDeepToNamesImpl(Meta.Alias.ResolutionMode resolutionMode) {
            ImmutableSet.Builder result = new ImmutableSet.Builder(this.members.size());
            for (Meta.IndexLikeObject member : this.members) {
                if (member instanceof Meta.Index) {
                    result.add((Object)member.name());
                    continue;
                }
                result.addAll(member.resolveDeepToNames(resolutionMode));
            }
            return result.build();
        }
    }

    static abstract class AbstractIndexLike<T>
    implements Meta.IndexLikeObject {
        private final String name;
        private final Collection<String> parentAliasNames;
        private final String parentDataStreamName;
        private final boolean hidden;
        private DefaultMetaImpl root;
        private ImmutableSet<Meta.IndexOrNonExistent> cachedResolveDeep;
        private ImmutableSet<Meta.IndexOrNonExistent> cachedResolveDeepWrite;
        private ImmutableSet<String> cachedResolveDeepToNames;
        private ImmutableSet<String> cachedResolveDeepToNamesWrite;
        private ImmutableSet<Meta.Alias> cachedParentAliases;

        public AbstractIndexLike(DefaultMetaImpl root, String name, Collection<String> parentAliasNames, String parentDataStreamName, boolean hidden) {
            this.name = Objects.requireNonNull(name);
            this.parentAliasNames = parentAliasNames != null ? parentAliasNames : ImmutableSet.empty();
            this.parentDataStreamName = parentDataStreamName;
            this.hidden = hidden;
            this.root = root;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public Collection<String> parentAliasNames() {
            return this.parentAliasNames;
        }

        @Override
        public String parentDataStreamName() {
            return this.parentDataStreamName;
        }

        @Override
        public Meta.DataStream parentDataStream() {
            if (this.parentDataStreamName != null) {
                return (Meta.DataStream)this.root.getIndexOrLike(this.parentDataStreamName);
            }
            return null;
        }

        @Override
        public ImmutableSet<Meta.Alias> parentAliases() {
            if (this.parentAliasNames != null && !this.parentAliasNames.isEmpty()) {
                ImmutableSet result = this.cachedParentAliases;
                if (result == null) {
                    this.cachedParentAliases = result = ImmutableSet.map(this.parentAliasNames, n -> (Meta.Alias)this.root.getIndexOrLike((String)n));
                }
                return result;
            }
            return ImmutableSet.empty();
        }

        @Override
        public ImmutableSet<Meta.IndexOrNonExistent> resolveDeep(Meta.Alias.ResolutionMode resolutionMode) {
            ImmutableSet<Meta.IndexOrNonExistent> result;
            ImmutableSet<Meta.IndexOrNonExistent> immutableSet = result = resolutionMode == Meta.Alias.ResolutionMode.NORMAL ? this.cachedResolveDeep : this.cachedResolveDeepWrite;
            if (result == null) {
                result = this.resolveDeepImpl(resolutionMode);
                if (resolutionMode == Meta.Alias.ResolutionMode.NORMAL) {
                    this.cachedResolveDeep = result;
                } else {
                    this.cachedResolveDeepWrite = result;
                }
            }
            return result;
        }

        @Override
        public ImmutableSet<String> resolveDeepToNames(Meta.Alias.ResolutionMode resolutionMode) {
            ImmutableSet<String> result;
            ImmutableSet<String> immutableSet = result = resolutionMode == Meta.Alias.ResolutionMode.NORMAL ? this.cachedResolveDeepToNames : this.cachedResolveDeepToNamesWrite;
            if (result == null) {
                result = this.resolveDeepToNamesImpl(resolutionMode);
                if (resolutionMode == Meta.Alias.ResolutionMode.NORMAL) {
                    this.cachedResolveDeepToNames = result;
                } else {
                    this.cachedResolveDeepToNamesWrite = result;
                }
            }
            return result;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public abstract boolean equals(Object var1);

        public String toString() {
            return this.name;
        }

        protected abstract AbstractIndexLike<T> withAlias(String var1);

        protected abstract ImmutableSet<Meta.IndexOrNonExistent> resolveDeepImpl(Meta.Alias.ResolutionMode var1);

        protected abstract ImmutableSet<String> resolveDeepToNamesImpl(Meta.Alias.ResolutionMode var1);

        protected abstract T copy();

        public Meta getRoot() {
            return this.root;
        }

        protected void root(DefaultMetaImpl root) {
            if (this.root != null && !this.root.equals(root)) {
                throw new IllegalStateException("Cannot set root twice");
            }
            this.root = root;
        }

        @Override
        public boolean exists() {
            return true;
        }
    }

    public static class DataStreamImpl
    extends AbstractIndexCollection<DataStreamImpl>
    implements Meta.DataStream {
        public DataStreamImpl(DefaultMetaImpl root, String name, Collection<String> parentAliasNames, UnmodifiableCollection<Meta.IndexLikeObject> members, boolean hidden) {
            super(root, name, parentAliasNames, null, members, hidden);
        }

        @Override
        protected AbstractIndexLike<DataStreamImpl> withAlias(String alias) {
            return new DataStreamImpl(null, this.name(), (Collection<String>)ImmutableSet.of((Collection)this.parentAliasNames()).with((Object)alias), (UnmodifiableCollection<Meta.IndexLikeObject>)this.members(), this.isHidden());
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Meta.DataStream) {
                return ((Meta.DataStream)other).name().equals(this.name());
            }
            return false;
        }

        @Override
        protected DataStreamImpl copy() {
            return new DataStreamImpl(null, this.name(), (Collection<String>)this.parentAliasNames(), (UnmodifiableCollection<Meta.IndexLikeObject>)this.members(), this.isHidden());
        }

        @Override
        public Collection<String> ancestorAliasNames() {
            return this.parentAliasNames();
        }

        public Object toBasicObject() {
            return DocNode.of((String)"name", (Object)this.name(), (String)"members", (Object)this.members(), (String)"hidden", (Object)this.isHidden());
        }
    }

    public static class AliasImpl
    extends AbstractIndexCollection<AliasImpl>
    implements Meta.Alias {
        private final Meta.IndexLikeObject writeTarget;
        private final ImmutableSet<Meta.IndexLikeObject> writeTargetAsSet;

        public AliasImpl(DefaultMetaImpl root, String name, UnmodifiableCollection<Meta.IndexLikeObject> members, boolean hidden, Meta.IndexLikeObject writeTarget) {
            super(root, name, (Collection<String>)ImmutableSet.empty(), null, members, hidden);
            this.writeTarget = writeTarget;
            this.writeTargetAsSet = writeTarget != null ? ImmutableSet.of((Object)writeTarget) : ImmutableSet.empty();
        }

        @Override
        protected AbstractIndexLike<AliasImpl> withAlias(String alias) {
            throw new RuntimeException("Aliases cannot point to aliases");
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Meta.Alias) {
                return ((Meta.Alias)other).name().equals(this.name());
            }
            return false;
        }

        @Override
        protected AliasImpl copy() {
            return new AliasImpl(null, this.name(), (UnmodifiableCollection<Meta.IndexLikeObject>)this.members(), this.isHidden(), this.writeTarget);
        }

        @Override
        public Collection<String> parentAliasNames() {
            return ImmutableSet.empty();
        }

        @Override
        public Collection<String> ancestorAliasNames() {
            return ImmutableSet.empty();
        }

        public Object toBasicObject() {
            return DocNode.of((String)"name", (Object)this.name(), (String)"members", (Object)this.members(), (String)"hidden", (Object)this.isHidden());
        }

        @Override
        public Meta.IndexLikeObject writeTarget() {
            return this.writeTarget;
        }

        @Override
        public UnmodifiableCollection<Meta.IndexLikeObject> resolve(Meta.Alias.ResolutionMode resolutionMode) {
            if (resolutionMode == Meta.Alias.ResolutionMode.TO_WRITE_TARGET) {
                return this.writeTargetAsSet;
            }
            return this.members();
        }

        @Override
        public ImmutableSet<Meta.Index> resolveDeepAsIndex(Meta.Alias.ResolutionMode resolutionMode) {
            if (resolutionMode == Meta.Alias.ResolutionMode.TO_WRITE_TARGET) {
                if (this.writeTarget == null) {
                    return ImmutableSet.empty();
                }
                if (this.writeTarget instanceof Meta.Index) {
                    ImmutableSet<Meta.IndexLikeObject> result = this.writeTargetAsSet;
                    return result;
                }
                if (this.writeTarget instanceof Meta.DataStream) {
                    return ((Meta.DataStream)this.writeTarget).resolveDeepAsIndex(resolutionMode);
                }
                return super.resolveDeepAsIndex(resolutionMode);
            }
            return super.resolveDeepAsIndex(resolutionMode);
        }

        @Override
        protected ImmutableSet<String> resolveDeepToNamesImpl(Meta.Alias.ResolutionMode resolutionMode) {
            if (resolutionMode == Meta.Alias.ResolutionMode.TO_WRITE_TARGET) {
                if (this.writeTarget == null) {
                    return ImmutableSet.empty();
                }
                if (this.writeTarget instanceof Meta.Index) {
                    return ImmutableSet.of((Object)this.writeTarget.name());
                }
                if (this.writeTarget instanceof Meta.DataStream) {
                    return this.writeTarget.resolveDeepToNames(resolutionMode);
                }
                return super.resolveDeepToNamesImpl(resolutionMode);
            }
            return super.resolveDeepToNamesImpl(resolutionMode);
        }
    }

    public static class IndexImpl
    extends AbstractIndexLike<IndexImpl>
    implements Meta.Index {
        private final boolean open;
        private final boolean system;

        public IndexImpl(DefaultMetaImpl root, String name, Collection<String> parentAliasNames, String parentDataStreamName, boolean hidden, boolean system, IndexMetadata.State state) {
            super(root, name, parentAliasNames, parentDataStreamName, hidden);
            this.open = state == IndexMetadata.State.OPEN;
            this.system = system;
        }

        IndexImpl(DefaultMetaImpl root, String name, Collection<String> parentAliasNames, String parentDataStreamName) {
            this(root, name, parentAliasNames, parentDataStreamName, false, false, IndexMetadata.State.OPEN);
        }

        @Override
        protected ImmutableSet<Meta.IndexOrNonExistent> resolveDeepImpl(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.of((Object)this);
        }

        @Override
        protected ImmutableSet<String> resolveDeepToNamesImpl(Meta.Alias.ResolutionMode resolutionMode) {
            return ImmutableSet.of((Object)this.name());
        }

        @Override
        protected AbstractIndexLike<IndexImpl> withAlias(String alias) {
            return new IndexImpl(null, this.name(), (Collection<String>)ImmutableSet.of((Collection)this.parentAliasNames()).with((Object)alias), this.parentDataStreamName(), this.isHidden(), this.system, this.open ? IndexMetadata.State.OPEN : IndexMetadata.State.CLOSE);
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public boolean isSystem() {
            return this.system;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Meta.Index) {
                return ((Meta.Index)other).name().equals(this.name());
            }
            return false;
        }

        @Override
        protected IndexImpl copy() {
            return new IndexImpl(null, this.name(), this.parentAliasNames(), this.parentDataStreamName(), this.isHidden(), this.system, this.open ? IndexMetadata.State.OPEN : IndexMetadata.State.CLOSE);
        }

        @Override
        public Collection<String> ancestorAliasNames() {
            if (this.parentDataStreamName() == null) {
                return this.parentAliasNames();
            }
            Collection<String> dataStreamParentAliases = this.parentDataStream().parentAliasNames();
            if (this.parentAliasNames().isEmpty()) {
                return dataStreamParentAliases;
            }
            return ImmutableList.concat(dataStreamParentAliases, (Collection)this.parentAliasNames());
        }

        public Object toBasicObject() {
            return DocNode.of((String)"name", (Object)this.name(), (String)"open", (Object)this.open, (String)"system", (Object)this.isSystem(), (String)"hidden", (Object)this.isHidden());
        }

        @Override
        public boolean isDataStreamBackingIndex() {
            return this.parentDataStreamName() != null;
        }
    }
}

