/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.xcontent;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.searchsupport.xcontent.TestChunkedToXContentObjectImpl;
import com.floragunn.searchsupport.xcontent.TestToXContentObjectImpl;
import com.floragunn.searchsupport.xcontent.XContentConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class XContentConverterTest {
    private static final Logger log = LogManager.getLogger(XContentConverterTest.class);
    public static final String VALUE_ONE = "one";
    public static final String VALUE_TWO = "two";

    @Test
    public void shouldSupportsNulls() {
        MatcherAssert.assertThat((Object)XContentConverter.canConvert(null), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)XContentConverter.convertOrNull(null), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldCastChunkedToXContentToToXContent() throws DocumentParseException {
        TestChunkedToXContentObjectImpl testChunkedToXContentObjectImpl = new TestChunkedToXContentObjectImpl(VALUE_ONE, VALUE_TWO);
        ToXContent toXContent = XContentConverter.convertOrNull((Object)testChunkedToXContentObjectImpl);
        MatcherAssert.assertThat((Object)XContentConverter.canConvert((Object)testChunkedToXContentObjectImpl), (Matcher)Matchers.equalTo((Object)true));
        String serialized = Strings.toString((ToXContent)toXContent, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
        log.warn("Serialized object '{}'", (Object)serialized);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(serialized);
        MatcherAssert.assertThat((Object)docNode, DocNodeMatchers.containsValue("$.first", VALUE_ONE));
        MatcherAssert.assertThat((Object)docNode, DocNodeMatchers.containsValue("$.second", VALUE_TWO));
    }

    @Test
    public void shouldCastToXContent() throws DocumentParseException {
        TestToXContentObjectImpl testToXContentObjectImpl = new TestToXContentObjectImpl(VALUE_ONE);
        ToXContent toXContent = XContentConverter.convertOrNull((Object)testToXContentObjectImpl);
        MatcherAssert.assertThat((Object)XContentConverter.canConvert((Object)testToXContentObjectImpl), (Matcher)Matchers.equalTo((Object)true));
        String serialized = Strings.toString((ToXContent)toXContent, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
        log.warn("Serialized object '{}'", (Object)serialized);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(serialized);
        MatcherAssert.assertThat((Object)docNode, DocNodeMatchers.containsValue("$.msg", VALUE_ONE));
    }

    @Test
    public void shouldNotCastToXContent() {
        String object = "I am not ToXContent neither ChunkedToXContent";
        MatcherAssert.assertThat((Object)XContentConverter.convertOrNull((Object)object), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)XContentConverter.canConvert((Object)object), (Matcher)Matchers.equalTo((Object)false));
    }
}

