/*
 * Copyright 2021-2022 floragunn GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.codova.documents.DocNode;

public class UnknownMeasurement extends Measurement<UnknownMeasurement> {

    private final String type;
    private final DocNode docNode;

    UnknownMeasurement(String type, DocNode docNode) {
        this.type = type;
        this.docNode = docNode;
    }

    @Override
    public UnknownMeasurement clone() {
        // This class is immutable
        return this;
    }

    @Override
    public void addToThis(UnknownMeasurement other) {
    }

    @Override
    public void addToThis(Measurement<?> other) {
    }

    @Override
    public Object toBasicObject() {
        return docNode;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public void reset() {

    }

}
