/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit;

import com.google.common.base.Strings;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class LoggingTestWatcher
extends TestWatcher {
    private static final int LINE_WIDTH = 100;
    private static final String DIV = "\n" + Strings.repeat((String)"-", (int)100) + "\n";

    protected void succeeded(Description description) {
        System.out.println(DIV + "\u001b[0;30m\u001b[42m" + Strings.padEnd((String)("SUCCESS: " + String.valueOf(description)), (int)100, (char)' ') + "\u001b[0m" + DIV);
    }

    protected void failed(Throwable e, Description description) {
        System.out.println(DIV + "\u001b[0;30m\u001b[41m" + Strings.padEnd((String)("FAILED: " + String.valueOf(description)), (int)100, (char)' ') + "\u001b[0m" + DIV);
        e.printStackTrace(System.out);
        System.out.println(DIV);
    }

    protected void starting(Description description) {
        System.out.println(DIV + "Starting: " + String.valueOf(description) + DIV);
    }

    protected void finished(Description description) {
    }
}

