/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class StringContainsOnceMatcher
extends TypeSafeDiagnosingMatcher<String> {
    private final String substring;

    public StringContainsOnceMatcher(String substring) {
        this.substring = Objects.requireNonNull(substring, "Substring is required");
    }

    protected boolean matchesSafely(String item, Description mismatchDescription) {
        String[] split = item.split("\\Q" + this.substring + "\\E");
        if (split.length != 1) {
            mismatchDescription.appendText(" found incorrect number of substring occurrences.");
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(" should contains one occurrence of substring ").appendValue((Object)this.substring);
    }
}

