/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class DocNodeSizeEqualToMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private static final Logger log = LogManager.getLogger(DocNodeSizeEqualToMatcher.class);
    private final String jsonPath;
    private final int expectedSize;

    public DocNodeSizeEqualToMatcher(String jsonPath, int expectedSize) {
        this.jsonPath = Objects.requireNonNull(jsonPath);
        this.expectedSize = expectedSize;
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        try {
            ImmutableList nodes = docNode.findNodesByJsonPath(this.jsonPath);
            int numberOfNodes = nodes.size();
            if (numberOfNodes != 1) {
                mismatchDescription.appendText("Found ").appendValue((Object)numberOfNodes).appendText(" nodes pointed by json path ").appendValue((Object)this.jsonPath).appendText(" whereas expected number of nodes is 1.");
                return false;
            }
            DocNode selectedDocNode = (DocNode)nodes.get(0);
            int currentSize = selectedDocNode.size();
            if (currentSize != this.expectedSize) {
                String keys = selectedDocNode.keySet().stream().collect(Collectors.joining(", "));
                mismatchDescription.appendText("node size is ").appendValue((Object)currentSize).appendText(", keys present in node ").appendValue((Object)keys);
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            log.debug("Patch {} not found in DocNode {}.", (Object)this.jsonPath, (Object)docNode, (Object)e);
            mismatchDescription.appendText(" path ").appendValue((Object)this.jsonPath).appendText(" does not exists in doc node ").appendValue((Object)docNode.toJsonString());
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("Node pointed by path ").appendValue((Object)this.jsonPath).appendText(" should have size equal to ").appendValue((Object)this.expectedSize);
    }
}

