/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.xcontent;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import com.floragunn.searchsupport.xcontent.TestChunkedToXContentObjectImpl;
import com.floragunn.searchsupport.xcontent.TestToXContentObjectImpl;
import com.floragunn.searchsupport.xcontent.XContentObjectConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class XContentObjectConverterTest {
    private static final Logger log = LogManager.getLogger(XContentObjectConverterTest.class);
    public static final String VALUE_ONE = "one";
    public static final String VALUE_TWO = "two";

    @Test
    public void shouldSupportsNulls() {
        MatcherAssert.assertThat((Object)XContentObjectConverter.canConvert(null), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)XContentObjectConverter.convertOrNull(null), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldCastChunkedToXContentObjectToToXContentObject() throws DocumentParseException {
        TestChunkedToXContentObjectImpl testChunkedToXContentObjectImpl = new TestChunkedToXContentObjectImpl(VALUE_ONE, VALUE_TWO);
        ToXContentObject toXContentObject = XContentObjectConverter.convertOrNull((Object)testChunkedToXContentObjectImpl);
        MatcherAssert.assertThat((Object)XContentObjectConverter.canConvert((Object)testChunkedToXContentObjectImpl), (Matcher)Matchers.equalTo((Object)true));
        String serialized = Strings.toString((ToXContent)toXContentObject, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
        log.warn("Serialized object '{}'", (Object)serialized);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(serialized);
        MatcherAssert.assertThat((Object)docNode, DocNodeMatchers.containsValue("$.first", VALUE_ONE));
        MatcherAssert.assertThat((Object)docNode, DocNodeMatchers.containsValue("$.second", VALUE_TWO));
    }

    @Test
    public void shouldCastToXContentObject() throws DocumentParseException {
        TestToXContentObjectImpl testToXContentObjectImpl = new TestToXContentObjectImpl(VALUE_ONE);
        ToXContentObject toXContentObject = XContentObjectConverter.convertOrNull((Object)testToXContentObjectImpl);
        MatcherAssert.assertThat((Object)XContentObjectConverter.canConvert((Object)testToXContentObjectImpl), (Matcher)Matchers.equalTo((Object)true));
        String serialized = Strings.toString((ToXContent)toXContentObject, (ToXContent.Params)ToXContent.EMPTY_PARAMS);
        log.warn("Serialized object '{}'", (Object)serialized);
        DocNode docNode = DocNode.parse((Format)Format.JSON).from(serialized);
        MatcherAssert.assertThat((Object)docNode, DocNodeMatchers.containsValue("$.msg", VALUE_ONE));
    }

    @Test
    public void shouldNotCastToXContentObject() {
        String object = "I am not ToXContentObject neither ChunkedToXContentObject";
        MatcherAssert.assertThat((Object)XContentObjectConverter.convertOrNull((Object)object), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)XContentObjectConverter.canConvert((Object)object), (Matcher)Matchers.equalTo((Object)false));
    }
}

