/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.junit.matcher;

import com.floragunn.codova.documents.DocNode;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

class ContainsFieldValuePointedByJsonPathMatcher
extends TypeSafeDiagnosingMatcher<DocNode> {
    private static final Logger log = LogManager.getLogger(ContainsFieldValuePointedByJsonPathMatcher.class);
    private final String jsonPath;
    private final Object fieldValue;

    public ContainsFieldValuePointedByJsonPathMatcher(String jsonPath, Object fieldValue) {
        this.jsonPath = Objects.requireNonNull(jsonPath);
        this.fieldValue = Objects.requireNonNull(fieldValue);
    }

    public void describeTo(Description description) {
        description.appendText("DocNode should contain field ").appendValue((Object)this.jsonPath).appendText(" with value ").appendValue(this.fieldValue);
    }

    protected boolean matchesSafely(DocNode docNode, Description mismatchDescription) {
        if (log.isDebugEnabled()) {
            log.debug("Checking id DocNode {} contain field {} with value {}", (Object)docNode.toPrettyJsonString(), (Object)this.jsonPath, this.fieldValue);
        }
        try {
            Object nodeValue = docNode.findSingleValueByJsonPath(this.jsonPath, this.fieldValue.getClass());
            if (!this.fieldValue.equals(nodeValue)) {
                mismatchDescription.appendText("Node pointed by json path ").appendValue((Object)this.jsonPath).appendText(" does not contain value ").appendValue(this.fieldValue).appendText(" actual value ").appendValue(nodeValue);
                return false;
            }
            return true;
        }
        catch (PathNotFoundException e) {
            log.debug("Patch {} not found in DocNode {}.", (Object)this.jsonPath, (Object)docNode, (Object)e);
            mismatchDescription.appendText(" path ").appendValue((Object)this.jsonPath).appendText(" does not exists in doc node ").appendValue((Object)docNode.toJsonString());
            return false;
        }
    }
}

