/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.proxy.wiremock;

import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestWrapper;
import com.github.tomakehurst.wiremock.extension.requestfilter.StubRequestFilterV2;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class WireMockRequestHeaderAddingFilter
implements StubRequestFilterV2 {
    private final String headerName;
    private final String headerValue;

    public WireMockRequestHeaderAddingFilter(String headerName, String headerValue) {
        this.headerName = Objects.requireNonNull(headerName, "header name is required");
        this.headerValue = Objects.requireNonNull(headerValue, "header value is required");
    }

    public RequestFilterAction filter(Request request, ServeEvent serveEvent) {
        Request modifiedRequest = RequestWrapper.create().addHeader(this.headerName, new String[]{this.headerValue}).wrap(request);
        return RequestFilterAction.continueWith((Request)modifiedRequest);
    }

    public String getName() {
        return String.format("Add '%s' header to request", this.headerName);
    }

    public Header getHeader() {
        return new BasicHeader(this.headerName, this.headerValue);
    }
}

