/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.cstate.metrics;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchsupport.cstate.metrics.CountAggregation;
import com.floragunn.searchsupport.cstate.metrics.Measurement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TimeAggregation
extends Measurement<TimeAggregation> {
    public abstract void recordMs(long var1);

    public abstract void recordNs(long var1);

    public abstract long getCount();

    public abstract long getAggMs();

    public abstract int getMinMs();

    public abstract int getMaxMs();

    public abstract long getAggNs();

    public abstract long getMinNs();

    public abstract long getMaxNs();

    public abstract TimeAggregation getSubAggregation(String var1);

    public abstract CountAggregation getCountAggregation(String var1);

    public abstract Map<String, ? extends Measurement<?>> getSubMeasurements();

    public static class Nanoseconds
    extends TimeAggregation {
        static final String TYPE = "agg";
        private static final OrderedImmutableMap<String, Object> ZERO_COUNT = OrderedImmutableMap.of((Object)"count", (Object)0);
        private AtomicLong aggNs = new AtomicLong();
        private AtomicLong minNs = new AtomicLong(-1L);
        private AtomicLong maxNs = new AtomicLong();
        private AtomicLong count = new AtomicLong();
        private Map<String, Measurement<?>> subMeasurements;

        public Nanoseconds() {
            this.subMeasurements = new ConcurrentHashMap();
        }

        Nanoseconds(long aggNs, long count) {
            this.aggNs.set(aggNs);
            this.count.set(count);
        }

        Nanoseconds(DocNode docNode) throws ConfigValidationException {
            this.aggNs.set(docNode.hasNonNull("agg_ns") ? docNode.getNumber("agg_ns").longValue() : 0L);
            this.count.set(docNode.hasNonNull("count") ? docNode.getNumber("count").longValue() : 0L);
            this.maxNs.set(docNode.hasNonNull("max_ns") ? docNode.getNumber("max_ns").longValue() : 0L);
            this.minNs.set(docNode.hasNonNull("min_ns") ? docNode.getNumber("min_ns").longValue() : 0L);
            if (docNode.hasNonNull("parts")) {
                DocNode sub = docNode.getAsNode("parts");
                this.subMeasurements = new HashMap(sub.size());
                for (String key : sub.keySet()) {
                    this.subMeasurements.put(key, new Nanoseconds(sub.getAsNode(key)));
                }
            } else {
                this.subMeasurements = new HashMap();
            }
        }

        @Override
        public long getCount() {
            return this.count.get();
        }

        public void setCount(long count) {
            this.count.set(count);
        }

        @Override
        public long getAggNs() {
            return this.aggNs.get();
        }

        public void setAggNs(long aggNs) {
            this.aggNs.set(aggNs);
        }

        @Override
        public long getMinNs() {
            return this.minNs.get();
        }

        public void setMinNs(int minNs) {
            this.minNs.set(minNs);
        }

        @Override
        public long getMaxNs() {
            return this.maxNs.get();
        }

        public void setMaxNs(int maxNs) {
            this.maxNs.set(maxNs);
        }

        @Override
        public Nanoseconds clone() {
            Nanoseconds result = new Nanoseconds();
            result.aggNs = this.aggNs;
            result.minNs = this.minNs;
            result.maxNs = this.maxNs;
            result.count = this.count;
            return result;
        }

        @Override
        public void addToThis(TimeAggregation other) {
            this.aggNs.addAndGet(other.getAggNs());
            this.count.addAndGet(other.getCount());
            long minNs = this.minNs.get();
            if (minNs == -1L || minNs > other.getMinNs()) {
                this.minNs.set(minNs);
            }
            this.maxNs.set(Math.max(this.maxNs.get(), other.getMaxNs()));
            Map<String, Measurement<?>> otherMap = other.getSubMeasurements();
            if (otherMap != null && otherMap.size() != 0) {
                for (Map.Entry<String, Measurement<?>> otherEntry : otherMap.entrySet()) {
                    String key = otherEntry.getKey();
                    Measurement<?> here = this.subMeasurements.get(key);
                    if (here != null) {
                        here.addToThis(otherEntry.getValue());
                        continue;
                    }
                    this.subMeasurements.put(key, otherEntry.getValue());
                }
            }
        }

        @Override
        public void addToThis(Measurement<?> other) {
            if (other instanceof TimeAggregation) {
                this.addToThis((Milliseconds)other);
            }
        }

        @Override
        public void recordNs(long ns) {
            long max;
            this.count.incrementAndGet();
            this.aggNs.addAndGet(ns);
            long min = this.minNs.get();
            if (min == -1L || ns < min) {
                this.minNs.set(ns);
            }
            if (ns > (max = this.maxNs.get())) {
                this.maxNs.set(ns);
            }
        }

        @Override
        public void recordMs(long ms) {
            this.recordNs(ms * 1000000L);
        }

        @Override
        public TimeAggregation getSubAggregation(String name) {
            return (TimeAggregation)this.subMeasurements.computeIfAbsent(name, k -> new Nanoseconds());
        }

        @Override
        public CountAggregation getCountAggregation(String name) {
            return (CountAggregation)this.subMeasurements.computeIfAbsent(name, k -> new CountAggregation());
        }

        @Override
        public void reset() {
            this.count.set(0L);
            this.subMeasurements.forEach((k, v) -> v.reset());
        }

        public Object toBasicObject() {
            long count = this.count.get();
            long aggNs = this.aggNs.get();
            if (count == 0L) {
                return ZERO_COUNT;
            }
            OrderedImmutableMap result = OrderedImmutableMap.of((Object)"count", (Object)count, (Object)"avg_ns", (Object)((double)aggNs / (double)count), (Object)"agg_ns", (Object)aggNs, (Object)"min_ns", (Object)this.minNs.get(), (Object)"max_ns", (Object)this.maxNs.get());
            if (this.subMeasurements != null && this.subMeasurements.size() != 0) {
                result = result.with((Object)"parts", this.subMeasurements);
            }
            return result;
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public Map<String, ? extends Measurement<?>> getSubMeasurements() {
            return this.subMeasurements;
        }

        @Override
        public long getAggMs() {
            return this.getAggNs() / 1000000L;
        }

        @Override
        public int getMinMs() {
            return (int)(this.getMinNs() / 1000000L);
        }

        @Override
        public int getMaxMs() {
            return this.getMaxMs() / 1000000;
        }
    }

    public static class Milliseconds
    extends TimeAggregation {
        static final String TYPE = "agg";
        private static final OrderedImmutableMap<String, Object> ZERO_COUNT = OrderedImmutableMap.of((Object)"count", (Object)0);
        private AtomicLong aggMs = new AtomicLong();
        private AtomicInteger minMs = new AtomicInteger(-1);
        private AtomicInteger maxMs = new AtomicInteger();
        private AtomicLong count = new AtomicLong();
        private Map<String, Measurement<?>> subMeasurements;

        public Milliseconds() {
            this.subMeasurements = new ConcurrentHashMap();
        }

        Milliseconds(long aggMs, long count) {
            this.aggMs.set(aggMs);
            this.count.set(count);
        }

        Milliseconds(DocNode docNode) throws ConfigValidationException {
            this.aggMs.set(docNode.hasNonNull("agg_ms") ? docNode.getNumber("agg_ms").longValue() : 0L);
            this.count.set(docNode.hasNonNull("count") ? docNode.getNumber("count").longValue() : 0L);
            this.maxMs.set(docNode.hasNonNull("max_ms") ? docNode.getNumber("max_ms").intValue() : 0);
            this.minMs.set(docNode.hasNonNull("min_ms") ? docNode.getNumber("min_ms").intValue() : 0);
            if (docNode.hasNonNull("parts")) {
                DocNode sub = docNode.getAsNode("parts");
                this.subMeasurements = new HashMap(sub.size());
                for (String key : sub.keySet()) {
                    this.subMeasurements.put(key, new Milliseconds(sub.getAsNode(key)));
                }
            } else {
                this.subMeasurements = new HashMap();
            }
        }

        @Override
        public long getCount() {
            return this.count.get();
        }

        public void setCount(long count) {
            this.count.set(count);
        }

        @Override
        public long getAggMs() {
            return this.aggMs.get();
        }

        public void setAggMs(long aggMs) {
            this.aggMs.set(aggMs);
        }

        @Override
        public int getMinMs() {
            return this.minMs.get();
        }

        public void setMinMs(int minMs) {
            this.minMs.set(minMs);
        }

        @Override
        public int getMaxMs() {
            return this.maxMs.get();
        }

        public void setMaxMs(int maxMs) {
            this.maxMs.set(maxMs);
        }

        @Override
        public Milliseconds clone() {
            Milliseconds result = new Milliseconds();
            result.aggMs = this.aggMs;
            result.minMs = this.minMs;
            result.maxMs = this.maxMs;
            result.count = this.count;
            return result;
        }

        @Override
        public void addToThis(TimeAggregation other) {
            this.aggMs.addAndGet(other.getAggMs());
            this.count.addAndGet(other.getCount());
            int minMs = this.minMs.get();
            if (minMs == -1 || minMs > other.getMinMs()) {
                this.minMs.set(minMs);
            }
            this.maxMs.set(Math.max(this.maxMs.get(), other.getMaxMs()));
            Map<String, Measurement<?>> otherMap = other.getSubMeasurements();
            if (otherMap != null && otherMap.size() != 0) {
                for (Map.Entry<String, Measurement<?>> otherEntry : otherMap.entrySet()) {
                    String key = otherEntry.getKey();
                    Measurement<?> here = this.subMeasurements.get(key);
                    if (here != null) {
                        here.addToThis(otherEntry.getValue());
                        continue;
                    }
                    this.subMeasurements.put(key, otherEntry.getValue());
                }
            }
        }

        @Override
        public void addToThis(Measurement<?> other) {
            if (other instanceof TimeAggregation) {
                this.addToThis((Milliseconds)other);
            }
        }

        @Override
        public void recordMs(long ms) {
            int max;
            this.count.incrementAndGet();
            this.aggMs.addAndGet(ms);
            int min = this.minMs.get();
            if (min == -1 || ms < (long)min) {
                this.minMs.set((int)ms);
            }
            if (ms > (long)(max = this.maxMs.get())) {
                this.maxMs.set((int)ms);
            }
        }

        @Override
        public TimeAggregation getSubAggregation(String name) {
            return (TimeAggregation)this.subMeasurements.computeIfAbsent(name, k -> new Milliseconds());
        }

        @Override
        public CountAggregation getCountAggregation(String name) {
            return (CountAggregation)this.subMeasurements.computeIfAbsent(name, k -> new CountAggregation());
        }

        @Override
        public void reset() {
            this.count.set(0L);
            this.subMeasurements.forEach((k, v) -> v.reset());
        }

        public Object toBasicObject() {
            long count = this.count.get();
            long aggMs = this.aggMs.get();
            if (count == 0L) {
                return ZERO_COUNT;
            }
            OrderedImmutableMap result = OrderedImmutableMap.of((Object)"count", (Object)count, (Object)"avg_ms", (Object)((double)aggMs / (double)count), (Object)"agg_ms", (Object)aggMs, (Object)"min_ms", (Object)this.minMs.get(), (Object)"max_ms", (Object)this.maxMs.get());
            if (this.subMeasurements != null && this.subMeasurements.size() != 0) {
                result = result.with((Object)"parts", this.subMeasurements);
            }
            return result;
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public Map<String, ? extends Measurement<?>> getSubMeasurements() {
            return this.subMeasurements;
        }

        @Override
        public void recordNs(long ns) {
            this.recordMs(ns / 1000000L);
        }

        @Override
        public long getAggNs() {
            return this.getAggMs() * 1000000L;
        }

        @Override
        public long getMinNs() {
            return this.getMinMs() * 1000000;
        }

        @Override
        public long getMaxNs() {
            return this.getMaxMs() * 1000000;
        }
    }
}

