/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.DocNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

class DocNodeFlattener {
    private final DocNode rootDocNode;
    private final Map<String, Object> flattenedMap = new LinkedHashMap<String, Object>();

    DocNodeFlattener(DocNode docNode) {
        this.rootDocNode = docNode;
    }

    DocNode flatten() {
        for (Map.Entry entry : this.rootDocNode.entrySet()) {
            this.flattenValue((String)entry.getKey(), entry.getValue(), 0);
        }
        return DocNode.wrap(this.flattenedMap);
    }

    private void flatten(String flattenedTopPrefix, Map<?, ?> topValue, int depth) {
        if (depth > 200) {
            throw new RuntimeException("Object is too deply nested: " + flattenedTopPrefix);
        }
        for (Map.Entry<?, ?> entry : topValue.entrySet()) {
            String keyString = String.valueOf(entry.getKey());
            if (this.needsEscaping(keyString)) {
                this.flattenValue(flattenedTopPrefix.substring(0, flattenedTopPrefix.length() - 1) + "[\"" + keyString + "\"]", entry.getValue(), depth);
                continue;
            }
            this.flattenValue(flattenedTopPrefix + keyString, entry.getValue(), depth);
        }
    }

    private void flatten(String flattenedTopPrefix, Collection<?> topValue, int depth) {
        if (depth > 200) {
            throw new RuntimeException("Object is too deply nested: " + flattenedTopPrefix);
        }
        int i = 0;
        for (Object entryValue : topValue) {
            this.flattenValue(flattenedTopPrefix + '[' + i + ']', entryValue, depth);
            ++i;
        }
    }

    private void flattenValue(String flattenedKey, Object entryValue, int depth) {
        if (entryValue instanceof DocNode) {
            DocNode docNode = (DocNode)entryValue;
            if (docNode.isMap()) {
                this.flatten(flattenedKey + '.', docNode, depth + 1);
            } else if (docNode.isList()) {
                this.flatten(flattenedKey, docNode.toList(), depth + 1);
            } else {
                this.flattenedMap.put(flattenedKey, entryValue);
            }
        } else if (entryValue instanceof Map) {
            this.flatten(flattenedKey + '.', (Map)entryValue, depth + 1);
        } else if (entryValue instanceof Collection) {
            this.flatten(flattenedKey, (Collection)entryValue, depth + 1);
        } else {
            this.flattenedMap.put(flattenedKey, entryValue);
        }
    }

    private boolean needsEscaping(String key) {
        return key.indexOf(46) != -1 || key.indexOf(91) != -1;
    }
}

