/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.codova.validation.errors.JsonValidationError;
import com.floragunn.searchguard.sgctl.SgctlException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SgctlConfig {

    public static class Cluster
    implements Document<Cluster> {
        private String clusterId;
        private String server;
        private int port;
        private TLSConfig tlsConfig;

        public Cluster(String server, int port, TLSConfig tlsConfig) {
            this.server = server;
            this.port = port;
            this.tlsConfig = tlsConfig;
        }

        private Cluster() {
        }

        public static Cluster read(File configDir, String clusterId) throws SgctlException {
            File configFile = new File(configDir, "cluster_" + clusterId + ".yml");
            try {
                Map<String, Object> config;
                if (!configFile.exists()) {
                    return null;
                }
                try {
                    config = DocReader.yaml().readObject(configFile);
                }
                catch (JsonProcessingException e) {
                    throw new ConfigValidationException(new JsonValidationError(null, e));
                }
                catch (IOException e) {
                    throw new SgctlException("Error while reading " + configFile + ": " + e, e);
                }
                return Cluster.parse(config, clusterId);
            }
            catch (ConfigValidationException e) {
                throw new SgctlException("File " + configFile + " is invalid:\n" + e.getValidationErrors(), e).debugDetail(e.toDebugString());
            }
        }

        public void write(File configDir) throws SgctlException {
            if (!configDir.exists() && !configDir.mkdir()) {
                throw new SgctlException("Could not create directory " + configDir + ")");
            }
            File configFile = new File(configDir, "cluster_" + this.clusterId + ".yml");
            try {
                DocWriter.yaml().write(configFile, this.toBasicObject());
            }
            catch (IOException e) {
                throw new SgctlException("Error while writing " + configFile + ": " + e, e);
            }
        }

        public static Cluster parse(Map<String, Object> config, String clusterId) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors).expandVariables("file", VariableResolvers.FILE);
            Cluster result = new Cluster();
            result.server = vNode.get("server").required().asString();
            result.port = vNode.get("port").withDefault(9300).asInt();
            result.tlsConfig = vNode.get("tls").required().by(TLSConfig::parse);
            result.clusterId = clusterId;
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        @Override
        public Map<String, Object> toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("server", this.server);
            result.put("port", this.port);
            result.put("tls", this.tlsConfig.toBasicObject());
            return result;
        }

        public String getServer() {
            return this.server;
        }

        public int getPort() {
            return this.port;
        }

        public TLSConfig getTlsConfig() {
            return this.tlsConfig;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }
    }
}

