/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.client.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GetUserResponse {
    private String eTag;
    private final String description;
    private final List<String> searchGuardRoles;
    private final List<String> backendRoles;
    private final Map<String, Object> attributes;
    private final DocNode docNode;

    public GetUserResponse(DocNode docNode) throws InvalidResponseException {
        this.docNode = docNode;
        DocNode dataNode = docNode.getAsNode("data");
        if (dataNode.isNull()) {
            throw new InvalidResponseException("data element is missing in response");
        }
        this.description = dataNode.getAsString("description");
        this.searchGuardRoles = dataNode.getAsListOfStrings("search_guard_roles");
        this.backendRoles = dataNode.getAsListOfStrings("backend_roles");
        this.attributes = dataNode.hasNonNull("attributes") ? dataNode.getAsNode("attributes").toNormalizedMap() : Collections.emptyMap();
    }

    public GetUserResponse(SearchGuardRestClient.Response response) throws InvalidResponseException {
        this(response.asDocNode());
        this.eTag = response.getETag();
    }

    public String getETag() {
        return this.eTag;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSearchGuardRoles() {
        return this.searchGuardRoles;
    }

    public List<String> getBackendRoles() {
        return this.backendRoles;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public DocNode getDocNode() {
        return this.docNode;
    }
}

