/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.searchguard.sgctl.SgctlConfig;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.client.api.AuthInfoResponse;
import com.floragunn.searchguard.sgctl.commands.BaseCommand;
import java.io.File;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpHost;
import picocli.CommandLine;

public abstract class ConnectingCommand
extends BaseCommand {
    @CommandLine.Option(names={"-h", "--host"}, description={"Hostname of the node to connect to"})
    String host;
    @CommandLine.Option(names={"-E", "--cert"}, description={"Client certificate for admin authentication"})
    File clientCert;
    @CommandLine.Option(names={"-p", "--port"}, description={"REST port to connect to. Default: 9200"})
    Integer serverPort;
    @CommandLine.Option(names={"--key"}, description={"Private key for admin authentication"})
    File clientKey;
    @CommandLine.Option(names={"--key-pass"}, description={"Password for private key"}, arity="0..1", interactive=true)
    String clientKeyPass;
    @CommandLine.Option(names={"--ca-cert"}, description={"Trusted certificates"})
    File caCert;
    @CommandLine.Option(names={"-k", "--insecure"}, arity="0..1", description={"Do not verify the hostname when connecting to the cluster"})
    Boolean insecure;
    @CommandLine.Option(names={"--ciphers"}, description={"The ciphers to be allowed for the TLS connection to the cluster"}, arity="0..*")
    List<String> ciphers;
    @CommandLine.Option(names={"--tls"}, description={"The TLS version to use when connecting to the cluster"})
    String tls;
    @CommandLine.Option(names={"--skip-connection-check"}, description={"Skips initial REST API call to check the connection"})
    boolean skipInitialConnectionCheck;
    private String connectedClusterName;

    public SearchGuardRestClient getClient() throws SgctlException {
        try {
            SgctlConfig.Cluster clusterConfig = this.getSelectedClusterConfig();
            TLSConfig tlsConfig = this.getTlsConfig(clusterConfig);
            String server = this.getHost();
            Integer serverPort = this.serverPort;
            if (clusterConfig != null && server == null) {
                server = clusterConfig.getServer();
            }
            if (clusterConfig != null && serverPort == null) {
                serverPort = clusterConfig.getPort();
            }
            if (server == null) {
                throw new SgctlException("You must specify the server on the command line");
            }
            if (serverPort == null) {
                serverPort = 9200;
            }
            if (this.verbose) {
                System.out.println("Connecting to " + server + ":" + serverPort + " with certificate " + this.getCertificateInfo(tlsConfig.getClientCertAuthConfig().getCertificateChain()));
            }
            try {
                SearchGuardRestClient client = new SearchGuardRestClient(new HttpHost(server, (int)serverPort, "https"), tlsConfig);
                client.debug(this.debug);
                if (!this.skipInitialConnectionCheck) {
                    AuthInfoResponse authInfoResponse = client.authInfo();
                    System.out.println("Successfully connected to cluster " + authInfoResponse.getClusterName() + " (" + server + ") as user " + authInfoResponse.getUserName());
                    this.connectedClusterName = authInfoResponse.getClusterName();
                }
                return client;
            }
            catch (FailedConnectionException e) {
                throw new SgctlException(this.getHumanReadableErrorMessage(e), e);
            }
            catch (ApiException | InvalidResponseException e) {
                throw new SgctlException("Invalid response from server: " + e.getMessage(), e);
            }
            catch (ServiceUnavailableException e) {
                throw new SgctlException("Server is unavailable: " + e.getMessage(), e);
            }
            catch (UnauthorizedException e) {
                throw new SgctlException("Server rejected request as unauthorized. Please check the client certificate.", e);
            }
        }
        catch (ConfigValidationException e) {
            throw new SgctlException("Connection settings are invalid:\n" + e.getValidationErrors(), e).debugDetail(e.toDebugString());
        }
    }

    protected TLSConfig getTlsConfig(SgctlConfig.Cluster clusterConfig) throws ConfigValidationException {
        if (clusterConfig != null && this.clientCert == null && this.clientKey == null && this.clientKeyPass == null && this.caCert == null && this.insecure == null) {
            return clusterConfig.getTlsConfig();
        }
        if (clusterConfig == null) {
            if (this.clientCert == null) {
                this.validationErrors.add(new MissingAttribute("--cert"));
            }
            if (this.clientKey == null) {
                this.validationErrors.add(new MissingAttribute("--key"));
            }
            this.validationErrors.throwExceptionForPresentErrors();
            try {
                return new TLSConfig.Builder().clientCert(this.clientCert, this.clientKey, this.clientKeyPass).trust(this.caCert).verifyHostnames(this.insecure != null ? !this.insecure.booleanValue() : true).build();
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(null, e);
                this.validationErrors.throwExceptionForPresentErrors();
            }
        } else if (clusterConfig != null) {
            Object config = clusterConfig.getTlsConfig().toBasicObject();
            Object clientAuthConfig = clusterConfig.getTlsConfig().getClientCertAuthConfig() != null ? clusterConfig.getTlsConfig().getClientCertAuthConfig().toBasicObject() : new LinkedHashMap();
            HashMap<String, String> attributeMapping = new HashMap<String, String>();
            if (this.clientCert != null) {
                clientAuthConfig.put("certificate", "#{file:" + this.clientCert.getAbsolutePath() + "}");
                attributeMapping.put("certificate", "--cert");
            } else if (clientAuthConfig.get("certificate") == null) {
                attributeMapping.put("certificate", "--cert");
            }
            if (this.clientKey != null) {
                clientAuthConfig.put("private_key", "#{file:" + this.clientKey.getAbsolutePath() + "}");
                attributeMapping.put("private_key", "--key");
            } else if (clientAuthConfig.get("private_key") == null) {
                attributeMapping.put("private_key", "--key");
            }
            if (this.clientKeyPass != null) {
                clientAuthConfig.put("private_key_password", this.clientKeyPass);
            }
            if (this.caCert != null) {
                config.put("trusted_cas", "#{file:" + this.caCert.getAbsolutePath() + "}");
                attributeMapping.put("trusted_cas", "--ca-cert");
            } else if (clientAuthConfig.get("trusted_cas") == null) {
                attributeMapping.put("trusted_cas", "--ca-cert");
            }
            if (this.insecure != null) {
                config.put("verify_hostnames", this.insecure == false);
            }
            if (this.ciphers != null) {
                config.put("enabled_ciphers", this.ciphers);
            }
            config.put("client_auth", clientAuthConfig);
            try {
                return TLSConfig.parse((Map<String, Object>)config);
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(null, e);
                this.validationErrors.mapKeys(attributeMapping).throwExceptionForPresentErrors();
            }
        }
        return null;
    }

    private String getHumanReadableErrorMessage(FailedConnectionException e) {
        if (e.getCause() instanceof SSLHandshakeException) {
            if (e.getMessage().contains("unable to find valid certification path to requested target")) {
                return "Could not validate server certificate using current CA settings. Please verify that you are using the correct CA certificates. You can specify custom CA certificates using the --ca-cert option.";
            }
        } else if (e.getCause() instanceof SSLException && e.getCause().getCause() instanceof SocketException) {
            return "Connection failed: " + e.getCause().getCause().getMessage();
        }
        return e.getMessage();
    }

    private String getCertificateInfo(Collection<? extends Certificate> certificateChain) {
        StringBuilder result = new StringBuilder();
        for (Certificate certificate : certificateChain) {
            if (result.length() > 0) {
                result.append(" / ");
            }
            if (certificate instanceof X509Certificate) {
                X509Certificate x509c = (X509Certificate)certificate;
                result.append(x509c.getSubjectDN());
                continue;
            }
            if (certificate != null) {
                result.append(certificate.getClass().getName());
                continue;
            }
            result.append("null");
        }
        return result.toString();
    }

    protected String getHost() {
        return this.host;
    }

    protected String getConnectedClusterName() {
        return this.connectedClusterName;
    }
}

