/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.util.YamlRewriter;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="migrate-config", description={"Converts old-style sg_config.yml and kibana.yml into sg_authc.yml and sg_frontend_authc.yml"})
public class MigrateConfig
implements Callable<Integer> {
    @CommandLine.Parameters
    List<String> parameters;
    @CommandLine.Option(names={"-o", "--output-dir"}, description={"Directory where to write new configuration files"})
    File outputDir;
    @CommandLine.Option(names={"--target-platform"}, description={"Specifies the target platform. Possible values: es (Elasticsearch), os (Opensearch), es711 (Elasticsearch 7.11 or newer)"})
    String targetPlatform;
    private static final Map<String, Object> SG_META = ImmutableMap.of();

    @Override
    public Integer call() throws Exception {
        if (this.parameters == null) {
            System.err.println("You must specify the paths to the Search Guard configuration files sg_config.yml and optionally kibana.yml on the command line");
            return 1;
        }
        System.out.println("Welcome to the Search Guard config migration tool.\n\nThis tool converts legacy Search Guard configuration to configuration suitable for the next generation Search Guard release.\nThe tool also provides basic guidance for a seamless update process without outages.\n");
        File sgConfig = null;
        File kibanaConfig = null;
        for (String arg : this.parameters) {
            File file = new File(arg);
            if (file.getName().startsWith("sg_config") && file.getName().endsWith(".yml")) {
                sgConfig = file;
                continue;
            }
            if (!arg.endsWith("kibana.yml")) continue;
            kibanaConfig = file;
        }
        if (sgConfig == null) {
            System.out.flush();
            System.err.println("You must specify a path to a sg_config.yml on the command line");
            return 1;
        }
        if (!sgConfig.exists()) {
            System.out.flush();
            System.err.println("The file " + sgConfig + " does not exist");
            return 1;
        }
        if (kibanaConfig != null && !kibanaConfig.exists()) {
            System.out.flush();
            System.err.println("The file " + kibanaConfig + " does not exist");
            return 1;
        }
        boolean publicBaseUrlAvailable = false;
        String dashboardConfigFileName = "kibana.yml";
        if ("os".equalsIgnoreCase(this.targetPlatform) || "opensearch".equalsIgnoreCase(this.targetPlatform)) {
            dashboardConfigFileName = "opensearch_dashboard.yml";
        }
        if ("es711".equalsIgnoreCase(this.targetPlatform)) {
            publicBaseUrlAvailable = true;
        }
        try {
            ConfigMigrator configMigrator = new ConfigMigrator(sgConfig, kibanaConfig, publicBaseUrlAvailable, dashboardConfigFileName);
            BackendUpdateInstructions backendUpdateInstructions = configMigrator.createBackendUpdateInstructions();
            FrontendUpdateInstructions frontendUpdateInstructions = configMigrator.createUpdateInstructions();
            if (configMigrator.oldKibanaConfigValidationErrors.hasErrors() || configMigrator.oldSgConfigValidationErrors.hasErrors()) {
                System.out.println("\nWARNING: We detected validation errors in the provided configuration files. We try to create the new configuration files anyway.\nHowever, you might want to review the validation errors and the generated files.\n");
                if (configMigrator.oldKibanaConfigValidationErrors.hasErrors()) {
                    System.out.println("Errors in " + kibanaConfig + "\n" + configMigrator.oldKibanaConfigValidationErrors + "\n");
                }
                if (configMigrator.oldSgConfigValidationErrors.hasErrors()) {
                    System.out.println("Errors in " + sgConfig + "\n" + configMigrator.oldSgConfigValidationErrors + "\n");
                }
            }
            if (backendUpdateInstructions != null && this.outputDir != null) {
                if (backendUpdateInstructions.sgAuthc != null) {
                    try {
                        Files.write(new File(this.outputDir, "sg_authc.yml").toPath(), DocWriter.yaml().writeAsString(backendUpdateInstructions.sgAuthc).getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, "sg_authc.yml"));
                        return 1;
                    }
                }
                if (backendUpdateInstructions.sgAuthz != null) {
                    try {
                        Files.write(new File(this.outputDir, "sg_authz.yml").toPath(), DocWriter.yaml().writeAsString(backendUpdateInstructions.sgAuthz).getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, "sg_authz.yml"));
                        return 1;
                    }
                }
                if (backendUpdateInstructions.sgFrontendMultiTenancy != null) {
                    try {
                        Files.write(new File(this.outputDir, "sg_frontend_multi_tenancy.yml").toPath(), DocWriter.yaml().writeAsString(backendUpdateInstructions.sgFrontendMultiTenancy).getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, "sg_frontend_multi_tenancy.yml"));
                        return 1;
                    }
                }
                if (backendUpdateInstructions.sgLicense != null) {
                    try {
                        Files.write(new File(this.outputDir, "sg_license_key.yml").toPath(), DocWriter.yaml().writeAsString(backendUpdateInstructions.sgLicense).getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, "sg_license_key.yml"));
                        return 1;
                    }
                }
                if (backendUpdateInstructions.sgAuthTokenService != null) {
                    try {
                        Files.write(new File(this.outputDir, "sg_auth_token_service.yml").toPath(), DocWriter.yaml().writeAsString(backendUpdateInstructions.sgAuthTokenService).getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, "sg_auth_token_service.yml"));
                        return 1;
                    }
                }
            }
            if (frontendUpdateInstructions != null && this.outputDir != null) {
                if (frontendUpdateInstructions.sgFrontendConfig != null && !frontendUpdateInstructions.sgFrontendConfig.isEmpty()) {
                    try {
                        Files.write(new File(this.outputDir, "sg_frontend_authc.yml").toPath(), DocWriter.yaml().writeAsString(frontendUpdateInstructions.sgFrontendConfig).getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, "sg_frontend_authc.yml"));
                        return 1;
                    }
                }
                if (frontendUpdateInstructions.kibanaConfig != null) {
                    try {
                        Files.write(new File(this.outputDir, dashboardConfigFileName).toPath(), frontendUpdateInstructions.kibanaConfig.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    }
                    catch (Exception e) {
                        System.out.flush();
                        System.err.println("Error writing " + new File(this.outputDir, dashboardConfigFileName));
                        return 1;
                    }
                }
            }
            if (kibanaConfig == null) {
                System.out.println("You have not specified a kibana.yml file. Thus, we are assuming that you are not using Kibana. If you are using Kibana and want to adapt the migration, please specify the path to your kibana.yml file on the command line.\n\n");
            }
            System.out.println("The update process consists of these steps:\n");
            System.out.println("- Update the Search Guard plugin for Elasticsearch on all nodes of your cluster. In this step, you do not yet need to modify the configuration.\n");
            System.out.println("- After having updated the Search Guard Elasticsearch plugin, please upload the new configuration files with sgctl:\n");
            if (frontendUpdateInstructions != null && frontendUpdateInstructions.sgFrontendConfig != null && !frontendUpdateInstructions.sgFrontendConfig.isEmpty()) {
                System.out.println("$ ./sgctl.sh update-config sg_authc.yml sg_frontend_authc.yml\n");
                System.out.print("The files have been automatically generated from the settings in sg_config.yml and kibana.yml. ");
            } else {
                System.out.println("$ ./sgctl.sh update-config sg_authc.yml\n");
                System.out.print("The files have been automatically generated from the settings in sg_config.yml. ");
            }
            if (this.outputDir != null) {
                System.out.println(" The files are listed below and have been also put to " + this.outputDir + ".\n");
            } else {
                System.out.println(" The files are listed below. Use the -o switch of this tool to write the files to an output directory.\n");
            }
            if (frontendUpdateInstructions != null) {
                if (frontendUpdateInstructions.sgFrontendConfigInstructionsAdvanced != null) {
                    System.out.println(frontendUpdateInstructions.sgFrontendConfigInstructionsAdvanced);
                }
                if (frontendUpdateInstructions.sgFrontendConfigInstructionsReview != null) {
                    System.out.println(frontendUpdateInstructions.sgFrontendConfigInstructionsReview);
                }
            }
            System.out.println("\n----------------------------- sg_authc.yml --------------------------------------");
            System.out.println(DocWriter.yaml().writeAsString(backendUpdateInstructions.sgAuthc));
            System.out.println("\n---------------------------------------------------------------------------------\n");
            if (backendUpdateInstructions.sgAuthz != null) {
                System.out.println("\n----------------------------- sg_authz.yml --------------------------------------");
                System.out.println(DocWriter.yaml().writeAsString(backendUpdateInstructions.sgAuthz));
                System.out.println("\n---------------------------------------------------------------------------------\n");
            }
            if (backendUpdateInstructions.sgFrontendMultiTenancy != null) {
                System.out.println("\n--------------------- sg_frontend_multi_tenancy.yml -------------------------------");
                System.out.println(DocWriter.yaml().writeAsString(backendUpdateInstructions.sgFrontendMultiTenancy));
                System.out.println("\n----------------------------------------------------------------------------------\n");
            }
            if (backendUpdateInstructions.sgLicense != null) {
                System.out.println("\n--------------------------- sg_license_key.yml ------------------------------------");
                System.out.println(DocWriter.yaml().writeAsString(backendUpdateInstructions.sgLicense));
                System.out.println("\n----------------------------------------------------------------------------------\n");
            }
            if (backendUpdateInstructions.sgAuthTokenService != null) {
                System.out.println("\n----------------------- sg_auth_token_service.yml --------------------------------");
                System.out.println(DocWriter.yaml().writeAsString(backendUpdateInstructions.sgAuthTokenService));
                System.out.println("\n----------------------------------------------------------------------------------\n");
            }
            if (frontendUpdateInstructions != null) {
                if (frontendUpdateInstructions.sgFrontendConfig != null && !frontendUpdateInstructions.sgFrontendConfig.isEmpty()) {
                    System.out.println("\n------------------------ sg_frontend_authc.yml ---------------------------------");
                    System.out.println(DocWriter.yaml().writeAsString(frontendUpdateInstructions.sgFrontendConfig));
                    System.out.println("----------------------------------------------------------------------------------\n");
                } else {
                    System.out.println("- " + frontendUpdateInstructions.sgFrontendConfigInstructions);
                }
            }
            if (frontendUpdateInstructions != null) {
                if (frontendUpdateInstructions.sgFrontendConfigInstructionsAdvanced != null) {
                    System.out.println(frontendUpdateInstructions.sgFrontendConfigInstructionsAdvanced);
                }
                if (frontendUpdateInstructions.sgFrontendConfigInstructionsReview != null) {
                    System.out.println(frontendUpdateInstructions.sgFrontendConfigInstructionsReview);
                }
                System.out.println("\n- Afterwards, you need to update the Search Guard plugin for Kibana.\n  " + frontendUpdateInstructions.kibanaConfigInstructions);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public class ConfigMigrator {
        private final ValidationErrors oldSgConfigValidationErrors = new ValidationErrors();
        private final ValidationErrors oldKibanaConfigValidationErrors = new ValidationErrors();
        private final ValidatingDocNode oldSgConfig;
        private final ValidatingDocNode oldKibanaConfig;
        private final YamlRewriter kibanaConfigRewriter;
        private final boolean publicBaseUrlAvailable;
        private String dashboardConfigFileName;

        public ConfigMigrator(File legacySgConfig, File legacyKibanaConfig, boolean publicBaseUrlAvailable, String dashboardConfigFileName) throws FileNotFoundException, IOException, DocumentParseException, UnexpectedDocumentStructureException {
            this.oldSgConfig = new ValidatingDocNode(DocReader.yaml().readObject(legacySgConfig), this.oldSgConfigValidationErrors);
            this.oldKibanaConfig = legacyKibanaConfig != null ? new ValidatingDocNode(DocReader.yaml().readObject(legacyKibanaConfig), this.oldKibanaConfigValidationErrors) : null;
            this.kibanaConfigRewriter = legacyKibanaConfig != null ? new YamlRewriter(legacyKibanaConfig) : null;
            this.publicBaseUrlAvailable = publicBaseUrlAvailable;
            this.dashboardConfigFileName = dashboardConfigFileName;
        }

        public BackendUpdateInstructions createBackendUpdateInstructions() {
            BackendUpdateInstructions result = new BackendUpdateInstructions();
            result.sgAuthc = new SgAuthc();
            boolean anonymousAuth = this.oldSgConfig.get("sg_config.dynamic.http.anonymous_auth_enabled").withDefault(false).asBoolean();
            String license = this.oldSgConfig.get("sg_config.dynamic.license").asString();
            com.floragunn.fluent.collections.ImmutableMap<String, Object> authTokenService = this.oldSgConfig.get("sg_config.dynamic.auth_token_provider").asMap();
            String fieldAnonymizationSalt2 = this.oldSgConfig.get("sg_config.dynamic.field_anonymization_salt2").asString();
            if (fieldAnonymizationSalt2 != null) {
                LinkedHashMap<String, String> authzConfig = new LinkedHashMap<String, String>();
                if (fieldAnonymizationSalt2 != null) {
                    authzConfig.put("field_anonymization.salt", fieldAnonymizationSalt2);
                }
                result.sgAuthz = DocNode.wrap(authzConfig);
            }
            if (this.oldSgConfig.get("sg_config.dynamic.http.xff.enabled").withDefault(false).asBoolean()) {
                result.sgAuthc.internalProxies = this.oldSgConfig.get("sg_config.dynamic.http.xff.internalProxies").asString();
                result.sgAuthc.remoteIpHeader = this.oldSgConfig.get("sg_config.dynamic.http.xff.remoteIpHeader").asString();
            }
            if (this.oldSgConfig.get("sg_config.dynamic.kibana.multitenancy_enabled").withDefault(false).asBoolean()) {
                String feMtServerUsername = this.oldSgConfig.get("sg_config.dynamic.kibana.server_username").asString();
                String feMtIndex = this.oldSgConfig.get("sg_config.dynamic.kibana.index").asString();
                result.sgFrontendMultiTenancy = DocNode.of("enabled", (Object)true, "index", feMtIndex, "server_user", feMtServerUsername);
            }
            DocNode authz = this.oldSgConfig.getDocumentNode().getAsNode("sg_config", "dynamic", "authz");
            ArrayList<UserInformationBackend> userInformationBackends = new ArrayList<UserInformationBackend>();
            if (!authz.isNull()) {
                for (Map.Entry<String, DocNode> entry : authz.toMapOfNodes().entrySet()) {
                    if (entry.getValue().hasNonNull("http_enabled") && Boolean.FALSE.equals(entry.getValue().get("http_enabled"))) continue;
                    AuthzDomain authzDomain = new AuthzDomain(entry.getValue());
                    userInformationBackends.addAll(authzDomain.toUserInformationBackends());
                    this.oldSgConfigValidationErrors.add("sg_config.dynamic.authz." + entry.getKey(), authzDomain.validationErrors);
                }
            }
            DocNode authc = this.oldSgConfig.getDocumentNode().getAsNode("sg_config", "dynamic", "authc");
            ArrayList<OldAuthDomain> oldAuthDomains = new ArrayList<OldAuthDomain>();
            for (Map.Entry entry : authc.toMapOfNodes().entrySet()) {
                DocNode httpAuthenticator;
                if (((DocNode)entry.getValue()).hasNonNull("http_enabled") && Boolean.FALSE.equals(((DocNode)entry.getValue()).get("http_enabled")) || ((DocNode)entry.getValue()).hasNonNull("authentication_backend") && (httpAuthenticator = ((DocNode)entry.getValue()).getAsNode("authentication_backend")).hasNonNull("type") && httpAuthenticator.getAsString("type").equals("sg_auth_token")) continue;
                oldAuthDomains.add(new OldAuthDomain((String)entry.getKey(), (DocNode)entry.getValue()));
            }
            Collections.sort(oldAuthDomains);
            ArrayList<NewAuthDomain> newAuthDomains = new ArrayList<NewAuthDomain>();
            for (OldAuthDomain oldAuthDomain : oldAuthDomains) {
                newAuthDomains.addAll(oldAuthDomain.toNewAuthDomains(userInformationBackends));
                this.oldSgConfigValidationErrors.add("sg_config.dynamic.authc." + oldAuthDomain.id, oldAuthDomain.validationErrors);
            }
            if (anonymousAuth) {
                NewAuthDomain newAuthDomain = new NewAuthDomain("anonymous", null, null, null, null, null);
                newAuthDomain.userMappingUserName.put("static", "sg_anonymous");
                newAuthDomain.userMappingRoles.put("static", "sg_anonymous_backendrole");
                newAuthDomains.add(newAuthDomain);
            }
            result.sgAuthc.authDomains = newAuthDomains;
            if (license != null) {
                result.sgLicense = DocNode.of("key", license);
            }
            if (authTokenService != null && authTokenService.size() != 0) {
                result.sgAuthTokenService = DocNode.wrap(authTokenService);
            }
            return result;
        }

        public FrontendUpdateInstructions createUpdateInstructions() throws SgctlException {
            if (this.oldKibanaConfig == null) {
                return null;
            }
            KibanaAuthType kibanaAuthType = this.oldKibanaConfig.get("searchguard.auth.type").withDefault(KibanaAuthType.BASICAUTH).asEnum(KibanaAuthType.class);
            switch (kibanaAuthType) {
                case BASICAUTH: {
                    return this.createSgFrontendConfigBasicAuth();
                }
                case SAML: {
                    return this.createSgFrontendConfigSaml();
                }
                case OPENID: {
                    return this.createSgFrontendConfigOidc();
                }
                case JWT: {
                    return this.createSgFrontendConfigJwt();
                }
            }
            this.oldKibanaConfigValidationErrors.add(new ValidationError("searchguard.auth.type", "The Kibana authentication type " + kibanaAuthType + " is not supported"));
            return null;
        }

        public FrontendUpdateInstructions createSgFrontendConfigBasicAuth() {
            FrontendUpdateInstructions updateInstructions = new FrontendUpdateInstructions().mainInstructions("You have configured the Search Guard Kibana plugin to use basic authentication (user name and password based).");
            LinkedHashMap<String, Object> newSgFrontendConfig = new LinkedHashMap<String, Object>();
            String loginSubtitle = this.oldKibanaConfig.get("searchguard.basicauth.login.subtitle").asString();
            LinkedHashMap<String, String> authczEntry = new LinkedHashMap<String, String>();
            authczEntry.put("type", "basic");
            if (loginSubtitle != null) {
                authczEntry.put("message", loginSubtitle);
            }
            newSgFrontendConfig.put("auth_domains", Collections.singletonList(authczEntry));
            String loadbalancerUrl = this.oldKibanaConfig.get("searchguard.basicauth.loadbalancer_url").asString();
            if (loadbalancerUrl != null) {
                String publicBaseUrl = this.oldKibanaConfig.get("server.publicBaseUrl").asString();
                if (publicBaseUrl == null) {
                    this.kibanaConfigRewriter.insertAtBeginning(new YamlRewriter.Attribute(this.publicBaseUrlAvailable ? "server.publicBaseUrl" : "searchguard.frontend_base_url", loadbalancerUrl));
                } else if (!publicBaseUrl.equals(loadbalancerUrl)) {
                    this.oldKibanaConfigValidationErrors.add(new ValidationError("searchguard.basicauth.loadbalancer_url", "server.publicBaseUrl and searchguard.basicauth.loadbalancer_url have different values. This is an unexpected configuration."));
                }
            }
            Boolean showBrandImage = this.oldKibanaConfig.get("searchguard.basicauth.login.showbrandimage").asBoolean();
            String brandImage = this.oldKibanaConfig.get("searchguard.basicauth.login.brandimage").asString();
            String loginTitle = this.oldKibanaConfig.get("searchguard.basicauth.login.title").asString();
            String buttonStyle = this.oldKibanaConfig.get("searchguard.basicauth.login.buttonstyle").asString();
            if (showBrandImage != null || brandImage != null || loginTitle != null || buttonStyle != null) {
                LinkedHashMap<String, Object> loginPageConfig = new LinkedHashMap<String, Object>();
                if (showBrandImage != null) {
                    loginPageConfig.put("show_brand_image", showBrandImage);
                }
                if (brandImage != null) {
                    loginPageConfig.put("brand_image", brandImage);
                }
                if (loginTitle != null) {
                    loginPageConfig.put("title", loginTitle);
                }
                if (buttonStyle != null) {
                    loginPageConfig.put("button_style", buttonStyle);
                }
                newSgFrontendConfig.put("login_page", loginPageConfig);
            }
            updateInstructions.sgFrontendConfig(ImmutableMap.of("default", newSgFrontendConfig));
            this.kibanaConfigRewriter.remove("searchguard.auth.type");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.loadbalancer_url");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.login.showbrandimage");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.login.brandimage");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.login.title");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.login.subtitle");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.login.buttonstyle");
            try {
                YamlRewriter.RewriteResult rewriteResult = this.kibanaConfigRewriter.rewrite();
                if (rewriteResult.isChanged()) {
                    updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/" + this.dashboardConfigFileName + " in your Kibana installation. \n  The necessary changes are listed below. " + (String)(MigrateConfig.this.outputDir != null ? "An automatically updated " + this.dashboardConfigFileName + " file has been put by this tool to " + MigrateConfig.this.outputDir + "." : "") + "\n\n---------------------------------------------------------------------------------\n" + this.kibanaConfigRewriter.getManualInstructions() + "\n---------------------------------------------------------------------------------");
                    updateInstructions.kibanaConfig(rewriteResult.getYaml());
                } else {
                    updateInstructions.kibanaConfigInstructions("You do not need to update the Kibana configuration.");
                }
            }
            catch (YamlRewriter.RewriteException e) {
                updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/" + this.dashboardConfigFileName + " in your Kibana installation.\n  Please perform the following updates:\n\n" + e.getManualInstructions());
            }
            return updateInstructions;
        }

        public FrontendUpdateInstructions createSgFrontendConfigSaml() throws SgctlException {
            LinkedHashMap<String, Object> newSgFrontendConfig = new LinkedHashMap<String, Object>(SG_META);
            ImmutableList<DocNode> samlAuthDomains = this.oldSgConfig.getDocumentNode().findNodesByJsonPath("$.sg_config.dynamic.authc.*[?(@.http_authenticator.type == 'saml' || @.http_authenticator.type == 'com.floragunn.dlic.auth.http.saml.HTTPSamlAuthenticator')]");
            String frontendBaseUrl = null;
            if (samlAuthDomains.isEmpty()) {
                return new FrontendUpdateInstructions().error("No auth domains of type 'saml' are defined in the provided sg_config.yml file, even though kibana.yml is configured to use SAML authentication. This is an invalid configuration. Please check if you have provided the correct configuration files.");
            }
            List activeSamlAuthDomains = samlAuthDomains.stream().filter(node -> node.get("http_enabled") != Boolean.FALSE).collect(Collectors.toList());
            if (activeSamlAuthDomains.isEmpty()) {
                return new FrontendUpdateInstructions().error("All auth domains of type 'saml' defined in sg_config.yml are disabled, even though kibana.yml is configured to use SAML authentication. This is an invalid configuration. Please check if you have provided the correct configuration files.");
            }
            FrontendUpdateInstructions updateInstructions = new FrontendUpdateInstructions();
            updateInstructions.setSgFrontendConfigInstructionsTypeSpecific("You have configured Search Guard to use SAML authentication. The SAML configuration was moved to sg_frontend_authc.yml.");
            if (activeSamlAuthDomains.size() > 1) {
                updateInstructions.sgFrontendConfigInstructionsAdvanced("sg_config.yml defines more than one auth domain of type 'saml'. This is a non-standard advanced cofiguration. The new Search Guard Kibana plugin will use this configuration to present a list of all available SAML auth domains when logging in. The user can then choose from one of the auth domains.");
                updateInstructions.sgFrontendConfigInstructionsReview("Please review the settings. If one of the SAML auth domains is not necessary, you should remove it.");
            }
            ArrayList newAuthDomains = new ArrayList();
            for (DocNode samlAuthDomain : activeSamlAuthDomains) {
                Object validator;
                Boolean checkIssuer;
                MigrationResult tlsMigrationResult;
                LinkedHashMap<String, Object> newAuthDomain = new LinkedHashMap<String, Object>();
                newAuthDomains.add(newAuthDomain);
                newAuthDomain.put("type", "saml");
                if (activeSamlAuthDomains.size() > 1) {
                    newAuthDomain.put("label", samlAuthDomain.getKey());
                }
                ValidationErrors samlAuthDomainValidationErrors = new ValidationErrors();
                ValidatingDocNode vSamlAuthDomain = new ValidatingDocNode(samlAuthDomain, samlAuthDomainValidationErrors);
                String kibanaUrl = vSamlAuthDomain.get("http_authenticator.config.kibana_url").required().asString();
                if (frontendBaseUrl == null) {
                    frontendBaseUrl = kibanaUrl;
                } else if (kibanaUrl != null && !frontendBaseUrl.equals(kibanaUrl)) {
                    throw new SgctlException("You have two SAML auth domains for different Kibana URLs. This configuration is not supported by this tool. If you are running several Kibana instances, please check the Search Guard documentation on how to configure several Kibana instances.");
                }
                String idpMetadataUrl = vSamlAuthDomain.get("http_authenticator.config.idp.metadata_url").asString();
                String idpMetadataFile = vSamlAuthDomain.get("http_authenticator.config.idp.metadata_file").asString();
                if (idpMetadataFile == null && idpMetadataUrl == null) {
                    samlAuthDomainValidationErrors.add(new MissingAttribute("http_authenticator.config.idp.metadata_url"));
                }
                String idpEntityId = vSamlAuthDomain.get("http_authenticator.config.idp.entity_id").required().asString();
                LinkedHashMap<String, Object> idp = new LinkedHashMap<String, Object>();
                if (idpMetadataUrl != null) {
                    idp.put("metadata_url", idpMetadataUrl);
                }
                if (idpMetadataFile != null) {
                    idp.put("metadata_xml", "${file:" + idpMetadataFile + "}");
                }
                idp.put("entity_id", idpEntityId);
                com.floragunn.fluent.collections.ImmutableMap<String, Object> tls = vSamlAuthDomain.get("http_authenticator.config.idp").asMap();
                if (tls != null && (tlsMigrationResult = this.migrateTlsConfig(tls)) != null) {
                    idp.put("tls", tlsMigrationResult.config);
                    this.oldSgConfigValidationErrors.add("http_authenticator.config.idp", tlsMigrationResult.getSourceValidationErrors());
                }
                newAuthDomain.put("saml.idp", idp);
                String spEntityId = vSamlAuthDomain.get("http_authenticator.config.sp.entity_id").required().asString();
                String spSignatureAlgorithm = vSamlAuthDomain.get("http_authenticator.config.sp.signature_algorithm").asString();
                String spSignaturePrivateKeyPassword = vSamlAuthDomain.get("http_authenticator.config.sp.signature_private_key_password").asString();
                String spSignaturePrivateKeyFilepath = vSamlAuthDomain.get("http_authenticator.config.sp.signature_private_key_filepath").asString();
                String spSignaturePrivateKey = vSamlAuthDomain.get("http_authenticator.config.sp.signature_private_key").asString();
                Boolean useForceAuth = vSamlAuthDomain.get("http_authenticator.config.sp.forceAuthn").asBoolean();
                LinkedHashMap<String, Object> sp = new LinkedHashMap<String, Object>();
                sp.put("entity_id", spEntityId);
                if (spSignatureAlgorithm != null) {
                    sp.put("signature_algorithm", spSignatureAlgorithm);
                }
                if (spSignaturePrivateKeyPassword != null) {
                    sp.put("signature_private_key_password", spSignaturePrivateKeyPassword);
                }
                if (spSignaturePrivateKeyFilepath != null) {
                    sp.put("signature_private_key_filepath", spSignaturePrivateKeyFilepath);
                }
                if (spSignaturePrivateKey != null) {
                    sp.put("signature_private_key", spSignaturePrivateKey);
                }
                if (useForceAuth != null) {
                    sp.put("forceAuthn", useForceAuth);
                }
                newAuthDomain.put("saml.sp", sp);
                String subjectKey = vSamlAuthDomain.get("http_authenticator.config.subject_key").asString();
                String subjectPattern = vSamlAuthDomain.get("http_authenticator.config.subject_pattern").asString();
                if (subjectPattern == null) {
                    if (subjectKey != null) {
                        newAuthDomain.put("user_mapping.user_name.from", "$.saml_response['" + subjectKey + "']");
                    }
                } else {
                    if (subjectKey != null) {
                        newAuthDomain.put("user_mapping.user_name.from.json_path", "$.saml_response['" + subjectKey + "']");
                    }
                    newAuthDomain.put("user_mapping.user_name.from.pattern", subjectPattern);
                }
                String rolesKey = vSamlAuthDomain.get("http_authenticator.config.roles_key").required().asString();
                String rolesSeparator = vSamlAuthDomain.get("http_authenticator.config.roles_seperator").asString();
                if (rolesSeparator == null || ",".equals(rolesSeparator)) {
                    if (rolesKey != null) {
                        newAuthDomain.put("user_mapping.roles.from_comma_separated_string", "$.saml_response['" + rolesKey + "']");
                    }
                } else {
                    if (rolesKey != null) {
                        newAuthDomain.put("user_mapping.roles.from.json_path", "$.saml_response['" + rolesKey + "']");
                    }
                    newAuthDomain.put("user_mapping.roles.from.split", rolesSeparator);
                }
                if ((checkIssuer = vSamlAuthDomain.get("http_authenticator.config.check_issuer").asBoolean()) != null) {
                    newAuthDomain.put("saml.check_issuer", checkIssuer);
                }
                if ((validator = vSamlAuthDomain.get("http_authenticator.config.validator").asAnything()) instanceof Map) {
                    newAuthDomain.put("saml.validator", validator);
                }
                if (!samlAuthDomainValidationErrors.hasErrors()) continue;
                this.oldSgConfigValidationErrors.add("sg_config.dynamic.authc." + samlAuthDomain.getKey(), samlAuthDomainValidationErrors);
            }
            newSgFrontendConfig.put("auth_domains", newAuthDomains);
            updateInstructions.sgFrontendConfig(ImmutableMap.of("default", newSgFrontendConfig));
            this.kibanaConfigRewriter.remove("searchguard.auth.type");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.loadbalancer_url");
            if (!this.oldKibanaConfig.hasNonNull("server.publicBaseUrl")) {
                this.kibanaConfigRewriter.insertAtBeginning(new YamlRewriter.Attribute(this.publicBaseUrlAvailable ? "server.publicBaseUrl" : "searchguard.frontend_base_url", frontendBaseUrl));
            }
            try {
                YamlRewriter.RewriteResult rewriteResult = this.kibanaConfigRewriter.rewrite();
                if (rewriteResult.isChanged()) {
                    updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/kibana.yml in your Kibana installation. \n  The necessary changes are listed below. " + (String)(MigrateConfig.this.outputDir != null ? "An automatically updated kibana.yml file has been put by this tool to " + MigrateConfig.this.outputDir + "." : "") + "\n\n---------------------------------------------------------------------------------\n" + this.kibanaConfigRewriter.getManualInstructions() + "\n---------------------------------------------------------------------------------");
                    updateInstructions.kibanaConfig(rewriteResult.getYaml());
                } else {
                    updateInstructions.kibanaConfigInstructions("You do not need to update the Kibana configuration.");
                }
            }
            catch (YamlRewriter.RewriteException e) {
                updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/kibana.yml in your Kibana installation.\n  Please perform the following updates:\n\n" + e.getManualInstructions());
            }
            return updateInstructions;
        }

        public FrontendUpdateInstructions createSgFrontendConfigOidc() {
            LinkedHashMap<String, Object> newSgFrontendConfig = new LinkedHashMap<String, Object>(SG_META);
            ImmutableList<DocNode> oidcAuthDomains = this.oldSgConfig.getDocumentNode().findNodesByJsonPath("$.sg_config.dynamic.authc.*[?(@.http_authenticator.type == 'openid')]");
            String frontendBaseUrl = this.oldKibanaConfig.get("searchguard.openid.base_redirect_url").asString();
            if (frontendBaseUrl == null) {
                frontendBaseUrl = this.getFrontendBaseUrlFromKibanaYaml();
            }
            if (oidcAuthDomains.isEmpty()) {
                return new FrontendUpdateInstructions().error("No auth domains of type 'openid' are defined in the provided sg_config.yml, even though kibana.yml is configured to use OIDC authentication. This is an invalid configuration. Please check if you have provided the correct configuration files.");
            }
            List activeOidcAuthDomains = oidcAuthDomains.stream().filter(node -> node.get("http_enabled") != Boolean.FALSE).collect(Collectors.toList());
            if (activeOidcAuthDomains.isEmpty()) {
                return new FrontendUpdateInstructions().error("All auth domains of type 'openid' defined in sg_config.yml are disabled, even though kibana.yml is configured to use OIDC authentication. This is an invalid configuration. Please check if you have provided the correct configuration files.");
            }
            FrontendUpdateInstructions updateInstructions = new FrontendUpdateInstructions().mainInstructions("You have configured Search Guard to use OIDC authentication.");
            if (activeOidcAuthDomains.size() > 1) {
                updateInstructions.mainInstructions("You have defined several OIDC authentication domains. The configuration will be converted in such a way that the user can choose from a list of authentication domains. If you are using a setup with multiple Kibana instances, please refer to the Search Guard documentation on how to configure such a setup.");
            }
            ArrayList<LinkedHashMap<String, Object>> newAuthDomains = new ArrayList<LinkedHashMap<String, Object>>();
            for (DocNode oidcAuthDomain : activeOidcAuthDomains) {
                MigrationResult migrationResult;
                com.floragunn.fluent.collections.ImmutableMap<String, Object> tls;
                Object proxy;
                Object claimsToUserAttrs;
                String rolesPath;
                LinkedHashMap<String, Object> newAuthDomain = new LinkedHashMap<String, Object>();
                newAuthDomains.add(newAuthDomain);
                newAuthDomain.put("type", "oidc");
                if (activeOidcAuthDomains.size() > 1) {
                    newAuthDomain.put("label", oidcAuthDomain.getKey());
                }
                ValidationErrors authDomainValidationErrors = new ValidationErrors();
                ValidatingDocNode vOidcAuthDomain = new ValidatingDocNode(oidcAuthDomain, authDomainValidationErrors);
                String openIdConnectUrl = vOidcAuthDomain.get("http_authenticator.config.openid_connect_url").required().asString();
                String kibanaYmlOpenIdConnectUrl = this.oldKibanaConfig.get("searchguard.openid.connect_url").asString();
                if (openIdConnectUrl != null && kibanaYmlOpenIdConnectUrl != null && !openIdConnectUrl.equals(kibanaYmlOpenIdConnectUrl)) {
                    authDomainValidationErrors.add(new ValidationError("http_authenticator.config.openid_connect_url", "The openid_connect_url in sg_config.yml and kibana.yml must be equal. However, in the given configuration the URLs differ."));
                }
                String clientId = this.oldKibanaConfig.get("searchguard.openid.client_id").required().asString();
                String clientSecret = this.oldKibanaConfig.get("searchguard.openid.client_secret").required().asString();
                String scope = this.oldKibanaConfig.get("searchguard.openid.scope").asString();
                String logoutUrl = this.oldKibanaConfig.get("searchguard.openid.logout_url").asString();
                newAuthDomain.put("oidc.idp.openid_configuration_url", openIdConnectUrl);
                newAuthDomain.put("oidc.client_id", clientId);
                newAuthDomain.put("oidc.client_secret", clientSecret);
                if (scope != null) {
                    newAuthDomain.put("oidc.scope", scope);
                }
                if (logoutUrl != null) {
                    newAuthDomain.put("oidc.logout_url", logoutUrl);
                }
                String subjectKey = vOidcAuthDomain.get("http_authenticator.config.subject_key").asString();
                String subjectPattern = vOidcAuthDomain.get("http_authenticator.config.subject_pattern").asString();
                String subjectPath = vOidcAuthDomain.get("http_authenticator.config.subject_path").asString();
                if (subjectPattern != null) {
                    if (subjectKey != null) {
                        newAuthDomain.put("user_mapping.user_name.from.json_path", "$.oidc_id_token['" + subjectKey + "']");
                    }
                    if (subjectPath != null) {
                        newAuthDomain.put("user_mapping.user_name.from.json_path", "$.oidc_id_token." + subjectPath);
                    }
                    newAuthDomain.put("user_mapping.user_name.from.pattern", subjectPattern);
                } else {
                    if (subjectKey != null) {
                        newAuthDomain.put("user_mapping.user_name.from", "$.oidc_id_token['" + subjectKey + "']");
                    }
                    if (subjectPath != null) {
                        newAuthDomain.put("user_mapping.user_name.from", "$.oidc_id_token." + subjectPath);
                    }
                }
                String rolesKey = vOidcAuthDomain.get("http_authenticator.config.roles_key").asString();
                if (rolesKey != null) {
                    newAuthDomain.put("user_mapping.roles.from_comma_separated_string", "$.oidc_id_token['" + rolesKey + "']");
                }
                if ((rolesPath = vOidcAuthDomain.get("http_authenticator.config.roles_path").asString()) != null) {
                    newAuthDomain.put("user_mapping.roles.from_comma_separated_string", rolesPath);
                }
                if ((claimsToUserAttrs = vOidcAuthDomain.get("http_authenticator.config.map_claims_to_user_attrs").asAnything()) != null) {
                    newAuthDomain.put("user_mapping.attrs.from", claimsToUserAttrs);
                }
                if ((proxy = vOidcAuthDomain.get("http_authenticator.config.proxy").asAnything()) != null) {
                    newAuthDomain.put("oidc.idp.proxy", proxy);
                }
                if ((tls = vOidcAuthDomain.get("http_authenticator.config.openid_connect_idp").asMap()) != null && (migrationResult = this.migrateTlsConfig(tls)) != null) {
                    newAuthDomain.put("oidc.idp.tls", tls);
                    this.oldSgConfigValidationErrors.add("http_authenticator.config.openid_connect_idp", migrationResult.getSourceValidationErrors());
                }
                this.migrateAttribute("idp_request_timeout_ms", vOidcAuthDomain, newAuthDomain, "oidc");
                this.migrateAttribute("idp_queued_thread_timeout_ms", vOidcAuthDomain, newAuthDomain, "oidc");
                this.migrateAttribute("refresh_rate_limit_time_window_ms", vOidcAuthDomain, newAuthDomain, "oidc");
                this.migrateAttribute("refresh_rate_limit_count", vOidcAuthDomain, newAuthDomain, "oidc");
                this.migrateAttribute("cache_jwks_endpoint", vOidcAuthDomain, newAuthDomain, "oidc");
                if (!authDomainValidationErrors.hasErrors()) continue;
                this.oldSgConfigValidationErrors.add("sg_config.dynamic.authc." + oidcAuthDomain.getKey(), authDomainValidationErrors);
            }
            newSgFrontendConfig.put("auth_domains", newAuthDomains);
            if (!this.oldKibanaConfig.hasNonNull("server.publicBaseUrl")) {
                this.kibanaConfigRewriter.insertAtBeginning(new YamlRewriter.Attribute(this.publicBaseUrlAvailable ? "server.publicBaseUrl" : "searchguard.frontend_base_url", frontendBaseUrl));
            }
            updateInstructions.sgFrontendConfig(ImmutableMap.of("default", newSgFrontendConfig));
            this.kibanaConfigRewriter.remove("searchguard.auth.type");
            this.kibanaConfigRewriter.remove("searchguard.basicauth.loadbalancer_url");
            this.kibanaConfigRewriter.remove("searchguard.openid.connect_url");
            this.kibanaConfigRewriter.remove("searchguard.openid.client_id");
            this.kibanaConfigRewriter.remove("searchguard.openid.client_secret");
            this.kibanaConfigRewriter.remove("searchguard.openid.scope");
            this.kibanaConfigRewriter.remove("searchguard.openid.header");
            this.kibanaConfigRewriter.remove("searchguard.openid.base_redirect_url");
            this.kibanaConfigRewriter.remove("searchguard.openid.logout_url");
            try {
                YamlRewriter.RewriteResult rewriteResult = this.kibanaConfigRewriter.rewrite();
                if (rewriteResult.isChanged()) {
                    updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/kibana.yml in your Kibana installation. \n  The necessary changes are listed below. " + (String)(MigrateConfig.this.outputDir != null ? "An automatically updated kibana.yml file has been put by this tool to " + MigrateConfig.this.outputDir + "." : "") + "\n\n" + this.kibanaConfigRewriter.getManualInstructions());
                    updateInstructions.kibanaConfig(rewriteResult.getYaml());
                } else {
                    updateInstructions.kibanaConfigInstructions("You do not need to update the Kibana configuration.");
                }
            }
            catch (YamlRewriter.RewriteException e) {
                updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/kibana.yml in your Kibana installation.\n  Please perform the following updates:\n\n" + e.getManualInstructions());
            }
            return updateInstructions;
        }

        public FrontendUpdateInstructions createSgFrontendConfigJwt() throws SgctlException {
            String urlParameter = this.oldKibanaConfig.get("searchguard.jwt.url_parameter").asString();
            String loginEndpoint = this.oldKibanaConfig.get("searchguard.jwt.login_endpoint").asString();
            FrontendUpdateInstructions updateInstructions = new FrontendUpdateInstructions();
            if (urlParameter == null) {
                throw new SgctlException("You have configured Search Guard to use authentication using a JWT provided as an Authorization header. This is an advanced configuration, usually only found in combination with a proxy which adds the Authorization header to HTTP requests. This configuration is not supported by this tool. Please refer to the Search Guard documentation for details.");
            }
            updateInstructions.mainInstructions("You have configured Search Guard to use authentication using a JWT specified as URL parameter.");
            this.kibanaConfigRewriter.insertAfter("searchguard.auth.type", new YamlRewriter.Attribute("searchguard.auth.jwt.enabled", true));
            this.kibanaConfigRewriter.insertAfter("searchguard.auth.type", new YamlRewriter.Attribute("searchguard.auth.jwt.url_parameter", urlParameter));
            this.kibanaConfigRewriter.remove("searchguard.auth.type");
            this.kibanaConfigRewriter.remove("searchguard.jwt.header");
            this.kibanaConfigRewriter.remove("searchguard.jwt.login_endpoint");
            this.kibanaConfigRewriter.remove("searchguard.jwt.url_parameter");
            try {
                YamlRewriter.RewriteResult rewriteResult = this.kibanaConfigRewriter.rewrite();
                if (rewriteResult.isChanged()) {
                    updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/kibana.yml in your Kibana installation. \n  The necessary changes are listed below. " + (String)(MigrateConfig.this.outputDir != null ? "An automatically updated kibana.yml file has been put by this tool to " + MigrateConfig.this.outputDir + "." : "") + "\n\n" + this.kibanaConfigRewriter.getManualInstructions());
                    updateInstructions.kibanaConfig(rewriteResult.getYaml());
                } else {
                    updateInstructions.kibanaConfigInstructions("You do not need to update the Kibana configuration.");
                }
            }
            catch (YamlRewriter.RewriteException e) {
                updateInstructions.kibanaConfigInstructions("Before starting Kibana with the updated plugin, you need to update the file config/kibana.yml in your Kibana installation.\n  Please perform the following updates:\n\n" + e.getManualInstructions());
            }
            if (loginEndpoint != null) {
                LinkedHashMap<String, List<ImmutableMap<String, String>>> newSgFrontendConfig = new LinkedHashMap<String, List<ImmutableMap<String, String>>>();
                newSgFrontendConfig.put("auth_domains", Collections.singletonList(ImmutableMap.of("type", "link", "url", loginEndpoint)));
                updateInstructions.sgFrontendConfig(ImmutableMap.of("default", newSgFrontendConfig));
                return updateInstructions;
            }
            updateInstructions.sgFrontendConfigInstructions("In the current configuration, the Search Guard Kibana plugin does not provide a login form. The only way to login is opening a Kibana URL with the URL parameter " + urlParameter + ". Thus, the sg_frontend_authc.yml file generated by this tool will also define no authenticators. If you want to have more login methods, you can add these to sg_frontend_authc.yml.");
            updateInstructions.sgFrontendConfig(Collections.emptyMap());
            return updateInstructions;
        }

        private String getFrontendBaseUrlFromKibanaYaml() {
            boolean https = this.oldKibanaConfig.get("server.ssl.enabled").withDefault(false).asBoolean();
            String host = this.oldKibanaConfig.get("server.host").required().asString();
            int port = this.oldKibanaConfig.get("server.port").withDefault(-1).asInteger();
            String basePath = this.oldKibanaConfig.get("server.basepath").asString();
            if (port == 80 && !https) {
                port = -1;
            } else if (port == 443 && https) {
                port = -1;
            }
            try {
                return new URI(https ? "https" : "http", null, host, port, basePath, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private void migrateAttribute(String name, ValidatingDocNode source, Map<String, Object> target, String newScope) {
            Object value = source.get("http_authenticator.config." + name).asAnything();
            if (value != null) {
                target.put(newScope + "." + name, value);
            }
        }

        private MigrationResult migrateTlsConfig(Map<String, Object> config) {
            if (config == null) {
                return null;
            }
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(config, validationErrors);
            if (!vNode.get("enable_ssl").withDefault(false).asBoolean()) {
                return null;
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            if (vNode.hasNonNull("pemtrustedcas_content")) {
                ImmutableList<String> pems = vNode.get("pemtrustedcas_content").asListOfStrings();
                result.put("trusted_cas", pems.size() == 1 ? pems.get(0) : pems);
            } else if (vNode.hasNonNull("pemtrustedcas_filepath")) {
                String path = vNode.get("pemtrustedcas_filepath").asString();
                result.put("trusted_cas", "${file:" + path + "}");
            }
            if (vNode.get("enable_ssl_client_auth").withDefault(false).asBoolean()) {
                String path;
                ImmutableList<String> pems;
                LinkedHashMap<String, Object> newClientAuthConfig = new LinkedHashMap<String, Object>();
                if (vNode.hasNonNull("pemcert_content")) {
                    pems = vNode.get("pemcert_content").asListOfStrings();
                    newClientAuthConfig.put("certificate", pems.size() == 1 ? pems.get(0) : pems);
                } else if (vNode.hasNonNull("pemcert_filepath")) {
                    path = vNode.get("pemcert_filepath").asString();
                    newClientAuthConfig.put("certificate", "${file:" + path + "}");
                }
                if (vNode.hasNonNull("pemkey_content")) {
                    pems = vNode.get("pemkey_content").asListOfStrings();
                    newClientAuthConfig.put("private_key", pems.size() == 1 ? pems.get(0) : pems);
                } else if (vNode.hasNonNull("pemkey_filepath")) {
                    path = vNode.get("pemkey_filepath").asString();
                    newClientAuthConfig.put("private_key", "${file:" + path + "}");
                }
                if (vNode.hasNonNull("pemkey_password")) {
                    String password = vNode.get("pemkey_password").asString();
                    newClientAuthConfig.put("private_key_password", password);
                }
                if (newClientAuthConfig.size() != 0) {
                    result.put("client_auth", newClientAuthConfig);
                }
            }
            if (vNode.hasNonNull("enabled_ssl_protocols")) {
                result.put("enabled_protocols", vNode.get("enabled_ssl_protocols").asListOfStrings());
            }
            if (vNode.hasNonNull("enabled_ssl_ciphers")) {
                result.put("enabled_ciphers", vNode.get("enabled_ssl_ciphers").asListOfStrings());
            }
            if (vNode.hasNonNull("trust_all")) {
                result.put("trust_all", vNode.get("trust_all").asBoolean());
            }
            if (vNode.hasNonNull("verify_hostnames")) {
                result.put("verify_hostnames", vNode.get("verify_hostnames").asBoolean());
            }
            return new MigrationResult(result, validationErrors);
        }
    }

    public static class BackendUpdateInstructions {
        SgAuthc sgAuthc;
        DocNode sgLicense;
        DocNode sgAuthTokenService;
        DocNode sgAuthz;
        DocNode sgFrontendMultiTenancy;
        Object sgAuthcTransport;
        List<String> infos = new ArrayList<String>();
    }

    static class FrontendUpdateInstructions {
        private String mainInstructions;
        private String error;
        private String esPluginUpdateInstructions = "";
        private String sgFrontendConfigInstructions = null;
        private String sgFrontendConfigInstructionsAdvanced;
        private String sgFrontendConfigInstructionsReview = "Please review the settings.";
        private String sgFrontendConfigInstructionsTypeSpecific = null;
        private Map<String, Object> sgFrontendConfig;
        private String kibanaPluginUpdateInstructions = "After the new sg_frontend_authc.yml has been successfully uploaded to Search Guard, you can update the Search Guard Kibana plugin.";
        private String kibanaConfigInstructions;
        private String kibanaConfig;

        FrontendUpdateInstructions() {
        }

        public Map<String, Object> getSgFrontendConfig() {
            return this.sgFrontendConfig;
        }

        public FrontendUpdateInstructions sgFrontendConfig(Map<String, Object> sgFrontendConfig) {
            this.sgFrontendConfig = sgFrontendConfig;
            return this;
        }

        public String getKibanaConfig() {
            return this.kibanaConfig;
        }

        public FrontendUpdateInstructions kibanaConfig(String kibanaConfig) {
            this.kibanaConfig = kibanaConfig;
            return this;
        }

        public String getMainInstructions() {
            return this.mainInstructions;
        }

        public FrontendUpdateInstructions mainInstructions(String mainInstructions) {
            this.mainInstructions = mainInstructions;
            return this;
        }

        public String getSgFrontendConfigInstructions() {
            return this.sgFrontendConfigInstructions;
        }

        public FrontendUpdateInstructions sgFrontendConfigInstructions(String sgFrontendConfigInstructions) {
            this.sgFrontendConfigInstructions = sgFrontendConfigInstructions;
            return this;
        }

        public String getKibanaConfigInstructions() {
            return this.kibanaConfigInstructions;
        }

        public FrontendUpdateInstructions kibanaConfigInstructions(String kibanaConfigInstructions) {
            this.kibanaConfigInstructions = kibanaConfigInstructions;
            return this;
        }

        public String getError() {
            return this.error;
        }

        public FrontendUpdateInstructions error(String error) {
            this.error = error;
            return this;
        }

        public String getEsPluginUpdateInstructions() {
            return this.esPluginUpdateInstructions;
        }

        public FrontendUpdateInstructions esPluginUpdateInstructions(String esPluginUpdateInstructions) {
            this.esPluginUpdateInstructions = esPluginUpdateInstructions;
            return this;
        }

        public String getKibanaPluginUpdateInstructions() {
            return this.kibanaPluginUpdateInstructions;
        }

        public FrontendUpdateInstructions kibanaPluginUpdateInstructions(String kibanaPluginUpdateInstructions) {
            this.kibanaPluginUpdateInstructions = kibanaPluginUpdateInstructions;
            return this;
        }

        public String getSgFrontendConfigInstructionsAdvanced() {
            return this.sgFrontendConfigInstructionsAdvanced;
        }

        public FrontendUpdateInstructions sgFrontendConfigInstructionsAdvanced(String sgFrontendConfigInstructionsAdvanced) {
            this.sgFrontendConfigInstructionsAdvanced = sgFrontendConfigInstructionsAdvanced;
            return this;
        }

        public String getSgFrontendConfigInstructionsReview() {
            return this.sgFrontendConfigInstructionsReview;
        }

        public FrontendUpdateInstructions sgFrontendConfigInstructionsReview(String sgFrontendConfigInstructionsReview) {
            this.sgFrontendConfigInstructionsReview = sgFrontendConfigInstructionsReview;
            return this;
        }

        public String getSgFrontendConfigInstructionsTypeSpecific() {
            return this.sgFrontendConfigInstructionsTypeSpecific;
        }

        public void setSgFrontendConfigInstructionsTypeSpecific(String sgFrontendConfigInstructionsTypeSpecific) {
            this.sgFrontendConfigInstructionsTypeSpecific = sgFrontendConfigInstructionsTypeSpecific;
        }
    }

    static class SgAuthc
    implements Document<SgAuthc> {
        private List<NewAuthDomain> authDomains;
        private String internalProxies = null;
        private String remoteIpHeader = null;

        SgAuthc() {
        }

        @Override
        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("auth_domains", this.authDomains);
            if (this.internalProxies != null || this.remoteIpHeader != null) {
                LinkedHashMap<String, Object> network = new LinkedHashMap<String, Object>();
                if (this.internalProxies != null) {
                    network.put("trusted_proxies_regex", this.internalProxies);
                }
                if (this.remoteIpHeader != null) {
                    network.put("http", ImmutableMap.of("remote_ip_header", this.remoteIpHeader));
                }
                result.put("network", network);
            }
            return result;
        }
    }

    static class MigrationResult {
        private final Map<String, Object> config;
        private final ValidationErrors sourceValidationErrors;

        MigrationResult(Map<String, Object> config, ValidationErrors sourceValidationErrors) {
            this.config = config;
            this.sourceValidationErrors = sourceValidationErrors;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public ValidationErrors getSourceValidationErrors() {
            return this.sourceValidationErrors;
        }
    }

    static class UserInformationBackend
    implements Document<UserInformationBackend> {
        private String type;
        private Map<String, Object> backendConfig = new LinkedHashMap<String, Object>();
        private Map<String, Object> userMappingUserName = new LinkedHashMap<String, Object>();
        private Map<String, Object> userMappingRoles = new LinkedHashMap<String, Object>();
        private Map<String, Object> userMappingAttributes = new LinkedHashMap<String, Object>();

        UserInformationBackend(String type) {
            this.type = type;
        }

        @Override
        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("type", this.type);
            result.put(this.type, this.backendConfig);
            return result;
        }

        public UserInformationBackend clone() {
            UserInformationBackend result = new UserInformationBackend(this.type);
            result.userMappingUserName.putAll(this.userMappingUserName);
            result.userMappingRoles.putAll(this.userMappingRoles);
            result.userMappingAttributes.putAll(this.userMappingAttributes);
            result.backendConfig.putAll(this.backendConfig);
            return result;
        }

        static List<String> mergedRoleMappingFrom(List<UserInformationBackend> backends) {
            if (backends == null || backends.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (UserInformationBackend backend : backends) {
                Object from = backend.userMappingRoles.get("from");
                if (from instanceof String) {
                    result.add((String)from);
                    continue;
                }
                if (!(from instanceof List)) continue;
                ((List)from).forEach(e -> result.add(String.valueOf(e)));
            }
            return new ArrayList<String>(result);
        }
    }

    static class AuthzDomain {
        private final ValidatingDocNode vNode;
        private final ValidationErrors validationErrors = new ValidationErrors();
        private DocNode config;
        private String oldType;

        AuthzDomain(DocNode config) {
            this.config = config;
            this.vNode = new ValidatingDocNode(config, this.validationErrors);
            this.oldType = this.vNode.get("authorization_backend.type").required().asString();
        }

        List<UserInformationBackend> toUserInformationBackends() {
            if (this.oldType == null) {
                return Collections.emptyList();
            }
            switch (this.oldType) {
                case "intern": 
                case "internal": {
                    return Collections.singletonList(new UserInformationBackend("internal_users_db"));
                }
                case "ldap2": 
                case "ldap": {
                    UserInformationBackend result = new UserInformationBackend("ldap");
                    LinkedHashMap<String, Object> newConfig = new LinkedHashMap<String, Object>();
                    LinkedHashMap<String, Object> idpConfig = new LinkedHashMap<String, Object>();
                    boolean ssl = this.vNode.get("authorization_backend.config.enable_ssl").withDefault(false).asBoolean();
                    idpConfig.put("hosts", this.vNode.get("authorization_backend.config.hosts").required().asList().withEmptyListAsDefault().ofStrings().stream().map(s -> ssl ? (s.startsWith("ldaps://") ? s : "ldaps://" + s) : s).collect(Collectors.toList()));
                    DocNode oldBackendConfig = this.config.getAsNode("authorization_backend", "config");
                    if (oldBackendConfig.hasNonNull("bind_dn")) {
                        idpConfig.put("bind_dn", oldBackendConfig.getAsString("bind_dn"));
                    }
                    if (oldBackendConfig.hasNonNull("password")) {
                        idpConfig.put("password", oldBackendConfig.getAsString("password"));
                    }
                    LinkedHashMap<String, Object> tlsConfig = new LinkedHashMap<String, Object>();
                    boolean startTls = this.vNode.get("authorization_backend.config.enable_start_tls").withDefault(false).asBoolean();
                    boolean clientAuthEnabled = this.vNode.get("authorization_backend.config.enable_ssl_client_auth").withDefault(false).asBoolean();
                    boolean verifyHostnames = this.vNode.get("authorization_backend.config.verify_hostnames").withDefault(true).asBoolean();
                    String pemTrustedCasFile = this.vNode.get("authorization_backend.config.pemtrustedcas_filepath").asString();
                    String pemTrustedCasContent = this.vNode.get("authorization_backend.config.pemtrustedcas_content").asString();
                    String clientAuthKeyFile = this.vNode.get("authorization_backend.config.pemkey_filepath").asString();
                    String clientAuthKeyPassword = this.vNode.get("authorization_backend.config.pemkey_password").asString();
                    String clientAuthCertFile = this.vNode.get("authorization_backend.config.pemcert_filepath").asString();
                    String clientAuthKeyContent = this.vNode.get("authorization_backend.config.pemkey_content").asString();
                    String clientAuthCertContent = this.vNode.get("authorization_backend.config.pemcert_content").asString();
                    if (startTls) {
                        tlsConfig.put("start_tls", startTls);
                    }
                    if (!verifyHostnames) {
                        tlsConfig.put("verify_hostnames", verifyHostnames);
                    }
                    if (pemTrustedCasContent != null) {
                        tlsConfig.put("trusted_cas", pemTrustedCasContent);
                    } else if (pemTrustedCasFile != null) {
                        tlsConfig.put("trusted_cas", "#{file:" + pemTrustedCasFile + "}");
                    }
                    if (clientAuthEnabled) {
                        LinkedHashMap<String, Object> clientAuth = new LinkedHashMap<String, Object>();
                        if (clientAuthKeyFile != null) {
                            clientAuth.put("private_key", "#{file:" + clientAuthKeyFile + "}");
                        } else if (clientAuthKeyContent != null) {
                            clientAuth.put("private_key", clientAuthKeyFile);
                        }
                        if (clientAuthCertFile != null) {
                            clientAuth.put("certificate", "#{file:" + clientAuthCertFile + "}");
                        } else if (clientAuthCertContent != null) {
                            clientAuth.put("certificate", clientAuthCertContent);
                        }
                        if (clientAuthKeyPassword != null) {
                            clientAuth.put("private_key_password", clientAuthKeyPassword);
                        }
                        tlsConfig.put("client_auth", clientAuth);
                    }
                    if (!tlsConfig.isEmpty()) {
                        idpConfig.put("tls", tlsConfig);
                    }
                    newConfig.put("idp", idpConfig);
                    LinkedHashMap<String, Object> userSearch = new LinkedHashMap<String, Object>();
                    userSearch.put("base_dn", oldBackendConfig.getAsString("userbase"));
                    if (oldBackendConfig.hasNonNull("usersearch")) {
                        userSearch.put("filter", ImmutableMap.of("raw", oldBackendConfig.getAsString("usersearch").replace("{0}", "${user.name}")));
                    }
                    newConfig.put("user_search", userSearch);
                    if (oldBackendConfig.hasNonNull("userrolename")) {
                        ((List)result.userMappingRoles.computeIfAbsent("from", k -> new ArrayList())).add("$.ldap_user_entry[\"" + oldBackendConfig.getAsString("userrolename") + "\"]");
                    }
                    LinkedHashMap<String, Object> groupSearch = new LinkedHashMap<String, Object>();
                    if (oldBackendConfig.hasNonNull("rolebase")) {
                        groupSearch.put("base_dn", oldBackendConfig.getAsString("rolebase"));
                    }
                    if (oldBackendConfig.hasNonNull("rolesearch")) {
                        Object userRoleAttributePlaceholder;
                        if (oldBackendConfig.hasNonNull("userroleattribute")) {
                            userRoleAttributePlaceholder = "${ldap_user_entry." + oldBackendConfig.getAsString("userroleattribute") + "}";
                        } else {
                            userRoleAttributePlaceholder = "${ldap_user_entry.UNDEFINED_USER_ROLE_ATTRIBUTE}";
                            if (oldBackendConfig.getAsString("rolesearch").contains("{2}")) {
                                this.validationErrors.add(new ValidationError("authorization_backend.config.rolesearch", "Uses {2} without defined userroleattribute"));
                            }
                        }
                        groupSearch.put("filter", ImmutableMap.of("raw", oldBackendConfig.getAsString("rolesearch").replace("{0}", "${dn}").replace("{1}", "${user.name}".replace("{2}", (CharSequence)userRoleAttributePlaceholder))));
                    }
                    if (oldBackendConfig.hasNonNull("rolename")) {
                        groupSearch.put("role_name_attribute", oldBackendConfig.getAsString("rolename"));
                    }
                    LinkedHashMap<String, Boolean> recursive = new LinkedHashMap<String, Boolean>();
                    if (oldBackendConfig.hasNonNull("resolve_nested_roles") && Boolean.TRUE.equals(oldBackendConfig.get("resolve_nested_roles"))) {
                        recursive.put("enabled", true);
                    }
                    if (oldBackendConfig.hasNonNull("nested_role_filter")) {
                        this.validationErrors.add(new ValidationError("authorization_backend.config.nested_role_filter", "nested_role_filter is not directly supported any more. You can use group_search.recursive.enabled_for, which is the opposite: A pattern of group dns for which group search shall be performed"));
                    }
                    if (!recursive.isEmpty()) {
                        groupSearch.put("recursive", recursive);
                    }
                    if (!groupSearch.isEmpty()) {
                        newConfig.put("group_search", groupSearch);
                    }
                    newConfig.put("group_search", groupSearch);
                    result.backendConfig = newConfig;
                    if (oldBackendConfig.hasNonNull("users")) {
                        List<UserInformationBackend> multiResult = this.addNewLdapBackendConfigMultiUserBase(result);
                        if (oldBackendConfig.hasNonNull("roles")) {
                            ArrayList<UserInformationBackend> multiMultiResult = new ArrayList<UserInformationBackend>();
                            for (UserInformationBackend resultElement : multiResult) {
                                multiMultiResult.addAll(this.addNewLdapBackendConfigMultiGroupBase(resultElement));
                            }
                            return multiMultiResult;
                        }
                        return multiResult;
                    }
                    if (oldBackendConfig.hasNonNull("roles")) {
                        return this.addNewLdapBackendConfigMultiGroupBase(result);
                    }
                    return Collections.singletonList(result);
                }
            }
            this.validationErrors.add(new ValidationError(null, "Unknown authorization backend " + this.oldType));
            return Collections.emptyList();
        }

        List<UserInformationBackend> addNewLdapBackendConfigMultiUserBase(UserInformationBackend baseAuthDomain) {
            Map<String, DocNode> users = this.config.getAsNode("authorization_backend", "config", "users").toMapOfNodes();
            ArrayList<UserInformationBackend> result = new ArrayList<UserInformationBackend>();
            for (Map.Entry<String, DocNode> entry : users.entrySet()) {
                UserInformationBackend authDomain = baseAuthDomain.clone();
                LinkedHashMap newConfig = (LinkedHashMap)Document.toDeepBasicObject(baseAuthDomain.backendConfig);
                Map userSearch = (Map)newConfig.computeIfAbsent("user_search", k -> new LinkedHashMap());
                userSearch.put("base_dn", entry.getValue().getAsString("base"));
                if (entry.getValue().hasNonNull("search")) {
                    userSearch.put("filter", ImmutableMap.of("raw", entry.getValue().getAsString("search").replace("{0}", "${user.name}")));
                }
                authDomain.backendConfig = newConfig;
                result.add(authDomain);
            }
            return result;
        }

        List<UserInformationBackend> addNewLdapBackendConfigMultiGroupBase(UserInformationBackend baseAuthDomain) {
            DocNode oldBackendConfig = this.config.getAsNode("authorization_backend", "config");
            Map<String, DocNode> users = this.config.getAsNode("authorization_backend", "config", "roles").toMapOfNodes();
            Object userRoleAttributePlaceholder = oldBackendConfig.hasNonNull("userroleattribute") ? "${ldap_user_entry." + oldBackendConfig.getAsString("userroleattribute") + "}" : "${ldap_user_entry.UNDEFINED_USER_ROLE_ATTRIBUTE}";
            ArrayList<UserInformationBackend> result = new ArrayList<UserInformationBackend>();
            for (Map.Entry<String, DocNode> entry : users.entrySet()) {
                UserInformationBackend authDomain = baseAuthDomain.clone();
                LinkedHashMap newConfig = (LinkedHashMap)Document.toDeepBasicObject(baseAuthDomain.backendConfig);
                Map userSearch = (Map)newConfig.computeIfAbsent("group_search", k -> new LinkedHashMap());
                userSearch.put("base_dn", entry.getValue().getAsString("base"));
                if (entry.getValue().hasNonNull("search")) {
                    userSearch.put("filter", ImmutableMap.of("raw", entry.getValue().getAsString("search").replace("{0}", "${dn}").replace("{1}", "${user.name}").replace("{2}", (CharSequence)userRoleAttributePlaceholder)));
                }
                authDomain.backendConfig = newConfig;
                result.add(authDomain);
            }
            return result;
        }
    }

    static class NewAuthDomain
    implements Document<NewAuthDomain> {
        private String frontendType;
        private String backendType;
        private List<String> skipUsers;
        private List<String> acceptIps;
        Map<String, Object> frontendConfig;
        Map<String, Object> backendConfig;
        private LinkedHashMap<String, Object> userMappingUserName = new LinkedHashMap();
        private LinkedHashMap<String, Object> userMappingRoles = new LinkedHashMap();
        private LinkedHashMap<String, Object> userMappingAttributes = new LinkedHashMap();
        private List<UserInformationBackend> userInformationBackends;

        public NewAuthDomain(String frontendType, String backendType, List<String> skipUsers, List<String> acceptIps, Map<String, Object> frontendConfig, Map<String, Object> backendConfig) {
            this.frontendType = frontendType;
            this.backendType = backendType;
            this.skipUsers = skipUsers;
            this.acceptIps = acceptIps;
            this.frontendConfig = frontendConfig;
            this.backendConfig = backendConfig;
        }

        @Override
        public Object toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("type", this.backendType != null ? this.frontendType + "/" + this.backendType : this.frontendType);
            if (this.skipUsers != null && this.skipUsers.size() != 0) {
                result.put("skip", ImmutableMap.of("users", this.skipUsers));
            }
            if (this.acceptIps != null && this.acceptIps.size() != 0) {
                result.put("accept", ImmutableMap.of("ips", this.acceptIps));
            }
            if (this.frontendConfig != null && this.frontendConfig.size() != 0) {
                result.put(this.frontendType, this.frontendConfig);
            }
            if (this.backendConfig != null && this.backendConfig.size() != 0) {
                result.put(this.backendType, this.backendConfig);
            }
            if (this.userInformationBackends != null && this.userInformationBackends.size() != 0) {
                result.put("additional_user_information", this.userInformationBackends);
            }
            if (this.userMappingUserName.size() != 0 || this.userMappingRoles.size() != 0 || this.userMappingAttributes.size() != 0) {
                LinkedHashMap<String, LinkedHashMap<String, Object>> userMapping = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
                if (this.userMappingUserName.size() != 0) {
                    userMapping.put("user_name", this.userMappingUserName);
                }
                if (this.userMappingRoles.size() != 0) {
                    userMapping.put("roles", this.userMappingRoles);
                }
                if (this.userMappingAttributes.size() != 0) {
                    userMapping.put("attrs", this.userMappingAttributes);
                }
                result.put("user_mapping", userMapping);
            }
            return result;
        }

        public NewAuthDomain clone() {
            NewAuthDomain result = new NewAuthDomain(this.frontendType, this.backendType, this.skipUsers, this.acceptIps, this.frontendConfig, this.backendConfig);
            result.userMappingUserName = new LinkedHashMap<String, Object>(this.userMappingUserName);
            result.userMappingRoles = new LinkedHashMap<String, Object>(this.userMappingRoles);
            result.userMappingAttributes = new LinkedHashMap<String, Object>(this.userMappingAttributes);
            result.userInformationBackends = this.userInformationBackends != null ? new ArrayList<UserInformationBackend>(this.userInformationBackends) : null;
            return result;
        }
    }

    static class OldAuthDomain
    implements Comparable<OldAuthDomain>,
    Document<OldAuthDomain> {
        private final DocNode docNode;
        private final ValidatingDocNode vNode;
        private final ValidationErrors validationErrors = new ValidationErrors();
        private final String id;
        private int order;
        private String oldFrontendType;
        private String oldBackendType;
        private String newFrontendType;
        private String newBackendType;
        private List<String> skipUsers;
        private List<String> acceptIps;
        DocNode oldFrontendConfig;
        DocNode oldBackendConfig;

        OldAuthDomain(String id, DocNode docNode) {
            this.id = id;
            this.docNode = docNode;
            this.vNode = new ValidatingDocNode(docNode, this.validationErrors);
            this.order = this.vNode.get("order").withDefault(0).asInt();
            this.oldFrontendType = this.vNode.get("http_authenticator.type").asString();
            this.oldBackendType = this.vNode.get("authentication_backend.type").withDefault("intern").asString();
            if (this.oldBackendType.equals("noop")) {
                this.newBackendType = null;
            } else if (this.oldBackendType.equals("intern") || this.oldBackendType.equals("internal")) {
                this.newBackendType = "internal_users_db";
            } else if (this.oldBackendType.equals("ldap2")) {
                this.oldBackendType = "ldap";
                this.newBackendType = "ldap";
            } else {
                this.newBackendType = this.oldBackendType;
            }
            this.newFrontendType = this.oldFrontendType;
            this.oldFrontendConfig = this.vNode.get("http_authenticator.config").asDocNode();
            this.oldBackendConfig = this.vNode.get("authentication_backend.config").asDocNode();
            this.skipUsers = this.vNode.get("skip_users").asListOfStrings();
            this.acceptIps = this.vNode.get("enabled_only_for_ips").asListOfStrings();
        }

        List<NewAuthDomain> toNewAuthDomains(List<UserInformationBackend> userInformationBackends) {
            if (this.oldFrontendType == null || this.oldFrontendType.equals("saml") || this.oldFrontendType.equals("openid")) {
                return Collections.emptyList();
            }
            NewAuthDomain newFrontendConfig = this.toNewFrontendConfig();
            if ("ldap".equalsIgnoreCase(this.oldBackendType)) {
                return this.addNewLdapBackendConfig(newFrontendConfig, userInformationBackends);
            }
            return Collections.singletonList(this.addNewBackendConfig(newFrontendConfig, userInformationBackends));
        }

        NewAuthDomain toNewFrontendConfig() {
            NewAuthDomain result = new NewAuthDomain(this.newFrontendType, this.newBackendType, this.skipUsers, this.acceptIps, null, null);
            switch (this.oldFrontendType.toLowerCase()) {
                case "basic": {
                    return result;
                }
                case "jwt": {
                    LinkedHashMap<String, Object> newConfig = new LinkedHashMap<String, Object>();
                    String signingKey = this.vNode.get("http_authenticator.config.signing_key").required().asString();
                    if (signingKey != null) {
                        byte[] decoded;
                        try {
                            decoded = Base64.getDecoder().decode(signingKey.replace("-----BEGIN PUBLIC KEY-----\n", "").replace("-----END PUBLIC KEY-----", "").trim());
                        }
                        catch (Exception e) {
                            this.validationErrors.add(new ValidationError("http_authenticator.config.signing_key", "Unsupported encoding: " + e.getMessage()).cause(e));
                            return result;
                        }
                        try {
                            OldAuthDomain.getPublicKey(decoded, "RSA");
                            newConfig.put("signing", ImmutableMap.of("rsa", ImmutableMap.of("public_key", signingKey)));
                        }
                        catch (Exception e) {
                            try {
                                OldAuthDomain.getPublicKey(decoded, "EC");
                                newConfig.put("signing", ImmutableMap.of("ec", ImmutableMap.of("public_key", signingKey)));
                            }
                            catch (Exception e2) {
                                this.validationErrors.add(new ValidationError("http_authenticator.config.signing_key", "Unsupported key").cause(e2));
                            }
                        }
                    }
                    if (this.oldFrontendConfig.hasNonNull("jwt_header")) {
                        newConfig.put("header", this.oldFrontendConfig.get("jwt_header"));
                    }
                    if (this.oldFrontendConfig.hasNonNull("jwt_url_parameter")) {
                        newConfig.put("url_parameter", this.oldFrontendConfig.get("jwt_url_parameter"));
                    }
                    if (this.oldFrontendConfig.hasNonNull("required_audience")) {
                        newConfig.put("required_audience", this.oldFrontendConfig.get("required_audience"));
                    }
                    if (this.oldFrontendConfig.hasNonNull("required_issuer")) {
                        newConfig.put("required_issuer", this.oldFrontendConfig.get("required_issuer"));
                    }
                    if (this.oldFrontendConfig.hasNonNull("subject_key")) {
                        result.userMappingUserName.put("from", "$[\"jwt\"][\"" + this.oldFrontendConfig.get("subject_key") + "\"]");
                    }
                    if (this.oldFrontendConfig.hasNonNull("subject_path")) {
                        result.userMappingUserName.put("from", OldAuthDomain.addPrefixToJsonPath("jwt", this.oldFrontendConfig.get("subject_path").toString()));
                    }
                    if (this.oldFrontendConfig.hasNonNull("roles_key")) {
                        result.userMappingRoles.put("from_comma_separated_string", "$[\"jwt\"][\"" + this.oldFrontendConfig.get("roles_key") + "\"]");
                    }
                    if (this.oldFrontendConfig.hasNonNull("roles_path")) {
                        result.userMappingRoles.put("from_comma_separated_string", OldAuthDomain.addPrefixToJsonPath("jwt", this.oldFrontendConfig.get("roles_path").toString()));
                    }
                    if (this.oldFrontendConfig.hasNonNull("map_claims_to_user_attrs")) {
                        LinkedHashMap<String, String> attrsFrom = new LinkedHashMap<String, String>();
                        for (Map.Entry entry : this.oldFrontendConfig.getAsNode("map_claims_to_user_attrs").entrySet()) {
                            attrsFrom.put((String)entry.getKey(), OldAuthDomain.addPrefixToJsonPath("jwt", entry.getValue().toString()));
                        }
                        result.userMappingAttributes.put("from", attrsFrom);
                    }
                    result.frontendConfig = newConfig;
                    return result;
                }
                case "clientcert": {
                    String userNameAttribute = this.oldFrontendConfig.getAsString("username_attribute");
                    if (userNameAttribute != null) {
                        result.userMappingUserName.put("from", "clientcert.subject." + userNameAttribute);
                    }
                    return result;
                }
                case "proxy": {
                    result.frontendType = "trusted_origin";
                    if (this.oldFrontendConfig.hasNonNull("user_header")) {
                        result.userMappingUserName.put("from", "$.request.headers[\"" + this.oldFrontendConfig.getAsString("user_header") + "\"]");
                    }
                    if (this.oldFrontendConfig.hasNonNull("roles_header")) {
                        if (this.oldFrontendConfig.hasNonNull("roles_separator")) {
                            result.userMappingRoles.put("from", ImmutableMap.of("json_path", "$.request.headers[\"" + this.oldFrontendConfig.getAsString("roles_header") + "\"]", "split", this.oldFrontendConfig.getAsString("roles_separator")));
                        } else {
                            result.userMappingRoles.put("from_comma_separated_string", "$.request.headers[\"" + this.oldFrontendConfig.getAsString("roles_header") + "\"]");
                        }
                    }
                    return result;
                }
                case "proxy2": {
                    String authMode;
                    if (this.oldFrontendConfig.hasNonNull("user_header")) {
                        result.userMappingUserName.put("from", "$.request.headers[\"" + this.oldFrontendConfig.getAsString("user_header") + "\"]");
                    }
                    if (this.oldFrontendConfig.hasNonNull("roles_header")) {
                        if (this.oldFrontendConfig.hasNonNull("roles_separator")) {
                            result.userMappingRoles.put("from", ImmutableMap.of("json_path", "$.request.headers[\"" + this.oldFrontendConfig.getAsString("roles_header") + "\"]", "split", this.oldFrontendConfig.getAsString("roles_separator")));
                        } else {
                            result.userMappingRoles.put("from_comma_separated_string", "$.request.headers[\"" + this.oldFrontendConfig.getAsString("roles_header") + "\"]");
                        }
                    }
                    switch (authMode = this.oldFrontendConfig.hasNonNull("auth_mode") ? this.oldFrontendConfig.getAsString("auth_mode").toLowerCase() : "both") {
                        case "ip": {
                            result.frontendType = "trusted_origin";
                            return result;
                        }
                        case "cert": {
                            result.frontendType = "clientcert";
                            return result;
                        }
                        case "both": 
                        case "either": {
                            this.validationErrors.add(new ValidationError("http_authenticator.config.type", "The proxy2 authenticator cannot be automatically converted when auth_mode " + authMode + " is used. Please check the documentation."));
                            return result;
                        }
                    }
                    this.validationErrors.add(new ValidationError("http_authenticator.config.auth_mode", "Invalid auth_mode " + authMode));
                    return result;
                }
                case "kerberos": {
                    LinkedHashMap<String, Object> newConfig = new LinkedHashMap<String, Object>();
                    if (this.oldFrontendConfig.hasNonNull("krb_debug")) {
                        newConfig.put("debug", this.oldFrontendConfig.get("krb_debug"));
                    }
                    if (this.oldFrontendConfig.hasNonNull("strip_realm_from_principal")) {
                        newConfig.put("strip_realm_from_principal", this.oldFrontendConfig.get("strip_realm_from_principal"));
                    }
                    newConfig.put("acceptor_keytab", "## Please move from searchguard.kerberos.acceptor_keytab_filepath in elasticsearch.yml");
                    newConfig.put("acceptor_principal", "## Please move from searchguard.kerberos.acceptor_keytab_filepath in elasticsearch.yml");
                    this.validationErrors.add(new ValidationError("http_authenticator.config", "For kerberos, you need to complete the values acceptor_keytab and acceptor_principal"));
                    result.frontendConfig = newConfig;
                    return result;
                }
            }
            this.validationErrors.add(new ValidationError("http_authenticator.type", "Unknown HTTP authenticator" + this.oldFrontendType));
            return result;
        }

        NewAuthDomain addNewBackendConfig(NewAuthDomain result, List<UserInformationBackend> userInformationBackends) {
            switch (this.oldBackendType.toLowerCase()) {
                case "intern": 
                case "internal": {
                    List<String> roleMapping;
                    result.backendType = "internal_users_db";
                    result.userInformationBackends = userInformationBackends;
                    LinkedHashMap<String, Object> newConfig = new LinkedHashMap<String, Object>();
                    if (this.oldFrontendConfig.hasNonNull("map_db_attrs_to_user_attrs")) {
                        LinkedHashMap<String, String> attrsFrom = new LinkedHashMap<String, String>();
                        for (Map.Entry entry : this.oldFrontendConfig.getAsNode("map_claims_to_user_attrs").entrySet()) {
                            attrsFrom.put((String)entry.getKey(), OldAuthDomain.addPrefixToJsonPath("user_entry.attributes", entry.getValue().toString()));
                        }
                        result.userMappingAttributes.put("from", attrsFrom);
                    }
                    result.backendConfig = newConfig;
                    if (userInformationBackends != null && userInformationBackends.size() != 0 && (roleMapping = UserInformationBackend.mergedRoleMappingFrom(userInformationBackends)).size() != 0) {
                        result.userMappingRoles.put("from", roleMapping);
                    }
                    return result;
                }
                case "noop": {
                    List<String> roleMapping;
                    result.backendType = null;
                    result.userInformationBackends = userInformationBackends;
                    if (userInformationBackends != null && userInformationBackends.size() != 0 && (roleMapping = UserInformationBackend.mergedRoleMappingFrom(userInformationBackends)).size() != 0) {
                        result.userMappingRoles.put("from", roleMapping);
                    }
                    return result;
                }
            }
            this.validationErrors.add(new ValidationError("authentication_backend.type", "Unknown authentication backend type" + this.oldBackendType));
            return result;
        }

        List<NewAuthDomain> addNewLdapBackendConfig(NewAuthDomain result, List<UserInformationBackend> userInformationBackends) {
            LinkedHashMap<String, Object> newConfig = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> idpConfig = new LinkedHashMap<String, Object>();
            boolean ssl = this.vNode.get("authentication_backend.config.enable_ssl").withDefault(false).asBoolean();
            idpConfig.put("hosts", this.oldBackendConfig.getAsListOfStrings("hosts").stream().map(s -> ssl ? (s.startsWith("ldaps://") ? s : "ldaps://" + s) : s).collect(Collectors.toList()));
            if (this.oldBackendConfig.hasNonNull("bind_dn")) {
                idpConfig.put("bind_dn", this.oldBackendConfig.getAsString("bind_dn"));
            }
            if (this.oldBackendConfig.hasNonNull("password")) {
                idpConfig.put("password", this.oldBackendConfig.getAsString("password"));
            }
            LinkedHashMap<String, Object> tlsConfig = new LinkedHashMap<String, Object>();
            boolean startTls = this.vNode.get("authentication_backend.config.enable_start_tls").withDefault(false).asBoolean();
            boolean clientAuthEnabled = this.vNode.get("authentication_backend.config.enable_ssl_client_auth").withDefault(false).asBoolean();
            boolean verifyHostnames = this.vNode.get("authentication_backend.config.verify_hostnames").withDefault(true).asBoolean();
            String pemTrustedCasFile = this.vNode.get("authentication_backend.config.pemtrustedcas_filepath").asString();
            String pemTrustedCasContent = this.vNode.get("authentication_backend.config.pemtrustedcas_content").asString();
            String clientAuthKeyFile = this.vNode.get("authentication_backend.config.pemkey_filepath").asString();
            String clientAuthKeyPassword = this.vNode.get("authentication_backend.config.pemkey_password").asString();
            String clientAuthCertFile = this.vNode.get("authentication_backend.config.pemcert_filepath").asString();
            String clientAuthKeyContent = this.vNode.get("authentication_backend.config.pemkey_content").asString();
            String clientAuthCertContent = this.vNode.get("authentication_backend.config.pemcert_content").asString();
            if (startTls) {
                tlsConfig.put("start_tls", startTls);
            }
            if (!verifyHostnames) {
                tlsConfig.put("verify_hostnames", verifyHostnames);
            }
            if (pemTrustedCasContent != null) {
                tlsConfig.put("trusted_cas", pemTrustedCasContent);
            } else if (pemTrustedCasFile != null) {
                tlsConfig.put("trusted_cas", "#{file:" + pemTrustedCasFile + "}");
            }
            if (clientAuthEnabled) {
                LinkedHashMap<String, Object> clientAuth = new LinkedHashMap<String, Object>();
                if (clientAuthKeyFile != null) {
                    clientAuth.put("private_key", "#{file:" + clientAuthKeyFile + "}");
                } else if (clientAuthKeyContent != null) {
                    clientAuth.put("private_key", clientAuthKeyFile);
                }
                if (clientAuthCertFile != null) {
                    clientAuth.put("certificate", "#{file:" + clientAuthCertFile + "}");
                } else if (clientAuthCertContent != null) {
                    clientAuth.put("certificate", clientAuthCertContent);
                }
                if (clientAuthKeyPassword != null) {
                    clientAuth.put("private_key_password", clientAuthKeyPassword);
                }
                tlsConfig.put("client_auth", clientAuth);
            }
            if (!tlsConfig.isEmpty()) {
                idpConfig.put("tls", tlsConfig);
            }
            newConfig.put("idp", idpConfig);
            LinkedHashMap<String, Object> userSearch = new LinkedHashMap<String, Object>();
            userSearch.put("base_dn", this.oldBackendConfig.getAsString("userbase"));
            if (this.oldBackendConfig.hasNonNull("usersearch")) {
                userSearch.put("filter", ImmutableMap.of("raw", this.oldBackendConfig.getAsString("usersearch").replace("{0}", "${user.name}")));
            }
            newConfig.put("user_search", userSearch);
            result.backendConfig = newConfig;
            if (this.oldBackendConfig.hasNonNull("username_attribute")) {
                result.userMappingUserName.put("from_backend", OldAuthDomain.addPrefixToJsonPath("ldap_user_entry", this.oldBackendConfig.getAsString("username_attribute")));
            }
            if (this.oldBackendConfig.hasNonNull("map_ldap_attrs_to_user_attrs")) {
                LinkedHashMap<String, String> attrsFrom = new LinkedHashMap<String, String>();
                for (Map.Entry entry : this.oldBackendConfig.getAsNode("map_ldap_attrs_to_user_attrs").entrySet()) {
                    attrsFrom.put((String)entry.getKey(), OldAuthDomain.addPrefixToJsonPath("ldap_user_entry", entry.getValue().toString()));
                }
                result.userMappingAttributes.put("from", attrsFrom);
            }
            if (this.oldBackendConfig.hasNonNull("users")) {
                return this.addNewLdapBackendConfigMultiBase(result, userInformationBackends);
            }
            if (userInformationBackends != null && userInformationBackends.size() > 0) {
                List<String> roleMapping = UserInformationBackend.mergedRoleMappingFrom(userInformationBackends);
                if (roleMapping.size() != 0) {
                    result.userMappingRoles.put("from", roleMapping);
                }
                List ldapUserInformationBackendsForMerging = userInformationBackends.stream().filter(b -> b.type.equals("ldap") && (!b.backendConfig.containsKey("user_search") || b.backendConfig.get("user_search").equals(userSearch)) && b.backendConfig.containsKey("idp") && b.backendConfig.get("idp").equals(idpConfig)).collect(Collectors.toList());
                List otherInformationBackends = userInformationBackends.stream().filter(b -> !ldapUserInformationBackendsForMerging.contains(b)).collect(Collectors.toList());
                if (ldapUserInformationBackendsForMerging.size() == 1) {
                    UserInformationBackend ldapGroupSearch = (UserInformationBackend)ldapUserInformationBackendsForMerging.get(0);
                    if (ldapGroupSearch.backendConfig.containsKey("group_search")) {
                        newConfig.put("group_search", ldapGroupSearch.backendConfig.get("group_search"));
                    }
                    result.userInformationBackends = otherInformationBackends;
                } else {
                    result.userInformationBackends = userInformationBackends;
                }
            }
            return Collections.singletonList(result);
        }

        List<NewAuthDomain> addNewLdapBackendConfigMultiBase(NewAuthDomain baseAuthDomain, List<UserInformationBackend> userInformationBackends) {
            Map<String, DocNode> users = this.oldBackendConfig.getAsNode("users").toMapOfNodes();
            ArrayList<NewAuthDomain> result = new ArrayList<NewAuthDomain>();
            for (Map.Entry<String, DocNode> entry : users.entrySet()) {
                NewAuthDomain authDomain = baseAuthDomain.clone();
                LinkedHashMap newConfig = (LinkedHashMap)Document.toDeepBasicObject(baseAuthDomain.backendConfig);
                Map userSearch = (Map)newConfig.computeIfAbsent("user_search", k -> new LinkedHashMap());
                userSearch.put("base_dn", entry.getValue().getAsString("base"));
                if (entry.getValue().hasNonNull("search")) {
                    userSearch.put("filter", ImmutableMap.of("raw", entry.getValue().getAsString("search").replace("{0}", "${user.name}")));
                }
                if (userInformationBackends != null && userInformationBackends.size() > 0) {
                    List<String> roleMapping = UserInformationBackend.mergedRoleMappingFrom(userInformationBackends);
                    if (roleMapping.size() != 0) {
                        authDomain.userMappingRoles.put("from", roleMapping);
                    }
                    List ldapUserInformationBackendsForMerging = userInformationBackends.stream().filter(b -> b.type.equals("ldap") && (!b.backendConfig.containsKey("user_search") || b.backendConfig.get("user_search").equals(userSearch)) && b.backendConfig.containsKey("idp") && b.backendConfig.get("idp").equals(baseAuthDomain.backendConfig.get("idp"))).collect(Collectors.toList());
                    List otherInformationBackends = userInformationBackends.stream().filter(b -> !ldapUserInformationBackendsForMerging.contains(b)).collect(Collectors.toList());
                    if (ldapUserInformationBackendsForMerging.size() == 1) {
                        UserInformationBackend ldapGroupSearch = (UserInformationBackend)ldapUserInformationBackendsForMerging.get(0);
                        if (ldapGroupSearch.backendConfig.containsKey("group_search")) {
                            newConfig.put("group_search", ldapGroupSearch.backendConfig.get("group_search"));
                        }
                        authDomain.userInformationBackends = otherInformationBackends;
                    } else {
                        authDomain.userInformationBackends = userInformationBackends;
                    }
                }
                authDomain.backendConfig = newConfig;
                result.add(authDomain);
            }
            return result;
        }

        private static String addPrefixToJsonPath(String prefix, String jsonPath) {
            if (jsonPath.startsWith("$.")) {
                return "$." + prefix + jsonPath.substring(1);
            }
            if (jsonPath.startsWith("$[")) {
                return "$." + prefix + jsonPath.substring(1);
            }
            return "$." + prefix + "." + jsonPath;
        }

        @Override
        public int compareTo(OldAuthDomain o) {
            return this.order - o.order;
        }

        @Override
        public Object toBasicObject() {
            return this.docNode;
        }

        private static PublicKey getPublicKey(byte[] keyBytes, String algo) throws NoSuchAlgorithmException, InvalidKeySpecException {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance(algo);
            return kf.generatePublic(spec);
        }
    }

    public static enum KibanaAuthType {
        BASICAUTH,
        JWT,
        OPENID,
        PROXY,
        KERBEROS,
        SAML;

    }
}

