/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.vars;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import picocli.CommandLine;

public abstract class AddOrUpdateConfigVar
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Name of the variable"})
    private String name;
    @CommandLine.Parameters(index="1", description={"Value of the variable"}, arity="0..1")
    private String value;
    @CommandLine.Option(names={"-n", "--numeric-value"}, description={"Numeric value of the variable"})
    private Number numericValue;
    @CommandLine.Option(names={"-i", "--input-file"}, description={"Retrieve the variable value from an external file. Files ending with .json or .yml will be parsed as such. Other files will be treated as plain text."})
    private File inputFile;
    @CommandLine.Option(names={"-e", "--encrypt"}, description={"If specified, the value will be encrypted server-side using the currently configured encryption key."})
    private boolean encrypt;
    @CommandLine.Option(names={"--scope"})
    private String scope;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            Object value = null;
            if (this.value != null) {
                value = this.value;
            } else if (this.numericValue != null) {
                value = this.numericValue;
            } else if (this.inputFile != null) {
                try {
                    Format format = Format.getByFileName(this.inputFile.getName(), null);
                    String fileContent = Files.asCharSource(this.inputFile, Charset.defaultCharset()).read();
                    if (this.verbose || this.debug) {
                        System.out.println("Uploading " + this.inputFile + " as " + (format != null ? format.getName() : "plain text"));
                    }
                    value = format != null ? DocReader.format(format).read(fileContent) : fileContent;
                }
                catch (DocumentParseException | IOException e) {
                    throw new SgctlException("Error while reading " + this.inputFile + ": " + e.getMessage(), e);
                }
            }
            if (value == null) {
                throw new SgctlException("No value specified");
            }
            BasicResponse basicResponse = client.putConfigVar(this.name, value, this.scope, this.encrypt, this.getHeaders());
            System.out.println(basicResponse.getMessage());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                if (e.getValidationErrors() != null) {
                    System.err.println(e.getValidationErrors());
                } else {
                    System.err.println(e.getMessage());
                }
                return 1;
            }
        }
    }

    protected abstract Header[] getHeaders();
}

