/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.util;

import com.google.common.base.Strings;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ClonParser {
    private static final List<Character> STRING_INDICATORS = Arrays.asList(Character.valueOf('\"'), Character.valueOf('\''));
    private static final char ASSIGN_OPERATOR = '=';
    private static final char PARENTHESIS_OPEN = '[';
    private static final char PARENTHESIS_CLOSE = ']';
    private static final char SEPARATOR = ',';

    public static Map<String, Object> parseExpressions(List<String> expressions) throws ClonException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String expression : expressions) {
            TokenIterator iterator = new TokenIterator(expression, 0, expression.length());
            if (!ClonParser.isExpression(expression)) {
                throw ClonException.Builder.getExpressionValueMixException(PartType.EXPRESSION).build(iterator);
            }
            new ExpressionReader(iterator).read(result);
        }
        return result;
    }

    public static Object parseValues(List<String> inputs) throws ClonException {
        if (inputs.size() < 2) {
            TokenIterator iterator = new TokenIterator(inputs.get(0), 0, inputs.get(0).length());
            return new ValueReader(iterator).read();
        }
        LinkedList<Object> result = new LinkedList<Object>();
        for (String input : inputs) {
            TokenIterator iterator = new TokenIterator(input, 0, input.length());
            if (ClonParser.isExpression(input)) {
                throw ClonException.Builder.getExpressionValueMixException(PartType.VALUE).build(iterator);
            }
            result.add(new ValueReader(iterator).read());
        }
        return result;
    }

    public static Object parse(List<String> inputs) throws ClonException {
        if (ClonParser.isExpression(inputs.get(0))) {
            return ClonParser.parseExpressions(inputs);
        }
        return ClonParser.parseValues(inputs);
    }

    public static Object parse(String ... inputs) throws ClonException {
        return ClonParser.parse(Arrays.asList(inputs));
    }

    public static boolean isExpression(String input) throws ClonException {
        TokenIterator iterator = new TokenIterator(input, 0, input.length());
        return TokenIterator.peekContainsOnDepth(iterator, 0, Character.valueOf('='));
    }

    private static boolean isOperationSymbol(char c) {
        return c == ',' || c == '=' || c == '[' || c == ']';
    }

    private static boolean isNameSymbol(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.';
    }

    protected static class TokenIterator {
        private final String expression;
        private final StringCharacterIterator it;
        private final Stack<Character> parenthesis = new Stack();
        private final int start;
        private final int end;

        protected TokenIterator(String expression, int start, int end) {
            this.expression = expression;
            this.it = new StringCharacterIterator(expression, start, end, start);
            this.start = start;
            this.end = end;
        }

        protected TokenIterator(TokenIterator it, int start, int end) {
            this(it.expression, start, end);
        }

        protected TokenIterator(TokenIterator other) {
            this(other, other.start, other.end);
        }

        protected static boolean peekContainsOnDepth(TokenIterator iterator, int depth, Character ... characters) throws ClonException {
            TokenIterator it = new TokenIterator(iterator);
            while (!it.isEnd()) {
                if (Arrays.asList(characters).contains(Character.valueOf(it.current())) && it.parenthesis.size() == depth) {
                    return true;
                }
                it.next();
            }
            return false;
        }

        protected static void peekParenthesisCorrect(TokenIterator iterator, PartType context) throws ClonException {
            TokenIterator it = new TokenIterator(iterator);
            while (!it.isEnd()) {
                it.next();
            }
            it.validateParenthesis(context);
        }

        protected String getCurrentExpression() {
            return this.expression.substring(this.getIndex(), this.end);
        }

        protected String getCurrentExpressionPart() {
            return this.expression.substring(this.start, this.end);
        }

        protected String getCompleteExpression() {
            return this.expression;
        }

        protected String readUntilMatch(Character ... chars) throws ClonException {
            StringBuilder builder = new StringBuilder();
            while (!Arrays.asList(chars).contains(Character.valueOf(this.it.current()))) {
                if (this.it.current() == '\uffff') {
                    throw ClonException.Builder.getCharacterNotFoundExceptionBuilder(chars).build(this);
                }
                builder.append(this.it.current());
                this.next();
            }
            return builder.toString();
        }

        protected String readUntilMatchOnSameDepth(Character ... chars) throws ClonException {
            StringBuilder builder = new StringBuilder();
            int depth = this.parenthesis.size();
            while (!Arrays.asList(chars).contains(Character.valueOf(this.it.current())) || this.parenthesis.size() != depth) {
                if (this.it.current() == '\uffff') {
                    throw ClonException.Builder.getCharacterNotFoundExceptionBuilder(chars).build(this);
                }
                builder.append(this.it.current());
                this.next();
            }
            return builder.toString();
        }

        protected String readUntilParenthesisOrIteratorEnd() throws ClonException {
            boolean capsuled;
            StringBuilder builder = new StringBuilder();
            int depth = this.parenthesis.size();
            boolean bl = capsuled = STRING_INDICATORS.contains(Character.valueOf(this.it.current())) || this.it.current() == '[';
            while (this.it.current() != '\uffff') {
                builder.append(this.it.current());
                this.next();
                if (!capsuled || depth != this.parenthesis.size()) continue;
                break;
            }
            return builder.toString();
        }

        protected String readString(PartType context) throws ClonException {
            if (STRING_INDICATORS.contains(Character.valueOf(this.it.current()))) {
                return this.readEncapsulatedString(context, Character.valueOf(this.it.current()));
            }
            StringBuilder name = new StringBuilder();
            while (!ClonParser.isOperationSymbol(this.it.current()) && !this.isEnd()) {
                if (!ClonParser.isNameSymbol(this.it.current())) {
                    throw ClonException.Builder.getUnsupportedSymbolExceptionBuilder(Character.valueOf(this.it.current())).build(this);
                }
                name.append(this.it.current());
                this.next();
            }
            if (name.toString().isEmpty()) {
                throw ClonException.Builder.getNameEmptyExceptionBuilder(context).build(this);
            }
            return name.toString();
        }

        private String readEncapsulatedString(PartType context, Character parenthesis) throws ClonException {
            this.readCharacter(parenthesis);
            StringBuilder name = new StringBuilder();
            while (this.it.current() != parenthesis.charValue()) {
                if (this.isEnd()) {
                    throw ClonException.Builder.getParenthesisOpenExceptionBuilder().build(this);
                }
                name.append(this.it.current());
                this.next();
            }
            this.readCharacter(parenthesis);
            if (name.toString().isEmpty() && context != PartType.VALUE) {
                throw ClonException.Builder.getNameEmptyExceptionBuilder(context).build(this);
            }
            return name.toString();
        }

        protected String readNotEncapsulated() throws ClonException {
            StringBuilder name = new StringBuilder();
            while (!ClonParser.isOperationSymbol(this.it.current()) && !this.isEnd()) {
                name.append(this.it.current());
                this.next();
            }
            return name.toString();
        }

        protected boolean inString() {
            return !this.parenthesis.empty() && STRING_INDICATORS.contains(this.parenthesis.peek());
        }

        protected char current() {
            return this.it.current();
        }

        protected Character readCharacter(Character ... expectedCurrent) throws ClonException {
            if (!Arrays.asList(expectedCurrent).contains(Character.valueOf(this.it.current()))) {
                throw ClonException.Builder.getUnexpectedCharacterExceptionBuilder(expectedCurrent).build(this);
            }
            Character current = Character.valueOf(this.it.current());
            this.next();
            return current;
        }

        protected char next() throws ClonException {
            if (STRING_INDICATORS.contains(Character.valueOf(this.it.current()))) {
                if (this.inString() && this.it.current() == this.parenthesis.peek().charValue()) {
                    this.parenthesis.pop();
                } else if (!this.inString()) {
                    this.parenthesis.push(Character.valueOf(this.it.current()));
                }
            }
            if (!this.inString()) {
                if (this.it.current() == '[') {
                    this.parenthesis.push(Character.valueOf(this.it.current()));
                } else if (this.it.current() == ']') {
                    if (!this.parenthesis.empty()) {
                        this.parenthesis.pop();
                    } else {
                        throw ClonException.Builder.getParenthesisCloseExceptionBuilder().build(this);
                    }
                }
            }
            return this.it.next();
        }

        protected int getIndex() {
            return this.it.getIndex();
        }

        protected boolean isEnd() {
            return this.it.current() == '\uffff';
        }

        protected void validateNotEmpty(PartType context) throws ClonException {
            if (Strings.isNullOrEmpty(this.getCurrentExpression())) {
                throw ClonException.Builder.getEmptyExceptionBuilder(context).build(this);
            }
        }

        protected void validateEnd() throws ClonException {
            if (!this.isEnd()) {
                throw ClonException.Builder.getNotEndExceptionBuilder().build(this);
            }
        }

        protected void validateParenthesis(PartType context) throws ClonException {
            if (!this.parenthesis.empty()) {
                throw (STRING_INDICATORS.contains(this.parenthesis.peek()) ? ClonException.Builder.getNoStringEndExceptionBuilder() : ClonException.Builder.getParenthesisOpenExceptionBuilder()).build(this);
            }
        }

        protected void validateEndAndParenthesis(PartType context) throws ClonException {
            this.validateEnd();
            this.validateParenthesis(context);
        }
    }

    protected static enum PartType {
        KEY,
        VALUE,
        EXPRESSION;

    }

    public static class ClonException
    extends Exception {
        private static final long serialVersionUID = -821669828214088092L;

        private ClonException(String message) {
            super(message);
        }

        protected static class Builder {
            String message;
            String expression;
            String part;
            int errorIndex;
            int partStartIndex;

            protected Builder() {
            }

            protected ClonException build(TokenIterator iterator) {
                this.expression = iterator.getCompleteExpression();
                this.part = iterator.getCurrentExpressionPart();
                this.errorIndex = iterator.getIndex();
                this.partStartIndex = iterator.start;
                return this.build();
            }

            protected ClonException build() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.message).append("\n");
                builder.append(this.expression).append("\n");
                char[] spaces = new char[this.partStartIndex];
                Arrays.fill(spaces, ' ');
                builder.append(spaces).append(this.part).append("\n");
                spaces = new char[this.errorIndex];
                Arrays.fill(spaces, ' ');
                builder.append(spaces).append('^');
                return new ClonException(builder.toString());
            }

            protected Builder setMessage(String message) {
                this.message = message;
                return this;
            }

            protected Builder setExpression(String expression) {
                this.expression = expression;
                return this;
            }

            protected Builder setPart(String part) {
                this.part = part;
                return this;
            }

            protected Builder setErrorIndex(int errorIndex) {
                this.errorIndex = errorIndex;
                return this;
            }

            protected Builder setPartStartIndex(int partStartIndex) {
                this.partStartIndex = partStartIndex;
                return this;
            }

            public static Builder getUnexpectedCharacterExceptionBuilder(Character ... expected) {
                return new Builder().setMessage("Expected '" + Arrays.toString((Object[])expected) + "'");
            }

            public static Builder getNotEndExceptionBuilder() {
                return new Builder().setMessage("Expected expression to end");
            }

            public static Builder getCharacterNotFoundExceptionBuilder(Character ... expected) {
                return new Builder().setMessage("Expected " + Arrays.toString((Object[])expected));
            }

            public static Builder getParenthesisOpenExceptionBuilder() {
                return new Builder().setMessage("Expected ']'");
            }

            public static Builder getParenthesisCloseExceptionBuilder() {
                return new Builder().setMessage("Unexpected ']'");
            }

            public static Builder getNoStringEndExceptionBuilder() {
                return new Builder().setMessage("Expected string or key name to end");
            }

            public static Builder getEmptyExceptionBuilder(PartType context) {
                return new Builder().setMessage((String)(context != PartType.VALUE ? context + " can not be empty" : "Empty string value must be surrounded by ' or \""));
            }

            public static Builder getUnsupportedSymbolExceptionBuilder(Character c) {
                return new Builder().setMessage("Unsupported symbol '" + c + "'. Consider using quotes");
            }

            public static Builder getNameEmptyExceptionBuilder(PartType context) {
                return new Builder().setMessage(context == PartType.KEY ? "Key names can not be empty" : "String values can not be empty");
            }

            public static Builder getOverrideExceptionBuilder(String key) {
                return new Builder().setMessage("Can not override field '" + key + "'");
            }

            public static Builder getExpressionValueMixException(PartType context) {
                return new Builder().setMessage("Expected input to be " + context.name() + "s only");
            }
        }
    }

    private static class ExpressionReader {
        private final TokenIterator it;

        private ExpressionReader(TokenIterator it) {
            this.it = it;
        }

        public Map<String, Object> read(Map<String, Object> map) throws ClonException {
            this.it.validateNotEmpty(PartType.EXPRESSION);
            int keyStart = this.it.getIndex();
            this.it.readUntilMatch(Character.valueOf('='));
            int keyEnd = this.it.getIndex();
            TokenIterator keyIterator = new TokenIterator(this.it, keyStart, keyEnd);
            KeyReader.ValueApplier applier = new KeyReader(keyIterator).read(map);
            this.it.readCharacter(Character.valueOf('='));
            int valueStart = this.it.getIndex();
            this.it.readUntilParenthesisOrIteratorEnd();
            int valueEnd = this.it.getIndex();
            TokenIterator valueIterator = new TokenIterator(this.it, valueStart, valueEnd);
            Object value = new ValueReader(valueIterator).read();
            this.it.validateEndAndParenthesis(PartType.EXPRESSION);
            applier.apply(value);
            return map;
        }
    }

    private static class ValueReader {
        private final TokenIterator it;

        public ValueReader(TokenIterator it) {
            this.it = it;
        }

        public Object read() throws ClonException {
            Object result;
            this.it.validateNotEmpty(PartType.VALUE);
            TokenIterator.peekParenthesisCorrect(this.it, PartType.VALUE);
            String expression = this.it.getCurrentExpression();
            if (expression.charAt(0) == '[') {
                if (expression.charAt(1) == ']') {
                    throw ClonException.Builder.getEmptyExceptionBuilder(PartType.VALUE).build(this.it);
                }
                result = TokenIterator.peekContainsOnDepth(this.it, 1, Character.valueOf('=')) ? this.readObject() : this.readArray();
            } else {
                result = this.isLong() ? this.readLong() : (this.isDouble() ? this.readDouble() : ("true".equals(expression) || "false".equals(expression) ? this.readBoolean() : ("null".equals(expression) ? this.readNull() : this.readString(PartType.VALUE))));
            }
            this.it.validateEndAndParenthesis(PartType.VALUE);
            return result;
        }

        private boolean isLong() {
            try {
                Long.valueOf(this.it.getCurrentExpression());
                return true;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }

        private boolean isDouble() {
            try {
                Double.valueOf(this.it.getCurrentExpression());
                return true;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }

        private Object readLong() throws ClonException {
            return Long.valueOf(this.it.readNotEncapsulated());
        }

        private Object readDouble() throws ClonException {
            return Double.valueOf(this.it.readNotEncapsulated());
        }

        private Object readBoolean() throws ClonException {
            return "true".equals(this.it.readNotEncapsulated()) ? Boolean.TRUE : Boolean.FALSE;
        }

        private Object readNull() throws ClonException {
            this.it.readNotEncapsulated();
            return null;
        }

        private Object readString(PartType context) throws ClonException {
            return this.it.readString(context);
        }

        private Object readArray() throws ClonException {
            this.it.readCharacter(Character.valueOf('['));
            ArrayList<Object> values = new ArrayList<Object>();
            while (this.it.current() != ']') {
                int valueStart = this.it.getIndex();
                this.it.readUntilMatchOnSameDepth(Character.valueOf(','), Character.valueOf(']'));
                int valueEnd = this.it.getIndex();
                ValueReader reader = new ValueReader(new TokenIterator(this.it, valueStart, valueEnd));
                values.add(reader.read());
                if (this.it.current() == ']') continue;
                this.it.readCharacter(Character.valueOf(','));
                if (this.it.current() != ']') continue;
                throw ClonException.Builder.getEmptyExceptionBuilder(PartType.VALUE).build(this.it);
            }
            this.it.readCharacter(Character.valueOf(']'));
            return values;
        }

        private Object readObject() throws ClonException {
            this.it.readCharacter(Character.valueOf('['));
            LinkedHashMap<String, Object> objectMap = new LinkedHashMap<String, Object>();
            while (this.it.current() != ']') {
                int expressionStart = this.it.getIndex();
                this.it.readUntilMatchOnSameDepth(Character.valueOf(','), Character.valueOf(']'));
                int expressionEnd = this.it.getIndex();
                ExpressionReader reader = new ExpressionReader(new TokenIterator(this.it, expressionStart, expressionEnd));
                reader.read(objectMap);
                if (this.it.current() == ']') continue;
                this.it.readCharacter(Character.valueOf(','));
                if (this.it.current() != ']') continue;
                throw ClonException.Builder.getEmptyExceptionBuilder(PartType.VALUE).build(this.it);
            }
            this.it.readCharacter(Character.valueOf(']'));
            return objectMap;
        }
    }

    private static class KeyReader {
        private final TokenIterator it;

        public KeyReader(TokenIterator it) {
            this.it = it;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ValueApplier read(Map<String, Object> map) throws ClonException {
            ValueApplier applier;
            this.it.validateNotEmpty(PartType.KEY);
            TokenIterator.peekParenthesisCorrect(this.it, PartType.KEY);
            String key = this.it.readString(PartType.KEY);
            if (this.it.current() == '\uffff') {
                if (map.containsKey(key)) {
                    throw ClonException.Builder.getOverrideExceptionBuilder(key).build(this.it);
                }
                applier = new ValueApplier(key, map);
            } else {
                this.it.readCharacter(Character.valueOf('['));
                if (this.it.current() == ']') {
                    if (!map.containsKey(key)) {
                        ArrayList<Object> array = new ArrayList<Object>();
                        map.put(key, array);
                        applier = new ValueApplier(key, array);
                    } else {
                        if (!(map.get(key) instanceof List)) throw ClonException.Builder.getOverrideExceptionBuilder(key).build(this.it);
                        applier = new ValueApplier(key, (List)map.get(key));
                    }
                } else {
                    int innerKeyStart = this.it.getIndex();
                    this.it.readUntilMatchOnSameDepth(Character.valueOf(']'));
                    int innerKeyEnd = this.it.getIndex();
                    TokenIterator innerKeyIterator = new TokenIterator(this.it, innerKeyStart, innerKeyEnd);
                    if (!map.containsKey(key)) {
                        LinkedHashMap<String, Object> innerMap = new LinkedHashMap<String, Object>();
                        map.put(key, innerMap);
                        applier = new KeyReader(innerKeyIterator).read(innerMap);
                    } else {
                        if (!(map.get(key) instanceof Map)) throw ClonException.Builder.getOverrideExceptionBuilder(key).build(this.it);
                        applier = new KeyReader(innerKeyIterator).read((Map)map.get(key));
                    }
                }
                this.it.readCharacter(Character.valueOf(']'));
            }
            this.it.validateEndAndParenthesis(PartType.KEY);
            return applier;
        }

        private static class ValueApplier {
            private final String key;
            private final List<Object> list;
            private final Map<String, Object> map;

            public ValueApplier(String key, Map<String, Object> map) {
                this.key = key;
                this.list = null;
                this.map = map;
            }

            public ValueApplier(String key, List<Object> list) {
                this.key = key;
                this.list = list;
                this.map = null;
            }

            public void apply(Object object) throws ClonException {
                if (this.list != null) {
                    this.list.add(object);
                } else if (this.map != null) {
                    this.map.put(this.key, object);
                } else {
                    throw new ClonException("Could not resolve object tree");
                }
            }
        }
    }
}

