/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="component-state", description={"Retrieves Search Guard compontent status information"})
public class ComponentState
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="0..1")
    String component;

    @Override
    public Integer call() throws Exception {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            if (this.debug || this.verbose) {
                System.out.println("Retrieving Search Guard component state for " + this.component);
            }
            BasicResponse response = client.getComponentState(this.component, false);
            System.out.println(response.toYamlString());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (InvalidResponseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (FailedConnectionException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ServiceUnavailableException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
    }
}

