/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.user;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="add-user", description={"Adds a new user"})
public class AddUser
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", description={"User name"})
    private String userName;
    @CommandLine.Option(names={"-r", "--sg-roles"}, split=",")
    private List<String> sgRoles;
    @CommandLine.Option(names={"--backend-roles"}, split=",")
    private List<String> backendRoles;
    @CommandLine.Option(names={"-a", "--attributes"}, split=",")
    private Map<String, Object> attributes;
    @CommandLine.Option(names={"--password"}, arity="0..1", description={"Passphrase"}, interactive=true, required=true)
    String password;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            this.sgRoles = Optional.ofNullable(this.sgRoles).orElse(Collections.emptyList());
            this.backendRoles = Optional.ofNullable(this.backendRoles).orElse(Collections.emptyList());
            this.attributes = Optional.ofNullable(this.attributes).orElse(Collections.emptyMap());
            HashMap<String, Object> newUserData = new HashMap<String, Object>();
            newUserData.put("search_guard_roles", this.sgRoles);
            newUserData.put("backend_roles", this.backendRoles);
            newUserData.put("attributes", this.attributes);
            newUserData.put("password", this.password);
            if (this.verbose || this.debug) {
                System.out.println("Adding a new user: " + this.userName + ", with SG roles: " + String.join((CharSequence)",", this.sgRoles) + ", with backend roles: " + String.join((CharSequence)",", this.backendRoles) + ", with attributes: " + this.attributes.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + entry.getValue()).collect(Collectors.joining(",")));
            }
            BasicResponse basicResponse = client.putUser(this.userName, newUserData);
            System.out.println(basicResponse.getMessage());
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                if (e.getValidationErrors() != null) {
                    System.err.println(e.getValidationErrors());
                } else {
                    System.err.println(e.getMessage());
                }
                return 1;
            }
        }
    }
}

