/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.user;

import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="delete-user", description={"Deletes a user"})
public class DeleteUser
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", description={"User name"})
    private String userName;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            if (this.verbose || this.debug) {
                System.out.println("Deleting a user: " + this.userName);
            }
            BasicResponse basicResponse = client.deleteUser(this.userName);
            System.out.println(Optional.ofNullable(basicResponse.getMessage()).orElse("User " + this.userName + " has been deleted"));
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                if (e.getValidationErrors() != null) {
                    System.err.println(e.getValidationErrors());
                } else {
                    System.err.println(e.getMessage());
                }
                return 1;
            }
        }
    }
}

