/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.util;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YamlRewriter {
    private static final Logger log = Logger.getLogger(YamlRewriter.class.getName());
    private String source;
    private String sourceFileName;
    private ValidatingDocNode sourceDoc;
    private ValidationErrors sourceDocValidationErrors = new ValidationErrors();
    private List<Insertion> insertionsAtBeginning = new ArrayList<Insertion>();
    private Map<String, List<Insertion>> insertionsAfter = new LinkedHashMap<String, List<Insertion>>();
    private Map<String, List<Insertion>> insertionsBefore = new LinkedHashMap<String, List<Insertion>>();
    private List<String> removals = new ArrayList<String>();

    public YamlRewriter(File sourceFile) throws IOException, DocumentParseException, UnexpectedDocumentStructureException {
        this.source = new String(Files.readAllBytes(sourceFile.toPath()), Charsets.UTF_8);
        this.sourceDoc = new ValidatingDocNode(DocReader.yaml().readObject(this.source), this.sourceDocValidationErrors);
        this.sourceFileName = sourceFile.getName();
    }

    public void insertAtBeginning(Insertion insertion) {
        this.insertionsAtBeginning.add(insertion);
    }

    public void insertAfter(String existingAttribute, Insertion insertion) {
        this.insertionsAfter.computeIfAbsent(existingAttribute, k -> new ArrayList()).add(insertion);
    }

    public void insertBefore(String existingAttribute, Insertion insertion) {
        this.insertionsBefore.computeIfAbsent(existingAttribute, k -> new ArrayList()).add(insertion);
    }

    public void remove(String existingAttribute) {
        if (this.sourceDoc.hasNonNull(existingAttribute)) {
            this.removals.add(existingAttribute);
        }
    }

    public RewriteResult rewrite() throws RewriteException {
        Matcher matcher;
        Pattern attributePattern;
        List insertions;
        String attribute;
        int newLine;
        if (this.insertionsAtBeginning.isEmpty() && this.insertionsAfter.isEmpty() && this.insertionsBefore.isEmpty() && this.removals.isEmpty()) {
            return new RewriteResult(this.source, false);
        }
        Object prolog = "";
        Object current = this.source;
        while (((String)current).startsWith("#")) {
            newLine = ((String)current).indexOf(10);
            prolog = (String)prolog + ((String)current).substring(0, newLine + 1);
            current = ((String)current).substring(newLine + 1);
        }
        if (((String)current).startsWith("---")) {
            newLine = ((String)current).indexOf(10);
            prolog = (String)prolog + ((String)current).substring(0, newLine + 1);
            current = ((String)current).substring(newLine + 1);
        }
        for (Insertion insertion : this.insertionsAtBeginning) {
            current = insertion + "\n" + (String)current;
        }
        for (Map.Entry entry : this.insertionsAfter.entrySet()) {
            attribute = (String)entry.getKey();
            insertions = (List)entry.getValue();
            attributePattern = Pattern.compile("^" + Pattern.quote(attribute) + "\\s*:\\s*[^\\s]+.*$");
            Collections.reverse(insertions);
            for (Insertion insertion : insertions) {
                matcher = attributePattern.matcher((CharSequence)current);
                if (matcher.find()) {
                    int end = matcher.end();
                    current = ((String)current).substring(0, end) + "\n" + insertion + ((String)current).substring(end);
                    continue;
                }
                current = (String)current + "\n" + insertion;
            }
        }
        for (Map.Entry entry : this.insertionsBefore.entrySet()) {
            attribute = (String)entry.getKey();
            insertions = (List)entry.getValue();
            attributePattern = Pattern.compile("^" + Pattern.quote(attribute) + "\\s*:\\s*[^\\s]+.*$");
            for (Insertion insertion : insertions) {
                matcher = attributePattern.matcher((CharSequence)current);
                if (matcher.find()) {
                    int start = matcher.start();
                    current = ((String)current).substring(0, start) + insertion + "\n" + ((String)current).substring(start);
                    continue;
                }
                current = (String)current + "\n" + insertion;
            }
        }
        for (String string : this.removals) {
            Pattern attributePattern2 = Pattern.compile("^" + Pattern.quote(string) + "\\s*:\\s*[^\\s]+.*$", 8);
            Matcher matcher2 = attributePattern2.matcher((CharSequence)current);
            if (!matcher2.find()) continue;
            current = ((String)current).substring(0, matcher2.start()) + ((String)current).substring(matcher2.end());
        }
        if (((String)prolog).length() > 0) {
            current = (String)prolog + (String)current;
        }
        try {
            System.out.println("############\n" + (String)current + "\n##########");
            boolean changed = this.verify((String)current);
            return new RewriteResult((String)current, changed);
        }
        catch (VerificationException e) {
            e.printStackTrace();
            log.log(Level.FINE, "Verification failed", e);
            throw new RewriteException((Throwable)e);
        }
    }

    public String getManualInstructions() {
        StringBuilder insertions = new StringBuilder();
        for (Insertion insertion : this.insertionsAtBeginning) {
            insertions.append(insertion).append("\n");
        }
        insertions.append("\n");
        for (Map.Entry entry : this.insertionsAfter.entrySet()) {
            for (Insertion insertion : (List)entry.getValue()) {
                insertions.append(insertion).append("\n");
            }
            insertions.append("\n");
        }
        for (Map.Entry entry : this.insertionsBefore.entrySet()) {
            for (Insertion insertion : (List)entry.getValue()) {
                insertions.append(insertion).append("\n");
            }
            insertions.append("\n");
        }
        StringBuilder removals = new StringBuilder();
        for (String removal : this.removals) {
            removals.append(removal).append("\n");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (insertions.toString().trim().length() > 0) {
            stringBuilder.append("Please insert these attributes:\n\n").append((CharSequence)insertions).append("\n");
        }
        if (removals.length() > 0) {
            stringBuilder.append("Please remove these attributes:\n\n").append((CharSequence)removals);
        }
        return stringBuilder.toString();
    }

    private boolean verify(String result) throws VerificationException {
        Map originalTree;
        Map tree2;
        Map<String, Object> tree1 = this.applyChangesToTree();
        try {
            tree2 = DocReader.yaml().readObject(result);
        }
        catch (DocumentParseException | UnexpectedDocumentStructureException e) {
            throw new VerificationException("Error while parsing rewritten file", e);
        }
        this.ensureEquality(tree1, tree2);
        try {
            originalTree = DocReader.yaml().readObject(this.source);
        }
        catch (DocumentParseException | UnexpectedDocumentStructureException e) {
            throw new VerificationException("Error while parsing source file", e);
        }
        return !this.areEqual(tree2, originalTree);
    }

    private void ensureEquality(Map<?, ?> tree1, Map<?, ?> tree2) throws VerificationException {
        if (tree1.size() != tree2.size()) {
            throw new VerificationException("Trees do not match:\n" + tree1 + "\n" + tree2);
        }
        for (Object key : tree1.keySet()) {
            Object object1 = tree1.get(key);
            Object object2 = tree2.get(key);
            if (object1 == null && object2 == null) continue;
            if (object1 == null || object2 == null) {
                throw new VerificationException("Trees do not match at " + key + ":\n" + tree1 + "\n" + tree2);
            }
            if (object1 instanceof Map) {
                if (object2 instanceof Map) {
                    this.ensureEquality((Map)object1, (Map)object2);
                    continue;
                }
                throw new VerificationException("Trees do not match at " + key + ":\n" + tree1 + "\n" + tree2);
            }
            if (object1.equals(object2)) continue;
            throw new VerificationException("Trees do not match at " + key + ":\n" + tree1 + "\n" + tree2);
        }
    }

    private boolean areEqual(Map<?, ?> tree1, Map<?, ?> tree2) {
        if (tree1.size() != tree2.size()) {
            return false;
        }
        for (Object key : tree1.keySet()) {
            Object object1 = tree1.get(key);
            Object object2 = tree2.get(key);
            if (object1 == null && object2 == null) continue;
            if (object1 == null || object2 == null) {
                return false;
            }
            if (object1 instanceof Map) {
                if (object2 instanceof Map) {
                    this.areEqual((Map)object1, (Map)object2);
                    continue;
                }
                return false;
            }
            if (object1.equals(object2)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Object> applyChangesToTree() throws VerificationException {
        try {
            Map tree = DocReader.yaml().readObject(this.source);
            this.applyChangesToTree(this.insertionsAtBeginning, tree);
            for (Map.Entry<String, List<Insertion>> entry : this.insertionsAfter.entrySet()) {
                this.applyChangesToTree(entry.getValue(), tree);
            }
            for (Map.Entry<String, List<Insertion>> entry : this.insertionsBefore.entrySet()) {
                this.applyChangesToTree(entry.getValue(), tree);
            }
            for (String removal : this.removals) {
                this.remove(removal, tree);
            }
            return tree;
        }
        catch (DocumentParseException | UnexpectedDocumentStructureException e) {
            throw new VerificationException("Error while parsing source file", e);
        }
    }

    private void applyChangesToTree(List<Insertion> insertions, Map<String, Object> tree) throws VerificationException {
        for (Insertion insertion : insertions) {
            if (!(insertion instanceof Attribute)) continue;
            this.set((Attribute)insertion, tree);
        }
    }

    private void set(Attribute attributeInsertion, Map<String, Object> tree) throws VerificationException {
        tree.put(attributeInsertion.key, attributeInsertion.value);
    }

    private void remove(String key, Map<String, Object> tree) throws VerificationException {
        tree.remove(key);
        String[] path = key.split("\\.");
        Map<String, Object> parent = this.getParent(path, tree);
        parent.remove(path[path.length - 1]);
        if (parent.isEmpty() && path.length > 1) {
            this.remove(key.substring(0, key.lastIndexOf(46)), tree);
        }
    }

    private Map<String, Object> getParent(String[] path, Map<String, Object> tree) throws VerificationException {
        if (path.length == 1) {
            return tree;
        }
        for (int i = 0; i < path.length - 1; ++i) {
            Object element = tree.get(path[i]);
            if (element instanceof Map) {
                tree = (LinkedHashMap)element;
                continue;
            }
            if (element == null) {
                LinkedHashMap newContainer = new LinkedHashMap();
                tree.put(path[i], newContainer);
                tree = newContainer;
                continue;
            }
            throw new VerificationException("Part of path is not a map: " + element + "; " + Arrays.asList(path));
        }
        return tree;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public static class RewriteResult {
        private final String yaml;
        private final boolean changed;

        RewriteResult(String yaml, boolean changed) {
            this.yaml = yaml;
            this.changed = changed;
        }

        public String getYaml() {
            return this.yaml;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    public static abstract class Insertion {
    }

    static class VerificationException
    extends Exception {
        private static final long serialVersionUID = 180827181611113288L;

        private VerificationException(String message, Throwable cause) {
            super(message, cause);
        }

        private VerificationException(String message) {
            super(message);
        }

        private VerificationException(Throwable cause) {
            super(cause);
        }
    }

    public class RewriteException
    extends Exception {
        private static final long serialVersionUID = 4693406547037756777L;

        private RewriteException() {
        }

        private RewriteException(String message, Throwable cause) {
            super(message, cause);
        }

        private RewriteException(String message) {
            super(message);
        }

        private RewriteException(Throwable cause) {
            super(cause);
        }

        public String getManualInstructions() {
            return YamlRewriter.this.getManualInstructions();
        }
    }

    public static class Attribute
    extends Insertion {
        private final String key;
        private final Object value;

        public Attribute(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + ": " + DocWriter.json().writeAsString(this.value);
        }
    }

    public static class Comment
    extends Insertion {
        private final String comment;

        public Comment(String comment) {
            this.comment = comment;
        }

        public String toString() {
            return "# " + this.comment.replaceAll("\n", "\n# ");
        }
    }
}

