/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.BasicResponse;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.floragunn.searchguard.sgctl.commands.ConnectingCommand;
import com.floragunn.searchguard.sgctl.util.ClonParser;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import picocli.CommandLine;

@CommandLine.Command(name="rest", description={"REST client for administration"})
public class RestCommand
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", description={"http method"})
    SupportedHttpMethods httpMethod;
    @CommandLine.Parameters(index="1", arity="1", description={"Endpoint path"})
    String endpoint;
    @CommandLine.Option(names={"-i", "--input"}, description={"Path to a file"})
    File inputFilePath;
    @CommandLine.Option(names={"--json"}, description={"JavaScript Object Notation string"})
    String jsonString;
    @CommandLine.Option(names={"--clon"}, arity="1..*", description={"Command Line Object Notation string"})
    List<String> clonExpressions;
    @CommandLine.Option(names={"-o", "--output"}, description={"Custom output file path"})
    File outputFilePath;

    @Override
    public Integer call() {
        SearchGuardRestClient client = this.getClient().debug(this.debug);
        try {
            BasicResponse basicResponse = this.httpMethod.handle(client, this.endpoint, this.jsonString, this.inputFilePath, this.clonExpressions);
            System.out.println(basicResponse.toString());
            RestCommand.handleFileOutput(this.outputFilePath, basicResponse);
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SgctlException | ApiException | FailedConnectionException | InvalidResponseException | ServiceUnavailableException | UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
    }

    private static void handleFileOutput(File outputFilePath, BasicResponse response) throws SgctlException {
        if (outputFilePath == null) {
            return;
        }
        String fileSuffix = "text/plain".equals(response.getContentType()) ? "txt" : "json";
        String fileContent = "text/plain".equals(response.getContentType()) ? response.toString() : response.toPrettyJsonString();
        File file = outputFilePath;
        if (outputFilePath.isDirectory()) {
            file = new File(outputFilePath, "response-" + new SimpleDateFormat("yyyy-MM-dd--HH-mm").format(new Date()) + "." + fileSuffix);
        }
        try {
            Files.asCharSink(file, Charset.defaultCharset(), new FileWriteMode[0]).write(fileContent);
        }
        catch (IOException e) {
            throw new SgctlException("Error while writing output to " + file.getPath() + ": " + String.valueOf(e), e);
        }
    }

    private static enum SupportedHttpMethods {
        GET("get", Input::validateEmpty, (client, endpoint, evaluatedInput) -> client.get(endpoint)),
        PUT("put", input -> input.validateExistent().validateNoDuplicate(), (client, endpoint, evaluatedInput) -> client.put(endpoint, evaluatedInput.getContent(), evaluatedInput.getContentType(), new Header[0])),
        DELETE("delete", Input::validateEmpty, (client, endpoint, evaluatedInput) -> client.delete(endpoint)),
        POST("post", Input::validateNoDuplicate, (client, endpoint, evaluatedInput) -> evaluatedInput == null ? client.post(endpoint) : client.post(endpoint, evaluatedInput.getContent(), evaluatedInput.getContentType())),
        PATCH("patch", input -> input.validateExistent().validateNoDuplicate(), (client, endpoint, evaluatedInput) -> client.patch(endpoint, evaluatedInput.getContent(), evaluatedInput.getContentType(), new Header[0]));

        private final String name;
        private final InputValidator validator;
        private final SupportedHttpMethodHandler handler;

        private SupportedHttpMethods(String name, InputValidator validator, SupportedHttpMethodHandler handler) {
            this.name = name;
            this.validator = validator;
            this.handler = handler;
        }

        public String toString() {
            return this.name;
        }

        public BasicResponse handle(SearchGuardRestClient client, String endpoint, String jsonString, File inputFilePath, List<String> clonExpressions) throws SgctlException, FailedConnectionException, InvalidResponseException, UnauthorizedException, ServiceUnavailableException, ApiException {
            Input input = Input.create(jsonString, inputFilePath, clonExpressions);
            SearchGuardRestClient.Response response = this.handler.handle(client, endpoint, this.validator.validate(input).evaluate());
            return response.parseResponseBy(BasicResponse::new);
        }

        static interface InputValidator {
            public Input validate(Input var1) throws SgctlException;
        }

        static interface SupportedHttpMethodHandler {
            public SearchGuardRestClient.Response handle(SearchGuardRestClient var1, String var2, Input.EvaluatedInput var3) throws SgctlException, FailedConnectionException, InvalidResponseException;
        }

        private static class Input {
            private String jsonString;
            private File inputFilePath;
            private List<String> clonExpressions;

            public static Input create(String jsonString, File inputFilePath, List<String> clonExpressions) {
                return new Input(jsonString, inputFilePath, clonExpressions);
            }

            private Input(String jsonString, File inputFilePath, List<String> clonExpressions) {
                this.jsonString = jsonString;
                this.inputFilePath = inputFilePath;
                this.clonExpressions = clonExpressions;
            }

            public Input validateEmpty() throws SgctlException {
                if (!this.isEmpty()) {
                    System.err.println("No input required for this HTTP method. Input is ignored");
                }
                this.jsonString = null;
                this.inputFilePath = null;
                this.clonExpressions = null;
                return this;
            }

            public Input validateNoDuplicate() throws SgctlException {
                if (this.jsonString != null && this.inputFilePath != null || this.inputFilePath != null && this.clonExpressions != null || this.clonExpressions != null && this.jsonString != null) {
                    throw new SgctlException("Only one input required. Choose '--json', '--input' or '--clon'");
                }
                return this;
            }

            public Input validateExistent() throws SgctlException {
                if (this.jsonString == null && this.inputFilePath == null && this.clonExpressions == null) {
                    throw new SgctlException("This HTTP method requires an input. Use '--json', '--input' or '--clon' to define an input");
                }
                return this;
            }

            public boolean isEmpty() {
                return this.jsonString == null && this.inputFilePath == null && this.clonExpressions == null;
            }

            public EvaluatedInput evaluate() throws SgctlException {
                if (this.isEmpty()) {
                    return null;
                }
                try {
                    Format format;
                    Format format2 = format = this.jsonString != null || this.clonExpressions != null ? Format.JSON : Format.getByFileName(this.inputFilePath.getName());
                    Map<String, Object> content = this.clonExpressions != null ? ClonParser.parse(this.clonExpressions) : (this.jsonString != null ? DocReader.format(format).read(this.jsonString) : DocReader.format(format).readObject(this.inputFilePath));
                    return new EvaluatedInput(DocWriter.format(format).writeAsString(content), ContentType.create(format.getMediaType()));
                }
                catch (DocumentParseException | Format.UnknownDocTypeException | UnexpectedDocumentStructureException | IOException e) {
                    throw new SgctlException((String)(this.jsonString != null ? "JSON input is invalid" : "Could not read file from path '" + String.valueOf(this.inputFilePath) + "' ") + "\n" + String.valueOf(e), e);
                }
                catch (ClonParser.ClonException e) {
                    throw new SgctlException("CLON input invalid: " + String.valueOf(e), e);
                }
            }

            private static class EvaluatedInput {
                private final String content;
                private final ContentType contentType;

                protected EvaluatedInput(String contentString, ContentType contentType) {
                    this.content = contentString;
                    this.contentType = contentType;
                }

                public String getContent() {
                    return this.content;
                }

                public ContentType getContentType() {
                    return this.contentType;
                }
            }
        }
    }
}

