/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands.user;

import com.floragunn.codova.documents.DocWriter;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import picocli.CommandLine;

@CommandLine.Command(name="add-user-local", description={"Adds a new user to a local sg_internal_users.yml file"})
public class AddUserLocal
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="1", description={"User name"})
    private String userName;
    @CommandLine.Option(names={"-r", "--sg-roles"}, split=",")
    private List<String> sgRoles;
    @CommandLine.Option(names={"--backend-roles"}, split=",")
    private List<String> backendRoles;
    @CommandLine.Option(names={"-a", "--attributes"}, split=",")
    private Map<String, Object> attributes;
    @CommandLine.Option(names={"--password"}, arity="0..1", description={"Passphrase"}, interactive=true, required=true)
    char[] password;
    @CommandLine.Option(names={"-o", "--output"}, arity="0..1", description={"File or directory to write configuration to. If not specified, the configuration is written to STDOUT."})
    File output;

    @Override
    public Integer call() {
        try {
            LinkedHashMap<String, Object> newUserData = new LinkedHashMap<String, Object>();
            if (this.sgRoles != null) {
                newUserData.put("search_guard_roles", this.sgRoles);
            }
            if (this.backendRoles != null) {
                newUserData.put("backend_roles", this.backendRoles);
            }
            if (this.attributes != null) {
                newUserData.put("attributes", this.attributes);
            }
            if (this.password != null) {
                newUserData.put("hash", AddUserLocal.hash(this.password));
                Arrays.fill(this.password, '\u0000');
            }
            String userYaml = DocWriter.yaml().writeAsString(ImmutableMap.of(this.userName, newUserData));
            if (this.output == null) {
                System.out.println(userYaml);
            } else {
                if (this.output.isDirectory()) {
                    this.output = new File(this.output, "sg_internal_users.yml");
                }
                if (this.output.exists()) {
                    Object existing = Files.asCharSource(this.output, Charsets.UTF_8).read();
                    if (!((String)existing).endsWith("\n")) {
                        existing = (String)existing + "\n";
                    }
                    System.out.println("Appending to " + String.valueOf(this.output));
                    if (userYaml.startsWith("---")) {
                        userYaml = userYaml.substring(3).trim();
                    }
                    Files.asCharSink(this.output, Charsets.UTF_8, new FileWriteMode[0]).write((String)existing + userYaml);
                } else {
                    System.out.println("Wrting to " + String.valueOf(this.output));
                    Files.asCharSink(this.output, Charsets.UTF_8, new FileWriteMode[0]).write(userYaml);
                }
            }
            return 0;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }

    private static String hash(char[] clearTextPassword) {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        String hash = OpenBSDBCrypt.generate(Objects.requireNonNull(clearTextPassword), salt, 12);
        Arrays.fill(salt, (byte)0);
        Arrays.fill(clearTextPassword, '\u0000');
        return hash;
    }
}

