/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.client.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ConfigType {
    CONFIG_VARS,
    AUTHC,
    AUTHZ_DLSFLS,
    AUTHZ,
    LICENSE_KEY,
    FRONTEND_MULTI_TENANCY,
    SESSIONS,
    AUTH_TOKEN_SERVICE,
    CONFIG,
    INTERNALUSERS,
    ACTIONGROUPS,
    ROLESMAPPING,
    ROLES,
    TENANTS,
    BLOCKS,
    FRONTEND_AUTHC;

    private static final Pattern HEADER_PATTERN;

    public String getApiName() {
        return this.name().toLowerCase();
    }

    public String getFileName() {
        if (this == CONFIG) {
            return "sg_config.yml";
        }
        if (this == INTERNALUSERS) {
            return "sg_internal_users.yml";
        }
        if (this == ROLESMAPPING) {
            return "sg_roles_mapping.yml";
        }
        if (this == ACTIONGROUPS) {
            return "sg_action_groups.yml";
        }
        return "sg_" + this.name().toLowerCase() + ".yml";
    }

    public static ConfigType get(String name) {
        return ConfigType.valueOf(name.toUpperCase());
    }

    public static ConfigType getFor(File file, DocNode content, String rawContent) throws ConfigValidationException {
        Matcher matcher;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(content, validationErrors);
        ConfigType result = (ConfigType)vNode.get("_sg_meta.type").asEnum(ConfigType.class);
        if (result != null) {
            return result;
        }
        if (rawContent != null && (matcher = HEADER_PATTERN.matcher(rawContent = rawContent.trim())).find()) {
            String name = matcher.group(1);
            ConfigType[] configTypeArray = ConfigType.values();
            int n = configTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ConfigType configType = configTypeArray[i];
                if (!name.equalsIgnoreCase(configType.name())) continue;
                return configType;
            }
        }
        validationErrors.throwExceptionForPresentErrors();
        String name = file.getName();
        if (name.startsWith("sg_")) {
            name = name.substring(3);
        }
        for (ConfigType configType : ConfigType.values()) {
            if (name.toUpperCase().startsWith(configType.name())) {
                return configType;
            }
            if (!name.replaceAll("_", "").toUpperCase().startsWith(configType.name())) continue;
            return configType;
        }
        throw new ConfigValidationException(new ValidationError(null, "Unknown config type"));
    }

    static {
        HEADER_PATTERN = Pattern.compile("^#\\s*sg_([a-z_]+)\\s*");
    }
}

