/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.client.api;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.SearchGuardRestClient;
import com.floragunn.searchguard.sgctl.client.api.ConfigType;
import com.google.common.collect.Iterators;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;

public class GetBulkConfigResponse
implements Iterable<ConfigDocument> {
    private final String searchGuardVersion;
    private Map<ConfigType, ConfigDocument> configMap = new EnumMap<ConfigType, ConfigDocument>(ConfigType.class);

    public GetBulkConfigResponse(String searchGuardVersion, DocNode docNode) {
        this.searchGuardVersion = searchGuardVersion;
        for (Map.Entry entry : docNode.entrySet()) {
            ConfigType configType;
            try {
                configType = ConfigType.get((String)entry.getKey());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Got unknown config type " + (String)entry.getKey() + " from API");
                continue;
            }
            this.configMap.put(configType, new ConfigDocument(configType, DocNode.wrap(entry.getValue())));
        }
    }

    public GetBulkConfigResponse(SearchGuardRestClient.Response response) throws InvalidResponseException {
        this(response.getSearchGuardVersion(), response.asDocNode());
    }

    public ConfigDocument get(ConfigType configType) {
        return this.configMap.get((Object)configType);
    }

    @Override
    public Iterator<ConfigDocument> iterator() {
        return Iterators.unmodifiableIterator(this.configMap.values().iterator());
    }

    public String getSearchGuardVersion() {
        return this.searchGuardVersion;
    }

    public static class ConfigDocument {
        private ConfigType configType;
        private DocNode content;
        private String etag;
        private boolean exists;

        public ConfigDocument(ConfigType configType, DocNode docNode) {
            this.content = docNode.hasNonNull("content") ? docNode.getAsNode("content") : DocNode.EMPTY;
            this.configType = configType;
            this.etag = docNode.getAsString("_etag");
            this.exists = Boolean.TRUE.equals(docNode.get("exists"));
        }

        public DocNode getContent() {
            return this.content;
        }

        public ConfigType getConfigType() {
            return this.configType;
        }

        public String getEtag() {
            return this.etag;
        }

        public boolean isExists() {
            return this.exists;
        }
    }
}

