/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.sgctl.commands;

import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.searchguard.sgctl.SgctlConfig;
import com.floragunn.searchguard.sgctl.SgctlException;
import com.floragunn.searchguard.sgctl.client.ApiException;
import com.floragunn.searchguard.sgctl.client.FailedConnectionException;
import com.floragunn.searchguard.sgctl.client.InvalidResponseException;
import com.floragunn.searchguard.sgctl.client.PreconditionFailedException;
import com.floragunn.searchguard.sgctl.client.ServiceUnavailableException;
import com.floragunn.searchguard.sgctl.client.UnauthorizedException;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import picocli.CommandLine;

public class BaseCommand {
    static final File DEFAULT_CONFIG_DIR = new File(System.getProperty("user.home"), ".searchguard");
    @CommandLine.Option(names={"-c", "--cluster"}, description={"The ID of the cluster configuration to be used by this command"})
    String clusterIdOption;
    @CommandLine.Option(names={"--debug"}, description={"Print debug information"})
    protected boolean debug;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Print more information"})
    protected boolean verbose;
    @CommandLine.Option(names={"--sgctl-config-dir"}, description={"The directory where sgctl reads from and writes to its configuration"})
    File customConfigDir;
    protected final ValidationErrors validationErrors = new ValidationErrors();
    private String selectedClusterId;
    private boolean selectedClusterIdInitialized;

    protected String getSelectedClusterId() throws SgctlException {
        if (!this.selectedClusterIdInitialized) {
            if (this.clusterIdOption != null) {
                this.selectedClusterId = this.clusterIdOption;
                this.selectedClusterIdInitialized = true;
            } else {
                File configFile = new File(this.getConfigDir(), "sgctl-selected-config.txt");
                try {
                    this.selectedClusterId = Files.asCharSource((File)configFile, (Charset)Charsets.UTF_8).readFirstLine();
                    this.selectedClusterIdInitialized = true;
                    if (this.verbose || this.debug) {
                        System.out.println("Selected cluster: " + this.selectedClusterId);
                    }
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new SgctlException("Error while reading " + String.valueOf(configFile), e);
                }
            }
        }
        return this.selectedClusterId;
    }

    protected void writeSelectedClusterId(String selectedClusterId) throws SgctlException {
        File configFile = new File(this.getConfigDir(), "sgctl-selected-config.txt");
        try {
            Files.asCharSink((File)configFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)selectedClusterId);
        }
        catch (IOException e) {
            throw new SgctlException("Error while writing " + selectedClusterId);
        }
    }

    protected SgctlConfig.Cluster getSelectedClusterConfig() throws SgctlException {
        String selectedClusterId = this.getSelectedClusterId();
        if (selectedClusterId == null || "none".equals(selectedClusterId)) {
            return null;
        }
        return SgctlConfig.Cluster.read(this.getConfigDir(), selectedClusterId);
    }

    protected File getConfigDir() throws SgctlException {
        if (this.customConfigDir != null) {
            if (this.customConfigDir.isFile()) {
                throw new SgctlException("The path specified by --sgctl-config-dir must be a directory");
            }
            return this.customConfigDir;
        }
        return DEFAULT_CONFIG_DIR;
    }

    protected void retryOnConcurrencyConflict(RetryableProcedure retryableProcedure) throws SgctlException, InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException, UnexpectedDocumentStructureException {
        int maxRetries = 3;
        int retry = 1;
        while (true) {
            try {
                retryableProcedure.run();
            }
            catch (PreconditionFailedException e) {
                if (++retry <= maxRetries) continue;
                throw new PreconditionFailedException("Could not perform operation due to concurrency conflict. Retried " + maxRetries + " times. Giving up now.", e);
            }
            break;
        }
    }

    @FunctionalInterface
    protected static interface RetryableProcedure {
        public void run() throws SgctlException, InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException, UnexpectedDocumentStructureException;
    }
}

